/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.recentfiles;

import java.awt.Frame;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.dnd.DropedFileExtractor;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesDialog;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesTreeCellRenderer;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandler;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandlerCallback;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RecentFilesController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RecentFilesDialog.class);
    private static final String PREF_KEY_RECENT_FILES_EXPANDED = "Squirrel.recentFiles.expanded";
    private static final String PREF_KEY_FAVOURITE_FILES_EXPANDED = "Squirrel.favouriteFiles.expanded";
    private static final String PREF_KEY_RECENT_ALIAS_FILES_EXPANDED = "Squirrel.recentAliasFiles.expanded";
    private static final String PREF_KEY_FAVOURITE_ALIAS_FILES_EXPANDED = "Squirrel.favouriteAliasFiles.expanded";
    private RecentFilesDialog _dialog;
    private IApplication _app;
    private Frame _parent;
    private ISQLAlias _selectedAlias;
    private DefaultMutableTreeNode _recentFilesNode;
    private DefaultMutableTreeNode _favouriteFilesNode;
    private DefaultMutableTreeNode _recentFilesForAliasNode;
    private DefaultMutableTreeNode _favouriteFilesForAliasNode;
    private File _fileToOpen;

    public RecentFilesController(IApplication app, ISQLAlias selectedAlias) {
        this.init(app, app.getMainFrame(), selectedAlias, true);
    }

    public RecentFilesController(ISQLPanelAPI panel) {
        Frame parent = GUIUtils.getOwningFrame(panel.getSQLEntryPanel().getTextComponent());
        this.init(panel.getSession().getApplication(), parent, panel.getSession().getAlias(), false);
    }

    private void init(IApplication app, Frame parent, final ISQLAlias selectedAlias, boolean showAppendOption) {
        this._app = app;
        this._parent = parent;
        this._selectedAlias = selectedAlias;
        this._dialog = new RecentFilesDialog(this._parent, showAppendOption);
        this._dialog.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFilesController.this._dialog.dispose();
            }
        });
        this.initAndLoadTree();
        this._dialog.txtNumberRecentFiles.setInt(this._app.getRecentFilesManager().getMaxRecentFiles());
        this._dialog.txtNumberRecentFiles.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RecentFilesController.this.updateRecentFilesCount();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RecentFilesController.this.updateRecentFilesCount();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RecentFilesController.this.updateRecentFilesCount();
            }
        });
        this._dialog.btnFavourites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFilesController.this.onAddToFavourites(null);
            }
        });
        this._dialog.btnAliasFavourites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFilesController.this.onAddToFavourites(selectedAlias);
            }
        });
        this._dialog.btnRemoveSeleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFilesController.this.onRemoveSelected();
            }
        });
        this._dialog.btnOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFilesController.this.onOpenFile();
            }
        });
        this._dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RecentFilesController.this.onWindowClosing();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                RecentFilesController.this.onWindowClosing();
            }
        });
        this._dialog.setVisible(true);
    }

    private void onOpenFile() {
        this._fileToOpen = this.findFileToOpen(null);
        if (null == this._fileToOpen) {
            return;
        }
        this._dialog.dispose();
    }

    private void onWindowClosing() {
        JTree tre = this._dialog.treFiles;
        tre.isCollapsed(new TreePath(this._recentFilesNode.getPath()));
        Preferences.userRoot().putBoolean(PREF_KEY_RECENT_FILES_EXPANDED, tre.isExpanded(new TreePath(this._recentFilesNode.getPath())));
        Preferences.userRoot().putBoolean(PREF_KEY_FAVOURITE_FILES_EXPANDED, tre.isExpanded(new TreePath(this._favouriteFilesNode.getPath())));
        Preferences.userRoot().putBoolean(PREF_KEY_RECENT_ALIAS_FILES_EXPANDED, tre.isExpanded(new TreePath(this._recentFilesForAliasNode.getPath())));
        Preferences.userRoot().putBoolean(PREF_KEY_FAVOURITE_ALIAS_FILES_EXPANDED, tre.isExpanded(new TreePath(this._favouriteFilesForAliasNode.getPath())));
    }

    private void onRemoveSelected() {
        HashSet<DefaultMutableTreeNode> changedParents = new HashSet<DefaultMutableTreeNode>();
        TreePath[] paths = this._dialog.treFiles.getSelectionPaths();
        DefaultTreeModel model = (DefaultTreeModel)this._dialog.treFiles.getModel();
        for (TreePath path : paths) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(dmtn.getUserObject() instanceof File)) continue;
            model.removeNodeFromParent(dmtn);
            changedParents.add((DefaultMutableTreeNode)path.getParentPath().getLastPathComponent());
        }
        for (DefaultMutableTreeNode changedParent : changedParents) {
            model.nodeStructureChanged(changedParent);
        }
        this.writeUiTreeToModel();
    }

    private void writeUiTreeToModel() {
        this._app.getRecentFilesManager().setRecentFiles(this.getFileStringsFromNode(this._recentFilesNode));
        this._app.getRecentFilesManager().setFavouriteFiles(this.getFileStringsFromNode(this._favouriteFilesNode));
        this._app.getRecentFilesManager().setRecentFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._recentFilesForAliasNode));
        this._app.getRecentFilesManager().setFavouriteFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._favouriteFilesForAliasNode));
    }

    private ArrayList<String> getFileStringsFromNode(DefaultMutableTreeNode parentNode) {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            File file = (File)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
            files.add(file.getAbsolutePath());
        }
        return files;
    }

    private void onAddToFavourites(ISQLAlias alias) {
        ArrayList<String> listToAddTo;
        DefaultMutableTreeNode nodeToAddTo;
        JFileChooser fc = new JFileChooser(this._app.getSquirrelPreferences().getFilePreviousDir());
        fc.setFileSelectionMode(2);
        int returnVal = fc.showOpenDialog(this._parent);
        if (returnVal != 0) {
            return;
        }
        if (null == alias) {
            this._app.getRecentFilesManager().adjustFavouriteFiles(fc.getSelectedFile());
            nodeToAddTo = this._favouriteFilesNode;
            listToAddTo = this._app.getRecentFilesManager().getFavouriteFiles();
        } else {
            this._app.getRecentFilesManager().adjustFavouriteAliasFiles(alias, fc.getSelectedFile());
            nodeToAddTo = this._favouriteFilesForAliasNode;
            listToAddTo = this._app.getRecentFilesManager().getFavouriteFilesForAlias(alias);
        }
        nodeToAddTo.removeAllChildren();
        this.addFileKidsToNode(nodeToAddTo, listToAddTo, false);
        DefaultTreeModel dtm = (DefaultTreeModel)this._dialog.treFiles.getModel();
        dtm.nodeStructureChanged(nodeToAddTo);
        this._dialog.treFiles.expandPath(new TreePath(nodeToAddTo.getPath()));
        DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)nodeToAddTo.getFirstChild();
        this._dialog.treFiles.scrollPathToVisible(new TreePath(firstChild.getPath()));
    }

    private void updateRecentFilesCount() {
        int maxRecentFiles = this._dialog.txtNumberRecentFiles.getInt();
        if (0 < maxRecentFiles) {
            this._app.getRecentFilesManager().setMaxRecentFiles(maxRecentFiles);
        }
    }

    private void initAndLoadTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this._dialog.treFiles.setModel(new DefaultTreeModel(root));
        this._dialog.treFiles.setRootVisible(false);
        this._dialog.treFiles.setCellRenderer(new RecentFilesTreeCellRenderer(this._app));
        this._recentFilesNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.recentFiles.global"));
        root.add(this._recentFilesNode);
        this.addFileKidsToNode(this._recentFilesNode, this._app.getRecentFilesManager().getRecentFiles(), Preferences.userRoot().getBoolean(PREF_KEY_RECENT_FILES_EXPANDED, true));
        this._favouriteFilesNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.favouritFiles.global"));
        root.add(this._favouriteFilesNode);
        this.addFileKidsToNode(this._favouriteFilesNode, this._app.getRecentFilesManager().getFavouriteFiles(), Preferences.userRoot().getBoolean(PREF_KEY_FAVOURITE_FILES_EXPANDED, false));
        this._recentFilesForAliasNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.recentFiles.alias", this._selectedAlias.getName()));
        root.add(this._recentFilesForAliasNode);
        this.addFileKidsToNode(this._recentFilesForAliasNode, this._app.getRecentFilesManager().getRecentFilesForAlias(this._selectedAlias), Preferences.userRoot().getBoolean(PREF_KEY_RECENT_ALIAS_FILES_EXPANDED, false));
        this._favouriteFilesForAliasNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.favouritFiles.alias", this._selectedAlias.getName()));
        root.add(this._favouriteFilesForAliasNode);
        this.addFileKidsToNode(this._favouriteFilesForAliasNode, this._app.getRecentFilesManager().getFavouriteFilesForAlias(this._selectedAlias), Preferences.userRoot().getBoolean(PREF_KEY_FAVOURITE_ALIAS_FILES_EXPANDED, false));
        this._dialog.treFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RecentFilesController.this.onMouseClickedTree(evt);
            }
        });
        this.initDnD();
    }

    private void initDnD() {
        TreeDnDHandlerCallback treeDnDHandlerCallback = new TreeDnDHandlerCallback(){

            @Override
            public boolean nodeAcceptsKids(DefaultMutableTreeNode selNode) {
                return RecentFilesController.this.onNodeAcceptsKids(selNode);
            }

            @Override
            public void dndExecuted() {
                RecentFilesController.this.onDndExecuted();
            }

            @Override
            public ArrayList<DefaultMutableTreeNode> createPasteTreeNodesFromExternalTransfer(DropTargetDropEvent dtde, TreePath targetPath) {
                return RecentFilesController.this.onCreatePasteTreeNodesFromExternalTransfer(dtde, targetPath);
            }
        };
        new TreeDnDHandler(this._dialog.treFiles, treeDnDHandlerCallback, true);
    }

    private ArrayList<DefaultMutableTreeNode> onCreatePasteTreeNodesFromExternalTransfer(DropTargetDropEvent dtde, TreePath targetPath) {
        List<File> files = DropedFileExtractor.getFiles(dtde, this._app);
        ArrayList<DefaultMutableTreeNode> ret = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode parent = this.findParent(targetPath);
        for (File file : files) {
            if (this.parentContainsFile(parent, file)) continue;
            ret.add(new DefaultMutableTreeNode(file));
        }
        return ret;
    }

    private boolean parentContainsFile(DefaultMutableTreeNode parentNode, File fileToCheck) {
        if (null == parentNode) {
            return false;
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            File file = (File)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
            if (!file.equals(fileToCheck)) continue;
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode findParent(TreePath targetPath) {
        if (((DefaultMutableTreeNode)targetPath.getLastPathComponent()).getUserObject() instanceof File) {
            targetPath = targetPath.getParentPath();
        }
        if (targetPath.getLastPathComponent() == this._recentFilesNode) {
            return this._recentFilesNode;
        }
        if (targetPath.getLastPathComponent() == this._recentFilesForAliasNode) {
            return this._recentFilesForAliasNode;
        }
        if (targetPath.getLastPathComponent() == this._favouriteFilesNode) {
            return this._favouriteFilesNode;
        }
        if (targetPath.getLastPathComponent() == this._favouriteFilesForAliasNode) {
            return this._favouriteFilesForAliasNode;
        }
        return null;
    }

    private void onDndExecuted() {
        this.writeUiTreeToModel();
    }

    private boolean onNodeAcceptsKids(DefaultMutableTreeNode selNode) {
        return this._recentFilesNode == selNode || this._recentFilesForAliasNode == selNode || this._favouriteFilesNode == selNode || this._favouriteFilesForAliasNode == selNode;
    }

    private void onMouseClickedTree(MouseEvent evt) {
        this._fileToOpen = this.findFileToOpen(evt);
        if (null != this._fileToOpen) {
            this._dialog.dispose();
        }
    }

    private File findFileToOpen(MouseEvent evt) {
        DefaultMutableTreeNode tn = this.getSelectedFileNode(evt);
        if (tn == null) {
            if (null == evt) {
                JOptionPane.showMessageDialog(this._dialog, s_stringMgr.getString("RecentFilesController.pleaseSelectFile"));
            }
            return null;
        }
        File file = (File)tn.getUserObject();
        if (!file.exists()) {
            if (0 == JOptionPane.showConfirmDialog(this._dialog, s_stringMgr.getString("RecentFilesController.fileDoesNotExist"))) {
                DefaultTreeModel model = (DefaultTreeModel)this._dialog.treFiles.getModel();
                TreeNode parent = tn.getParent();
                model.removeNodeFromParent(tn);
                model.nodeStructureChanged(parent);
                if (parent == this._recentFilesNode) {
                    this._app.getRecentFilesManager().setRecentFiles(this.getFileStringsFromNode(this._recentFilesNode));
                } else if (parent == this._favouriteFilesNode) {
                    this._app.getRecentFilesManager().setFavouriteFiles(this.getFileStringsFromNode(this._favouriteFilesNode));
                } else if (parent == this._recentFilesForAliasNode) {
                    this._app.getRecentFilesManager().setRecentFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._recentFilesForAliasNode));
                } else {
                    this._app.getRecentFilesManager().setFavouriteFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._favouriteFilesForAliasNode));
                }
            }
            return null;
        }
        if (file.isDirectory()) {
            JFileChooser fc = new JFileChooser(file);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this._parent);
            if (returnVal != 0) {
                return null;
            }
            file = fc.getSelectedFile();
        }
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(this._dialog, s_stringMgr.getString("RecentFilesController.fileIsNotReadable"));
            return null;
        }
        return file;
    }

    private DefaultMutableTreeNode getSelectedFileNode(MouseEvent evt) {
        DefaultMutableTreeNode tn;
        TreePath path = this._dialog.treFiles.getSelectionPath();
        if (null == path) {
            return null;
        }
        if (null != evt) {
            if (evt.getClickCount() < 2) {
                return null;
            }
            if (!this._dialog.treFiles.getPathBounds(path).contains(evt.getPoint())) {
                return null;
            }
        }
        if (!((tn = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof File)) {
            return null;
        }
        return tn;
    }

    private void addFileKidsToNode(final DefaultMutableTreeNode parentNode, ArrayList<String> filePaths, final boolean expand) {
        for (String filePath : filePaths) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new File(filePath));
            parentNode.add(node);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (expand) {
                    ((RecentFilesController)RecentFilesController.this)._dialog.treFiles.expandPath(new TreePath(parentNode.getPath()));
                }
            }
        });
    }

    public File getFileToOpen() {
        return this._fileToOpen;
    }

    public boolean isAppend() {
        return this._dialog.chkAppend.isSelected();
    }
}

