/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.util.Comparator;

public class NumberComparator
implements Comparator {
    public static final ComparatorContext CONTEXT_ABSOLUTE = new ComparatorContext("AbsoluteValue");
    private static NumberComparator singleton = null;
    private boolean _absolute = false;

    protected NumberComparator() {
    }

    public static NumberComparator getInstance() {
        if (singleton == null) {
            singleton = new NumberComparator();
        }
        return singleton;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Number) {
            if (o2 instanceof Number) {
                double d1 = ((Number)o1).doubleValue();
                double d2 = ((Number)o2).doubleValue();
                if (this.isAbsolute() && d1 < 0.0) {
                    d1 = -d1;
                }
                if (this.isAbsolute() && d2 < 0.0) {
                    d2 = -d2;
                }
                if (d1 < d2) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException("The first argument of this method was not a Number but " + o2.getClass().getName());
        }
        if (o2 instanceof Number) {
            throw new ClassCastException("The second argument of this method was not a Number but " + o1.getClass().getName());
        }
        throw new ClassCastException("Both arguments of this method were not Numbers. They are " + o1.getClass().getName() + " and " + o2.getClass().getName());
    }

    public boolean isAbsolute() {
        return this._absolute;
    }

    public void setAbsolute(boolean absolute) {
        this._absolute = absolute;
    }
}

