/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.pig.StorageHelper;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CassandraStorage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata {
    public static final String PIG_ALLOW_DELETES = "PIG_ALLOW_DELETES";
    public static final String PIG_WIDEROW_INPUT = "PIG_WIDEROW_INPUT";
    public static final String PIG_USE_SECONDARY = "PIG_USE_SECONDARY";
    private static final ByteBuffer BOUND = ByteBufferUtil.EMPTY_BYTE_BUFFER;
    private static final Logger logger = LoggerFactory.getLogger(CassandraStorage.class);
    private ByteBuffer slice_start = BOUND;
    private ByteBuffer slice_end = BOUND;
    private boolean slice_reverse = false;
    private boolean allow_deletes = false;
    private RecordReader<ByteBuffer, Map<ByteBuffer, ColumnFamilyRecordReader.Column>> reader;
    private RecordWriter<ByteBuffer, List<Mutation>> writer;
    private boolean widerows = false;
    private int limit;
    protected String DEFAULT_INPUT_FORMAT;
    protected String DEFAULT_OUTPUT_FORMAT;
    protected String username;
    protected String password;
    protected String keyspace;
    protected String column_family;
    protected String loadSignature;
    protected String storeSignature;
    protected Configuration conf;
    protected String inputFormatClass;
    protected String outputFormatClass;
    protected int splitSize = 65536;
    protected String partitionerClass;
    protected boolean usePartitionFilter = false;
    protected String initHostAddress;
    protected String rpcPort;
    protected int nativeProtocolVersion = 1;
    private ByteBuffer lastKey;
    private Map<ByteBuffer, ColumnFamilyRecordReader.Column> lastRow;
    private boolean hasNext = true;

    public CassandraStorage() {
        this(1024);
    }

    public CassandraStorage(int limit) {
        this.limit = limit;
        this.DEFAULT_INPUT_FORMAT = "org.apache.cassandra.hadoop.ColumnFamilyInputFormat";
        this.DEFAULT_OUTPUT_FORMAT = "org.apache.cassandra.hadoop.ColumnFamilyOutputFormat";
    }

    public int getLimit() {
        return this.limit;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    public Tuple getNextWide() throws IOException {
        CfDef cfDef = this.getCfDef(this.loadSignature);
        ByteBuffer key = null;
        Tuple tuple = null;
        DefaultDataBag bag = new DefaultDataBag();
        try {
            block2: while (true) {
                this.hasNext = this.reader.nextKeyValue();
                if (!this.hasNext) {
                    if (tuple == null) {
                        tuple = TupleFactory.getInstance().newTuple();
                    }
                    if (this.lastRow != null) {
                        if (tuple.size() == 0) {
                            key = (ByteBuffer)this.reader.getCurrentKey();
                            tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        }
                        for (Map.Entry<ByteBuffer, ColumnFamilyRecordReader.Column> entry : this.lastRow.entrySet()) {
                            bag.add(this.columnToTuple(entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                        }
                        this.lastKey = null;
                        this.lastRow = null;
                        tuple.append((Object)bag);
                        return tuple;
                    }
                    if (tuple.size() == 1) {
                        tuple.append((Object)bag);
                        return tuple;
                    }
                    return null;
                }
                if (key != null && !((ByteBuffer)this.reader.getCurrentKey()).equals(key)) {
                    this.lastKey = (ByteBuffer)this.reader.getCurrentKey();
                    this.lastRow = (Map)this.reader.getCurrentValue();
                    tuple.append((Object)bag);
                    return tuple;
                }
                if (key == null) {
                    key = (ByteBuffer)this.reader.getCurrentKey();
                    if (this.lastKey != null && !key.equals(this.lastKey)) {
                        if (tuple == null) {
                            tuple = this.keyToTuple(this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        } else {
                            this.addKeyToTuple(tuple, this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        }
                        for (Map.Entry<ByteBuffer, ColumnFamilyRecordReader.Column> entry : this.lastRow.entrySet()) {
                            bag.add(this.columnToTuple(entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                        }
                        tuple.append((Object)bag);
                        this.lastKey = key;
                        this.lastRow = (Map)this.reader.getCurrentValue();
                        return tuple;
                    }
                    if (tuple == null) {
                        tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
                    } else {
                        this.addKeyToTuple(tuple, this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                    }
                }
                SortedMap row = (SortedMap)this.reader.getCurrentValue();
                if (this.lastRow != null) {
                    for (Map.Entry<Object, Object> entry : this.lastRow.entrySet()) {
                        bag.add(this.columnToTuple((ColumnFamilyRecordReader.Column)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                    }
                    this.lastKey = null;
                    this.lastRow = null;
                }
                Iterator<Map.Entry<Object, Object>> iterator = row.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    Map.Entry<Object, Object> entry = iterator.next();
                    bag.add(this.columnToTuple((ColumnFamilyRecordReader.Column)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Tuple getNext() throws IOException {
        if (this.widerows) {
            return this.getNextWide();
        }
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            CfDef cfDef = this.getCfDef(this.loadSignature);
            ByteBuffer key = (ByteBuffer)this.reader.getCurrentKey();
            Map cf = (Map)this.reader.getCurrentValue();
            assert (key != null && cf != null);
            Tuple tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
            DefaultDataBag bag = new DefaultDataBag();
            HashMap<ByteBuffer, Boolean> added = new HashMap<ByteBuffer, Boolean>(cfDef.column_metadata.size());
            for (ColumnDef columnDef : cfDef.column_metadata) {
                boolean hasColumn = false;
                boolean cql3Table = false;
                try {
                    hasColumn = cf.containsKey(columnDef.name);
                }
                catch (Exception e) {
                    cql3Table = true;
                }
                if (hasColumn) {
                    tuple.append((Object)this.columnToTuple((ColumnFamilyRecordReader.Column)cf.get(columnDef.name), cfDef, this.parseType(cfDef.getComparator_type())));
                } else if (!cql3Table) {
                    tuple.append((Object)TupleFactory.getInstance().newTuple());
                }
                added.put(columnDef.name, true);
            }
            for (Map.Entry entry : cf.entrySet()) {
                if (added.containsKey(entry.getKey())) continue;
                bag.add(this.columnToTuple((ColumnFamilyRecordReader.Column)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
            }
            tuple.append((Object)bag);
            if (this.usePartitionFilter) {
                for (ColumnDef columnDef : this.getIndexes()) {
                    Tuple throwaway = this.columnToTuple((ColumnFamilyRecordReader.Column)cf.get(columnDef.name), cfDef, this.parseType(cfDef.getComparator_type()));
                    tuple.append(throwaway.get(1));
                }
            }
            return tuple;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void putNext(Tuple t) throws IOException {
        if (t.size() < 1) {
            logger.warn("Empty output skipped, filter empty tuples to suppress this warning");
            return;
        }
        ByteBuffer key = this.objToBB(t.get(0));
        if (t.getType(1) == 110) {
            this.writeColumnsFromTuple(key, t, 1);
        } else if (t.getType(1) == 120) {
            if (t.size() > 2) {
                throw new IOException("No arguments allowed after bag");
            }
            this.writeColumnsFromBag(key, (DataBag)t.get(1));
        } else {
            throw new IOException("Second argument in output must be a tuple or bag");
        }
    }

    protected void setConnectionInformation() throws IOException {
        StorageHelper.setConnectionInformation(this.conf);
        this.inputFormatClass = System.getenv("PIG_INPUT_FORMAT") != null ? this.getFullyQualifiedClassName(System.getenv("PIG_INPUT_FORMAT")) : this.DEFAULT_INPUT_FORMAT;
        this.outputFormatClass = System.getenv("PIG_OUTPUT_FORMAT") != null ? this.getFullyQualifiedClassName(System.getenv("PIG_OUTPUT_FORMAT")) : this.DEFAULT_OUTPUT_FORMAT;
        if (System.getenv(PIG_ALLOW_DELETES) != null) {
            this.allow_deletes = Boolean.parseBoolean(System.getenv(PIG_ALLOW_DELETES));
        }
    }

    protected String getFullyQualifiedClassName(String classname) {
        return classname.contains(".") ? classname : "org.apache.cassandra.hadoop." + classname;
    }

    public void setLocation(String location, Job job) throws IOException {
        this.conf = HadoopCompat.getConfiguration((JobContext)job);
        this.setLocationFromUri(location);
        if (ConfigHelper.getInputSlicePredicate(this.conf) == null) {
            SliceRange range = new SliceRange(this.slice_start, this.slice_end, this.slice_reverse, this.limit);
            SlicePredicate predicate = new SlicePredicate().setSlice_range(range);
            ConfigHelper.setInputSlicePredicate(this.conf, predicate);
        }
        if (System.getenv(PIG_WIDEROW_INPUT) != null) {
            this.widerows = Boolean.parseBoolean(System.getenv(PIG_WIDEROW_INPUT));
        }
        if (System.getenv(PIG_USE_SECONDARY) != null) {
            this.usePartitionFilter = Boolean.parseBoolean(System.getenv(PIG_USE_SECONDARY));
        }
        if (System.getenv("PIG_INPUT_SPLIT_SIZE") != null) {
            try {
                ConfigHelper.setInputSplitSize(this.conf, Integer.parseInt(System.getenv("PIG_INPUT_SPLIT_SIZE")));
            }
            catch (NumberFormatException e) {
                throw new IOException("PIG_INPUT_SPLIT_SIZE is not a number", e);
            }
        }
        if (this.usePartitionFilter && this.getIndexExpressions() != null) {
            ConfigHelper.setInputRange(this.conf, this.getIndexExpressions());
        }
        if (this.username != null && this.password != null) {
            ConfigHelper.setInputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setInputPartitioner(this.conf, this.partitionerClass);
        }
        if (this.rpcPort != null) {
            ConfigHelper.setInputRpcPort(this.conf, this.rpcPort);
        }
        if (this.initHostAddress != null) {
            ConfigHelper.setInputInitialAddress(this.conf, this.initHostAddress);
        }
        ConfigHelper.setInputColumnFamily(this.conf, this.keyspace, this.column_family, this.widerows);
        this.setConnectionInformation();
        if (ConfigHelper.getInputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_INPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getInputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_INPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getInputPartitioner(this.conf) == null) {
            throw new IOException("PIG_INPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (this.loadSignature == null) {
            this.loadSignature = location;
        }
        this.initSchema(this.loadSignature);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.conf = HadoopCompat.getConfiguration((JobContext)job);
        this.conf.setBoolean("pig.noSplitCombination", true);
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setOutputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setOutputPartitioner(this.conf, this.partitionerClass);
        }
        if (this.rpcPort != null) {
            ConfigHelper.setOutputRpcPort(this.conf, this.rpcPort);
            ConfigHelper.setInputRpcPort(this.conf, this.rpcPort);
        }
        if (this.initHostAddress != null) {
            ConfigHelper.setOutputInitialAddress(this.conf, this.initHostAddress);
            ConfigHelper.setInputInitialAddress(this.conf, this.initHostAddress);
        }
        ConfigHelper.setOutputColumnFamily(this.conf, this.keyspace, this.column_family);
        this.setConnectionInformation();
        if (ConfigHelper.getOutputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_OUTPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getOutputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getOutputPartitioner(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (System.getenv(PIG_USE_SECONDARY) != null) {
            this.usePartitionFilter = Boolean.parseBoolean(System.getenv(PIG_USE_SECONDARY));
        }
        this.initSchema(this.storeSignature);
    }

    protected void initSchema(String signature) throws IOException {
        Properties properties = UDFContext.getUDFContext().getUDFProperties(CassandraStorage.class);
        if (!properties.containsKey(signature)) {
            try {
                CfDef cfDef;
                Cassandra.Client client = ConfigHelper.getClientFromInputAddressList(this.conf);
                client.set_keyspace(this.keyspace);
                if (this.username != null && this.password != null) {
                    HashMap<String, String> credentials = new HashMap<String, String>(2);
                    credentials.put("username", this.username);
                    credentials.put("password", this.password);
                    try {
                        client.login(new AuthenticationRequest(credentials));
                    }
                    catch (AuthenticationException e) {
                        logger.error("Authentication exception: invalid username and/or password");
                        throw new IOException(e);
                    }
                }
                if ((cfDef = this.getCfDef(client)) == null) {
                    throw new IOException(String.format("Table '%s' not found in keyspace '%s'", this.column_family, this.keyspace));
                }
                StringBuilder sb = new StringBuilder();
                sb.append(CassandraStorage.cfdefToString(cfDef));
                properties.setProperty(signature, sb.toString());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        this.setLocation(location, job);
        CfDef cfDef = this.getCfDef(this.loadSignature);
        if (cfDef.column_type.equals("Super")) {
            return null;
        }
        ResourceSchema schema = new ResourceSchema();
        Map<MarshallerType, AbstractType> marshallers = this.getDefaultMarshallers(cfDef);
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
        ResourceSchema.ResourceFieldSchema keyFieldSchema = new ResourceSchema.ResourceFieldSchema();
        keyFieldSchema.setName("key");
        keyFieldSchema.setType(StorageHelper.getPigType(marshallers.get((Object)MarshallerType.KEY_VALIDATOR)));
        ResourceSchema bagSchema = new ResourceSchema();
        ResourceSchema.ResourceFieldSchema bagField = new ResourceSchema.ResourceFieldSchema();
        bagField.setType((byte)120);
        bagField.setName("columns");
        ResourceSchema bagTupleSchema = new ResourceSchema();
        ResourceSchema.ResourceFieldSchema bagTupleField = new ResourceSchema.ResourceFieldSchema();
        bagTupleField.setType((byte)110);
        ResourceSchema.ResourceFieldSchema bagcolSchema = new ResourceSchema.ResourceFieldSchema();
        ResourceSchema.ResourceFieldSchema bagvalSchema = new ResourceSchema.ResourceFieldSchema();
        bagcolSchema.setName("name");
        bagvalSchema.setName("value");
        bagcolSchema.setType(StorageHelper.getPigType(marshallers.get((Object)MarshallerType.COMPARATOR)));
        bagvalSchema.setType(StorageHelper.getPigType(marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR)));
        bagTupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagcolSchema, bagvalSchema});
        bagTupleField.setSchema(bagTupleSchema);
        bagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagTupleField});
        bagField.setSchema(bagSchema);
        ArrayList<ResourceSchema.ResourceFieldSchema> allSchemaFields = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        allSchemaFields.add(keyFieldSchema);
        if (!this.widerows) {
            for (ColumnDef cdef : cfDef.column_metadata) {
                ResourceSchema innerTupleSchema = new ResourceSchema();
                ResourceSchema.ResourceFieldSchema innerTupleField = new ResourceSchema.ResourceFieldSchema();
                innerTupleField.setType((byte)110);
                innerTupleField.setSchema(innerTupleSchema);
                innerTupleField.setName(new String(cdef.getName()));
                ResourceSchema.ResourceFieldSchema idxColSchema = new ResourceSchema.ResourceFieldSchema();
                idxColSchema.setName("name");
                idxColSchema.setType(StorageHelper.getPigType(marshallers.get((Object)MarshallerType.COMPARATOR)));
                ResourceSchema.ResourceFieldSchema valSchema = new ResourceSchema.ResourceFieldSchema();
                AbstractType validator = validators.get(cdef.name);
                if (validator == null) {
                    validator = marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR);
                }
                valSchema.setName("value");
                valSchema.setType(StorageHelper.getPigType(validator));
                innerTupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{idxColSchema, valSchema});
                allSchemaFields.add(innerTupleField);
            }
        }
        allSchemaFields.add(bagField);
        if (this.usePartitionFilter) {
            for (ColumnDef cdef : this.getIndexes()) {
                ResourceSchema.ResourceFieldSchema idxSchema = new ResourceSchema.ResourceFieldSchema();
                idxSchema.setName("index_" + new String(cdef.getName()));
                AbstractType validator = validators.get(cdef.name);
                if (validator == null) {
                    validator = marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR);
                }
                idxSchema.setType(StorageHelper.getPigType(validator));
                allSchemaFields.add(idxSchema);
            }
        }
        schema.setFields(allSchemaFields.toArray(new ResourceSchema.ResourceFieldSchema[allSchemaFields.size()]));
        return schema;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CassandraStorage.class);
        property.setProperty("cassandra.partition.filter", CassandraStorage.indexExpressionsToString(this.filterToIndexExpressions(partitionFilter)));
    }

    public void prepareToWrite(RecordWriter writer) {
        this.writer = writer;
    }

    protected ByteBuffer objToBB(Object o) {
        if (o == null) {
            return this.nullToBB();
        }
        if (o instanceof String) {
            return ByteBuffer.wrap(new DataByteArray((String)o).get());
        }
        if (o instanceof Integer) {
            return Int32Type.instance.decompose((Integer)o);
        }
        if (o instanceof Long) {
            return LongType.instance.decompose((Long)o);
        }
        if (o instanceof Float) {
            return FloatType.instance.decompose((Float)o);
        }
        if (o instanceof Double) {
            return DoubleType.instance.decompose((Double)o);
        }
        if (o instanceof UUID) {
            return ByteBuffer.wrap(UUIDGen.decompose((UUID)o));
        }
        if (o instanceof Tuple) {
            List objects = ((Tuple)o).getAll();
            if (objects.size() > 0 && objects.get(0) instanceof String) {
                String collectionType = (String)objects.get(0);
                if ("set".equalsIgnoreCase(collectionType) || "list".equalsIgnoreCase(collectionType)) {
                    return this.objToListOrSetBB(objects.subList(1, objects.size()));
                }
                if ("map".equalsIgnoreCase(collectionType)) {
                    return this.objToMapBB(objects.subList(1, objects.size()));
                }
            }
            return this.objToCompositeBB(objects);
        }
        return ByteBuffer.wrap(((DataByteArray)o).get());
    }

    private ByteBuffer objToListOrSetBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size());
        for (Object sub : objects) {
            ByteBuffer buffer = this.objToBB(sub);
            serialized.add(buffer);
        }
        return CollectionSerializer.pack(serialized, objects.size(), 1);
    }

    private ByteBuffer objToMapBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size() * 2);
        for (Object sub : objects) {
            List keyValue = ((Tuple)sub).getAll();
            for (Object entry : keyValue) {
                ByteBuffer buffer = this.objToBB(entry);
                serialized.add(buffer);
            }
        }
        return CollectionSerializer.pack(serialized, objects.size(), 1);
    }

    private ByteBuffer objToCompositeBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size());
        int totalLength = 0;
        for (Object sub : objects) {
            ByteBuffer buffer = this.objToBB(sub);
            serialized.add(buffer);
            totalLength += 2 + buffer.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer bb : serialized) {
            int length = bb.remaining();
            out.put((byte)(length >> 8 & 0xFF));
            out.put((byte)(length & 0xFF));
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private void writeColumnsFromTuple(ByteBuffer key, Tuple t, int offset) throws IOException {
        ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
        for (int i = offset; i < t.size(); ++i) {
            if (t.getType(i) == 120) {
                this.writeColumnsFromBag(key, (DataBag)t.get(i));
                continue;
            }
            if (t.getType(i) == 110) {
                Tuple inner = (Tuple)t.get(i);
                if (inner.size() <= 0) continue;
                mutationList.add(this.mutationFromTuple(inner));
                continue;
            }
            if (this.usePartitionFilter) continue;
            throw new IOException("Output type was not a bag or a tuple");
        }
        if (mutationList.size() > 0) {
            this.writeMutations(key, mutationList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Mutation mutationFromTuple(Tuple t) throws IOException {
        Mutation mutation = new Mutation();
        if (t.get(1) == null) {
            if (!this.allow_deletes) throw new IOException("null found but deletes are disabled, set PIG_ALLOW_DELETES=true in environment or allow_deletes=true in URL to enable");
            mutation.deletion = new Deletion();
            mutation.deletion.predicate = new SlicePredicate();
            mutation.deletion.predicate.column_names = Arrays.asList(this.objToBB(t.get(0)));
            mutation.deletion.setTimestamp(FBUtilities.timestampMicros());
            return mutation;
        } else {
            Column column = new Column();
            column.setName(this.objToBB(t.get(0)));
            column.setValue(this.objToBB(t.get(1)));
            column.setTimestamp(FBUtilities.timestampMicros());
            mutation.column_or_supercolumn = new ColumnOrSuperColumn();
            mutation.column_or_supercolumn.column = column;
        }
        return mutation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeColumnsFromBag(ByteBuffer key, DataBag bag) throws IOException {
        ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
        for (Tuple pair : bag) {
            Mutation mutation = new Mutation();
            if (DataType.findType((Object)pair.get(1)) == 120) {
                SuperColumn sc = new SuperColumn();
                sc.setName(this.objToBB(pair.get(0)));
                ArrayList<Column> columns = new ArrayList<Column>();
                for (Tuple subcol : (DataBag)pair.get(1)) {
                    Column column = new Column();
                    column.setName(this.objToBB(subcol.get(0)));
                    column.setValue(this.objToBB(subcol.get(1)));
                    column.setTimestamp(FBUtilities.timestampMicros());
                    columns.add(column);
                }
                if (columns.isEmpty()) {
                    if (!this.allow_deletes) throw new IOException("SuperColumn deletion attempted with empty bag, but deletes are disabled, set PIG_ALLOW_DELETES=true in environment or allow_deletes=true in URL to enable");
                    mutation.deletion = new Deletion();
                    mutation.deletion.super_column = this.objToBB(pair.get(0));
                    mutation.deletion.setTimestamp(FBUtilities.timestampMicros());
                } else {
                    sc.columns = columns;
                    mutation.column_or_supercolumn = new ColumnOrSuperColumn();
                    mutation.column_or_supercolumn.super_column = sc;
                }
            } else {
                mutation = this.mutationFromTuple(pair);
            }
            mutationList.add(mutation);
            if (mutationList.size() < 10) continue;
            this.writeMutations(key, mutationList);
            mutationList.clear();
        }
        if (mutationList.size() <= 0) return;
        this.writeMutations(key, mutationList);
    }

    private void writeMutations(ByteBuffer key, List<Mutation> mutations) throws IOException {
        try {
            this.writer.write((Object)key, mutations);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected List<ColumnDef> getIndexes() throws IOException {
        CfDef cfdef = this.getCfDef(this.loadSignature);
        ArrayList<ColumnDef> indexes = new ArrayList<ColumnDef>();
        for (ColumnDef cdef : cfdef.column_metadata) {
            if (cdef.index_type == null) continue;
            indexes.add(cdef);
        }
        return indexes;
    }

    private List<IndexExpression> filterToIndexExpressions(Expression expression) throws IOException {
        ArrayList<IndexExpression> indexExpressions = new ArrayList<IndexExpression>();
        Expression.BinaryExpression be = (Expression.BinaryExpression)expression;
        ByteBuffer name = ByteBuffer.wrap(be.getLhs().toString().getBytes());
        ByteBuffer value = ByteBuffer.wrap(be.getRhs().toString().getBytes());
        switch (expression.getOpType()) {
            case OP_EQ: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.EQ, value));
                break;
            }
            case OP_GE: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.GTE, value));
                break;
            }
            case OP_GT: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.GT, value));
                break;
            }
            case OP_LE: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.LTE, value));
                break;
            }
            case OP_LT: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.LT, value));
                break;
            }
            case OP_AND: {
                indexExpressions.addAll(this.filterToIndexExpressions(be.getLhs()));
                indexExpressions.addAll(this.filterToIndexExpressions(be.getRhs()));
                break;
            }
            default: {
                throw new IOException("Unsupported expression type: " + expression.getOpType().name());
            }
        }
        return indexExpressions;
    }

    private static String indexExpressionsToString(List<IndexExpression> indexExpressions) throws IOException {
        assert (indexExpressions != null);
        IndexClause indexClause = new IndexClause();
        indexClause.setExpressions(indexExpressions);
        indexClause.setStart_key("".getBytes());
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return Hex.bytesToHex(serializer.serialize((TBase)indexClause));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    private static List<IndexExpression> indexExpressionsFromString(String ie) throws IOException {
        assert (ie != null);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        IndexClause indexClause = new IndexClause();
        try {
            deserializer.deserialize((TBase)indexClause, Hex.hexToBytes(ie));
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return indexClause.getExpressions();
    }

    public ResourceStatistics getStatistics(String location, Job job) {
        return null;
    }

    public void cleanupOnFailure(String failure, Job job) {
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.storeSignature = signature;
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return this.relativeToAbsolutePath(location, curDir);
    }

    public OutputFormat getOutputFormat() throws IOException {
        try {
            return (OutputFormat)FBUtilities.construct(this.outputFormatClass, "outputformat");
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public InputFormat getInputFormat() throws IOException {
        try {
            return (InputFormat)FBUtilities.construct(this.inputFormatClass, "inputformat");
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    private List<IndexExpression> getIndexExpressions() throws IOException {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CassandraStorage.class);
        if (property.getProperty("cassandra.partition.filter") != null) {
            return CassandraStorage.indexExpressionsFromString(property.getProperty("cassandra.partition.filter"));
        }
        return null;
    }

    protected List<ColumnDef> getColumnMetadata(Cassandra.Client client) throws TException, CharacterCodingException, InvalidRequestException, ConfigurationException {
        return this.getColumnMeta(client, true, true);
    }

    protected List<ColumnDef> getColumnMeta(Cassandra.Client client, boolean cassandraStorage, boolean includeCompactValueColumn) throws org.apache.cassandra.thrift.InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException, CharacterCodingException, InvalidRequestException, ConfigurationException, NotFoundException {
        String query = String.format("SELECT column_name, validator, index_type, type FROM %s.%s WHERE keyspace_name = '%s' AND columnfamily_name = '%s'", "system", "schema_columns", this.keyspace, this.column_family);
        CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(query), Compression.NONE, ConsistencyLevel.ONE);
        List rows = result.rows;
        ArrayList<ColumnDef> columnDefs = new ArrayList<ColumnDef>();
        if (rows == null || rows.isEmpty()) {
            if (cassandraStorage) {
                return columnDefs;
            }
            CFMetaData cfm = this.getCFMetaData(this.keyspace, this.column_family, client);
            for (ColumnDefinition def : cfm.regularAndStaticColumns()) {
                ColumnDef cDef = new ColumnDef();
                String columnName = def.name.toString();
                String type = def.type.toString();
                logger.trace("name: {}, type: {} ", (Object)columnName, (Object)type);
                cDef.name = ByteBufferUtil.bytes(columnName);
                cDef.validation_class = type;
                columnDefs.add(cDef);
            }
            if (columnDefs.size() == 0 && includeCompactValueColumn && cfm.compactValueColumn() != null) {
                ColumnDefinition def = cfm.compactValueColumn();
                if ("value".equals(def.name.toString())) {
                    ColumnDef cDef = new ColumnDef();
                    cDef.name = def.name.bytes;
                    cDef.validation_class = def.type.toString();
                    columnDefs.add(cDef);
                }
            }
            return columnDefs;
        }
        for (CqlRow row : rows) {
            ColumnDef cDef = new ColumnDef();
            String type = ByteBufferUtil.string(((Column)row.getColumns().get((int)3)).value);
            if (!type.equals("regular")) continue;
            cDef.setName(ByteBufferUtil.clone(((Column)row.getColumns().get((int)0)).value));
            cDef.validation_class = ByteBufferUtil.string(((Column)row.getColumns().get((int)1)).value);
            ByteBuffer indexType = ((Column)row.getColumns().get((int)2)).value;
            if (indexType != null) {
                cDef.index_type = this.getIndexType(ByteBufferUtil.string(indexType));
            }
            columnDefs.add(cDef);
        }
        return columnDefs;
    }

    protected CFMetaData getCFMetaData(String ks, String cf, Cassandra.Client client) throws NotFoundException, org.apache.cassandra.thrift.InvalidRequestException, TException, InvalidRequestException, ConfigurationException {
        KsDef ksDef = client.describe_keyspace(ks);
        for (CfDef cfDef : ksDef.cf_defs) {
            if (!cfDef.name.equalsIgnoreCase(cf)) continue;
            return ThriftConversion.fromThrift(cfDef);
        }
        return null;
    }

    protected IndexType getIndexType(String type) {
        if ("keys".equals(type = type.toLowerCase())) {
            return IndexType.KEYS;
        }
        if ("custom".equals(type)) {
            return IndexType.CUSTOM;
        }
        if ("composites".equals(type)) {
            return IndexType.COMPOSITES;
        }
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        if (!this.usePartitionFilter) {
            return null;
        }
        List<ColumnDef> indexes = this.getIndexes();
        String[] partitionKeys = new String[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            partitionKeys[i] = new String(indexes.get(i).getName());
        }
        return partitionKeys;
    }

    private Tuple keyToTuple(ByteBuffer key, CfDef cfDef, AbstractType comparator) throws IOException {
        Tuple tuple = TupleFactory.getInstance().newTuple(1);
        this.addKeyToTuple(tuple, key, cfDef, comparator);
        return tuple;
    }

    private void addKeyToTuple(Tuple tuple, ByteBuffer key, CfDef cfDef, AbstractType comparator) throws IOException {
        if (comparator instanceof AbstractCompositeType) {
            StorageHelper.setTupleValue(tuple, 0, this.composeComposite((AbstractCompositeType)comparator, key));
        } else {
            StorageHelper.setTupleValue(tuple, 0, StorageHelper.cassandraToObj(this.getDefaultMarshallers(cfDef).get((Object)MarshallerType.KEY_VALIDATOR), key, this.nativeProtocolVersion));
        }
    }

    protected Tuple composeComposite(AbstractCompositeType comparator, ByteBuffer name) throws IOException {
        List<AbstractCompositeType.CompositeComponent> result = comparator.deconstruct(name);
        Tuple t = TupleFactory.getInstance().newTuple(result.size());
        for (int i = 0; i < result.size(); ++i) {
            StorageHelper.setTupleValue(t, i, StorageHelper.cassandraToObj(result.get((int)i).comparator, result.get((int)i).value, this.nativeProtocolVersion));
        }
        return t;
    }

    private void setLocationFromUri(String location) throws IOException {
        try {
            String[] parts;
            String[] credentialsAndKeyspace;
            if (!location.startsWith("cassandra://")) {
                throw new Exception("Bad scheme." + location);
            }
            String[] urlParts = location.split("\\?");
            if (urlParts.length > 1) {
                Map<String, String> urlQuery = CassandraStorage.getQueryMap(urlParts[1]);
                AbstractType comparator = BytesType.instance;
                if (urlQuery.containsKey("comparator")) {
                    comparator = TypeParser.parse(urlQuery.get("comparator"));
                }
                if (urlQuery.containsKey("slice_start")) {
                    this.slice_start = comparator.fromString(urlQuery.get("slice_start"));
                }
                if (urlQuery.containsKey("slice_end")) {
                    this.slice_end = comparator.fromString(urlQuery.get("slice_end"));
                }
                if (urlQuery.containsKey("reversed")) {
                    this.slice_reverse = Boolean.parseBoolean(urlQuery.get("reversed"));
                }
                if (urlQuery.containsKey("limit")) {
                    this.limit = Integer.parseInt(urlQuery.get("limit"));
                }
                if (urlQuery.containsKey("allow_deletes")) {
                    this.allow_deletes = Boolean.parseBoolean(urlQuery.get("allow_deletes"));
                }
                if (urlQuery.containsKey("widerows")) {
                    this.widerows = Boolean.parseBoolean(urlQuery.get("widerows"));
                }
                if (urlQuery.containsKey("use_secondary")) {
                    this.usePartitionFilter = Boolean.parseBoolean(urlQuery.get("use_secondary"));
                }
                if (urlQuery.containsKey("split_size")) {
                    this.splitSize = Integer.parseInt(urlQuery.get("split_size"));
                }
                if (urlQuery.containsKey("partitioner")) {
                    this.partitionerClass = urlQuery.get("partitioner");
                }
                if (urlQuery.containsKey("init_address")) {
                    this.initHostAddress = urlQuery.get("init_address");
                }
                if (urlQuery.containsKey("rpc_port")) {
                    this.rpcPort = urlQuery.get("rpc_port");
                }
            }
            if ((credentialsAndKeyspace = (parts = urlParts[0].split("/+"))[1].split("@")).length > 1) {
                String[] credentials = credentialsAndKeyspace[0].split(":");
                this.username = credentials[0];
                this.password = credentials[1];
                this.keyspace = credentialsAndKeyspace[1];
            } else {
                this.keyspace = parts[1];
            }
            this.column_family = parts[2];
        }
        catch (Exception e) {
            throw new IOException("Expected 'cassandra://[username:password@]<keyspace>/<table>[?slice_start=<start>&slice_end=<end>[&reversed=true][&limit=1][&allow_deletes=true][&widerows=true][&use_secondary=true][&comparator=<comparator>][&split_size=<size>][&partitioner=<partitioner>][&init_address=<host>][&rpc_port=<port>]]': " + e.getMessage());
        }
    }

    public static Map<String, String> getQueryMap(String query) throws UnsupportedEncodingException {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>(params.length);
        for (String param : params) {
            String[] keyValue = param.split("=");
            map.put(keyValue[0], URLDecoder.decode(keyValue[1], "UTF-8"));
        }
        return map;
    }

    public ByteBuffer nullToBB() {
        return null;
    }

    protected CfDef getCfDef(Cassandra.Client client) throws org.apache.cassandra.thrift.InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException, NotFoundException, InvalidRequestException, ConfigurationException, IOException {
        String query = String.format("SELECT type, comparator, subcomparator, default_validator, key_validator FROM %s.%s WHERE keyspace_name = '%s' AND columnfamily_name = '%s'", "system", "schema_columnfamilies", this.keyspace, this.column_family);
        CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(query), Compression.NONE, ConsistencyLevel.ONE);
        if (result == null || result.rows == null || result.rows.isEmpty()) {
            return null;
        }
        Iterator iteraRow = result.rows.iterator();
        CfDef cfDef = new CfDef();
        cfDef.keyspace = this.keyspace;
        cfDef.name = this.column_family;
        if (iteraRow.hasNext()) {
            CqlRow cqlRow = (CqlRow)iteraRow.next();
            cfDef.column_type = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)0)).value);
            cfDef.comparator_type = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)1)).value);
            ByteBuffer subComparator = ((Column)cqlRow.columns.get((int)2)).value;
            if (subComparator != null) {
                cfDef.subcomparator_type = ByteBufferUtil.string(subComparator);
            }
            cfDef.default_validation_class = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)3)).value);
            cfDef.key_validation_class = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)4)).value);
        }
        cfDef.column_metadata = this.getColumnMetadata(client);
        return cfDef;
    }

    protected CfDef getCfDef(String signature) throws IOException {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CassandraStorage.class);
        String prop = property.getProperty(signature);
        return CassandraStorage.cfdefFromString(prop);
    }

    protected static CfDef cfdefFromString(String st) throws IOException {
        assert (st != null);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        CfDef cfDef = new CfDef();
        try {
            deserializer.deserialize((TBase)cfDef, Hex.hexToBytes(st));
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return cfDef;
    }

    protected static String cfdefToString(CfDef cfDef) throws IOException {
        assert (cfDef != null);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return Hex.bytesToHex(serializer.serialize((TBase)cfDef));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    protected AbstractType parseType(String type) throws IOException {
        try {
            if (type != null && type.equals("org.apache.cassandra.db.marshal.CounterColumnType")) {
                return LongType.instance;
            }
            return TypeParser.parse(type);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        catch (SyntaxException e) {
            throw new IOException(e);
        }
    }

    protected Tuple columnToTuple(ColumnFamilyRecordReader.Column column, CfDef cfDef, AbstractType comparator) throws IOException {
        Tuple pair = TupleFactory.getInstance().newTuple(2);
        if (comparator instanceof AbstractCompositeType) {
            StorageHelper.setTupleValue(pair, 0, this.composeComposite((AbstractCompositeType)comparator, column.name));
        } else {
            StorageHelper.setTupleValue(pair, 0, StorageHelper.cassandraToObj(comparator, column.name, this.nativeProtocolVersion));
        }
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
        if (validators.get(column.name) == null) {
            Map<MarshallerType, AbstractType> marshallers = this.getDefaultMarshallers(cfDef);
            StorageHelper.setTupleValue(pair, 1, StorageHelper.cassandraToObj(marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR), column.value, this.nativeProtocolVersion));
        } else {
            StorageHelper.setTupleValue(pair, 1, StorageHelper.cassandraToObj(validators.get(column.name), column.value, this.nativeProtocolVersion));
        }
        return pair;
    }

    protected Map<MarshallerType, AbstractType> getDefaultMarshallers(CfDef cfDef) throws IOException {
        EnumMap<MarshallerType, AbstractType> marshallers = new EnumMap<MarshallerType, AbstractType>(MarshallerType.class);
        AbstractType comparator = this.parseType(cfDef.getComparator_type());
        AbstractType subcomparator = this.parseType(cfDef.getSubcomparator_type());
        AbstractType default_validator = this.parseType(cfDef.getDefault_validation_class());
        AbstractType key_validator = this.parseType(cfDef.getKey_validation_class());
        marshallers.put(MarshallerType.COMPARATOR, comparator);
        marshallers.put(MarshallerType.DEFAULT_VALIDATOR, default_validator);
        marshallers.put(MarshallerType.KEY_VALIDATOR, key_validator);
        marshallers.put(MarshallerType.SUBCOMPARATOR, subcomparator);
        return marshallers;
    }

    protected Map<ByteBuffer, AbstractType> getValidatorMap(CfDef cfDef) throws IOException {
        HashMap<ByteBuffer, AbstractType> validators = new HashMap<ByteBuffer, AbstractType>();
        for (ColumnDef cd : cfDef.getColumn_metadata()) {
            if (cd.getValidation_class() == null || cd.getValidation_class().isEmpty()) continue;
            LongType validator = null;
            try {
                validator = TypeParser.parse(cd.getValidation_class());
                if (validator instanceof CounterColumnType) {
                    validator = LongType.instance;
                }
                validators.put(cd.name, validator);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
            catch (SyntaxException e) {
                throw new IOException(e);
            }
        }
        return validators;
    }

    protected static enum MarshallerType {
        COMPARATOR,
        DEFAULT_VALIDATOR,
        KEY_VALIDATOR,
        SUBCOMPARATOR;

    }
}

