/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.caffinitas.ohc.tables.Uns;
import org.caffinitas.ohc.tables.Util;
import org.xerial.snappy.Snappy;

final class CompressingOutputChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final long bufferAddress;
    private final int uncompressedChunkSize;
    private ByteBuffer buffer;
    private boolean closed;

    CompressingOutputChannel(WritableByteChannel delegate, int uncompressedChunkSize) throws IOException {
        this.delegate = delegate;
        int maxCLen = Snappy.maxCompressedLength((int)uncompressedChunkSize);
        int bufferCapacity = 4 + maxCLen;
        this.bufferAddress = Uns.allocateIOException(bufferCapacity);
        this.buffer = Uns.directBufferFor(this.bufferAddress, 0L, bufferCapacity);
        this.uncompressedChunkSize = uncompressedChunkSize - 4;
        this.buffer.putInt(1330135875);
        this.buffer.putInt(1);
        this.buffer.putInt(uncompressedChunkSize);
        this.buffer.putInt(maxCLen);
        this.buffer.flip();
        delegate.write(this.buffer);
        this.buffer.clear();
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.closed) {
            Uns.free(this.bufferAddress);
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            Uns.free(this.bufferAddress);
        }
        super.finalize();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int chunkSize;
        int sz;
        ByteBuffer s = src.duplicate();
        src.position(src.position() + sz);
        for (sz = src.remaining(); sz > 0; sz -= chunkSize) {
            chunkSize = sz > this.uncompressedChunkSize ? this.uncompressedChunkSize : sz;
            this.buffer.clear();
            this.buffer.position(4);
            s.limit(s.position() + chunkSize);
            int cLen = Snappy.compress((ByteBuffer)s, (ByteBuffer)this.buffer);
            this.buffer.putInt(0, cLen);
            this.buffer.position(0);
            this.buffer.limit(4 + cLen);
            Util.writeFully(this.delegate, this.buffer);
            s.position(s.position() + chunkSize);
        }
        return sz;
    }

    @Override
    public boolean isOpen() {
        return this.buffer != null;
    }
}

