/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import io.airlift.command.Accessor;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.List;

public class CommandMetadata {
    private final String name;
    private final String description;
    private final boolean hidden;
    private final List<OptionMetadata> globalOptions;
    private final List<OptionMetadata> groupOptions;
    private final List<OptionMetadata> commandOptions;
    private final ArgumentsMetadata arguments;
    private final List<Accessor> metadataInjections;
    private final Class<?> type;

    public CommandMetadata(String name, String description, boolean hidden, Iterable<OptionMetadata> globalOptions, Iterable<OptionMetadata> groupOptions, Iterable<OptionMetadata> commandOptions, ArgumentsMetadata arguments, Iterable<Accessor> metadataInjections, Class<?> type) {
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.globalOptions = ImmutableList.copyOf(globalOptions);
        this.groupOptions = ImmutableList.copyOf(groupOptions);
        this.commandOptions = ImmutableList.copyOf(commandOptions);
        this.arguments = arguments;
        this.metadataInjections = ImmutableList.copyOf(metadataInjections);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<OptionMetadata> getAllOptions() {
        return ImmutableList.builder().addAll(this.globalOptions).addAll(this.groupOptions).addAll(this.commandOptions).build();
    }

    public List<OptionMetadata> getGlobalOptions() {
        return this.globalOptions;
    }

    public List<OptionMetadata> getGroupOptions() {
        return this.groupOptions;
    }

    public List<OptionMetadata> getCommandOptions() {
        return this.commandOptions;
    }

    public ArgumentsMetadata getArguments() {
        return this.arguments;
    }

    public List<Accessor> getMetadataInjections() {
        return this.metadataInjections;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", globalOptions=").append(this.globalOptions);
        sb.append(", groupOptions=").append(this.groupOptions);
        sb.append(", commandOptions=").append(this.commandOptions);
        sb.append(", arguments=").append(this.arguments);
        sb.append(", metadataInjections=").append(this.metadataInjections);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public static Function<CommandMetadata, String> nameGetter() {
        return new Function<CommandMetadata, String>(){

            public String apply(CommandMetadata input) {
                return input.getName();
            }
        };
    }
}

