/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpcDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeVpcs
extends BaseCmd {
    public DescribeVpcs(String[] args) {
        super("ec2dvpc", "ec2-describe-vpcs");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "[ VPC ... ] [SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about one or more VPCs. The VPC parameters, if");
        System.out.println("     specified, are the IDs of the VPCs to describe.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeVpcs(this.getFilterMap(true), this.getNonOptions());
        for (VpcDescription vpc : (List)rsp.getResponse()) {
            out.output(System.out, vpc);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeVpcs(args).invoke();
    }
}

