/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.Uri;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.OptionArgumentException;
import com.thaiopensource.validate.OptionArgumentPresenceException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.nrl.ActionSet;
import com.thaiopensource.validate.nrl.AllowAction;
import com.thaiopensource.validate.nrl.AttachAction;
import com.thaiopensource.validate.nrl.AttributeActionSet;
import com.thaiopensource.validate.nrl.ElementsOrAttributes;
import com.thaiopensource.validate.nrl.Hashset;
import com.thaiopensource.validate.nrl.Mode;
import com.thaiopensource.validate.nrl.ModeUsage;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.nrl.Path;
import com.thaiopensource.validate.nrl.RejectAction;
import com.thaiopensource.validate.nrl.SchemaReceiverImpl;
import com.thaiopensource.validate.nrl.UnwrapAction;
import com.thaiopensource.validate.nrl.ValidateAction;
import com.thaiopensource.validate.nrl.ValidatorImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import com.thaiopensource.xml.sax.XmlBaseHandler;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

class SchemaImpl
extends AbstractSchema {
    private static final String IMPLICIT_MODE_NAME = "#implicit";
    private static final String WRAPPER_MODE_NAME = "#wrapper";
    static final String NRL_URI = "http://www.thaiopensource.com/validate/nrl";
    private final Hashtable modeMap = new Hashtable();
    private Mode startMode;
    private final Mode defaultBaseMode;
    private final boolean attributesSchema;
    private final XMLReaderCreator xrc;
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$SchemaImpl;

    SchemaImpl(PropertyMap properties, XMLReaderCreator xrc) {
        super(properties);
        this.xrc = xrc;
        this.attributesSchema = properties.contains(NrlProperty.ATTRIBUTES_SCHEMA);
        this.makeBuiltinMode("#allow", AllowAction.class);
        this.makeBuiltinMode("#attach", AttachAction.class);
        this.makeBuiltinMode("#unwrap", UnwrapAction.class);
        this.defaultBaseMode = this.makeBuiltinMode("#reject", RejectAction.class);
    }

    private Mode makeBuiltinMode(String name, Class cls) {
        Mode mode = this.lookupCreateMode(name);
        ActionSet actions = new ActionSet();
        ModeUsage modeUsage = new ModeUsage(Mode.CURRENT, mode);
        if (cls == AttachAction.class) {
            actions.setResultAction(new AttachAction(modeUsage));
        } else if (cls == AllowAction.class) {
            actions.addNoResultAction(new AllowAction(modeUsage));
        } else if (cls == UnwrapAction.class) {
            actions.setResultAction(new UnwrapAction(modeUsage));
        } else {
            actions.addNoResultAction(new RejectAction(modeUsage));
        }
        mode.bindElement("##any", actions);
        mode.noteDefined(null);
        AttributeActionSet attributeActions = new AttributeActionSet();
        if (this.attributesSchema) {
            attributeActions.setReject(true);
        } else {
            attributeActions.setAttach(true);
        }
        mode.bindAttribute("##any", attributeActions);
        return mode;
    }

    SchemaFuture installHandlers(XMLReader in, SchemaReceiverImpl sr) {
        Handler h = new Handler(sr);
        in.setContentHandler(h);
        return h;
    }

    public Validator createValidator(PropertyMap properties) {
        return new ValidatorImpl(this.startMode, properties);
    }

    private Mode getModeAttribute(Attributes attributes, String localName) {
        return this.lookupCreateMode(attributes.getValue("", localName));
    }

    private Mode lookupCreateMode(String name) {
        if (name == null) {
            return null;
        }
        Mode mode = (Mode)this.modeMap.get(name = name.trim());
        if (mode == null) {
            mode = new Mode(name, this.defaultBaseMode);
            this.modeMap.put(name, mode);
        }
        return mode;
    }

    private class Handler
    extends DelegatingContentHandler
    implements SchemaFuture {
        private final SchemaReceiverImpl sr;
        private boolean hadError = false;
        private final ErrorHandler eh;
        private final CountingErrorHandler ceh;
        private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$nrl$SchemaImpl == null ? (class$com$thaiopensource$validate$nrl$SchemaImpl = SchemaImpl.class$("com.thaiopensource.validate.nrl.SchemaImpl")) : class$com$thaiopensource$validate$nrl$SchemaImpl);
        private Locator locator;
        private final XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
        private int foreignDepth = 0;
        private Mode currentMode = null;
        private String defaultSchemaType;
        private Validator validator;
        private ElementsOrAttributes match;
        private ActionSet actions;
        private AttributeActionSet attributeActions;
        private String schemaUri;
        private String schemaType;
        private PropertyMapBuilder options;
        private final Vector mustSupportOptions = new Vector();
        private ModeUsage modeUsage;
        private boolean anyNamespace;

        Handler(SchemaReceiverImpl sr) {
            this.sr = sr;
            this.eh = ValidateProperty.ERROR_HANDLER.get(sr.getProperties());
            this.ceh = new CountingErrorHandler(this.eh);
        }

        public void setDocumentLocator(Locator locator) {
            this.xmlBaseHandler.setLocator(locator);
            this.locator = locator;
        }

        public void startDocument() throws SAXException {
            try {
                PropertyMapBuilder builder = new PropertyMapBuilder(this.sr.getProperties());
                ValidateProperty.ERROR_HANDLER.put(builder, this.ceh);
                this.validator = this.sr.getNrlSchema().createValidator(builder.toPropertyMap());
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
            catch (IncorrectSchemaException e) {
                throw new RuntimeException("internal error in RNG schema for NRL");
            }
            this.setDelegate(this.validator.getContentHandler());
            if (this.locator != null) {
                super.setDocumentLocator(this.locator);
            }
            super.startDocument();
        }

        public Schema getSchema() throws IncorrectSchemaException, SAXException {
            if (this.validator == null || this.ceh.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Hashset openModes = new Hashset();
            Hashset checkedModes = new Hashset();
            Enumeration enumList = SchemaImpl.this.modeMap.keys();
            while (enumList.hasMoreElements()) {
                String modeName = (String)enumList.nextElement();
                Mode mode = (Mode)SchemaImpl.this.modeMap.get(modeName);
                if (!mode.isDefined()) {
                    this.error("undefined_mode", modeName, mode.getWhereUsed());
                }
                for (Mode tem = mode; tem != null && !checkedModes.contains(tem); tem = tem.getBaseMode()) {
                    if (openModes.contains(tem)) {
                        this.error("mode_cycle", tem.getName(), tem.getWhereDefined());
                        break;
                    }
                    openModes.add(tem);
                }
                checkedModes.addAll(openModes);
                openModes.clear();
            }
            if (this.hadError) {
                throw new IncorrectSchemaException();
            }
            return SchemaImpl.this;
        }

        public RuntimeException unwrapException(RuntimeException e) throws SAXException, IOException, IncorrectSchemaException {
            if (e instanceof WrappedIOException) {
                throw ((WrappedIOException)e).getException();
            }
            return e;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.xmlBaseHandler.startElement();
            String xmlBase = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            if (xmlBase != null) {
                this.xmlBaseHandler.xmlBaseAttribute(xmlBase);
            }
            if (!SchemaImpl.NRL_URI.equals(uri) || this.foreignDepth > 0) {
                ++this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (localName.equals("rules")) {
                this.parseRules(attributes);
            } else if (localName.equals("mode")) {
                this.parseMode(attributes);
            } else if (localName.equals("namespace")) {
                this.parseNamespace(attributes);
            } else if (localName.equals("anyNamespace")) {
                this.parseAnyNamespace(attributes);
            } else if (localName.equals("validate")) {
                this.parseValidate(attributes);
            } else if (localName.equals("reject")) {
                this.parseReject(attributes);
            } else if (localName.equals("attach")) {
                this.parseAttach(attributes);
            } else if (localName.equals("unwrap")) {
                this.parseUnwrap(attributes);
            } else if (localName.equals("allow")) {
                this.parseAllow(attributes);
            } else if (localName.equals("context")) {
                this.parseContext(attributes);
            } else if (localName.equals("option")) {
                this.parseOption(attributes);
            } else {
                throw new RuntimeException("unexpected element \"" + localName + "\"");
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            this.xmlBaseHandler.endElement();
            if (this.foreignDepth > 0) {
                --this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (localName.equals("validate")) {
                this.finishValidate();
            }
        }

        private void parseRules(Attributes attributes) {
            SchemaImpl.this.startMode = SchemaImpl.this.getModeAttribute(attributes, "startMode");
            if (SchemaImpl.this.startMode == null) {
                SchemaImpl.this.startMode = SchemaImpl.this.lookupCreateMode(SchemaImpl.IMPLICIT_MODE_NAME);
                this.currentMode = SchemaImpl.this.startMode;
                SchemaImpl.this.startMode.noteDefined(null);
            }
            SchemaImpl.this.startMode.noteUsed(this.locator);
            if (SchemaImpl.this.attributesSchema) {
                Mode wrapper = SchemaImpl.this.lookupCreateMode(SchemaImpl.WRAPPER_MODE_NAME);
                ActionSet actions = new ActionSet();
                actions.addNoResultAction(new AllowAction(new ModeUsage(SchemaImpl.this.startMode, SchemaImpl.this.startMode)));
                wrapper.bindElement("##any", actions);
                wrapper.noteDefined(null);
                SchemaImpl.this.startMode = wrapper;
            }
            this.defaultSchemaType = this.getSchemaType(attributes);
        }

        private void parseMode(Attributes attributes) throws SAXException {
            this.currentMode = SchemaImpl.this.getModeAttribute(attributes, "name");
            if (this.currentMode.isDefined()) {
                this.error("duplicate_mode", this.currentMode.getName());
                this.error("first_mode", this.currentMode.getName(), this.currentMode.getWhereDefined());
            } else {
                Mode base = SchemaImpl.this.getModeAttribute(attributes, "extends");
                if (base != null) {
                    this.currentMode.setBaseMode(base);
                }
                this.currentMode.noteDefined(this.locator);
            }
        }

        private void parseNamespace(Attributes attributes) throws SAXException {
            this.anyNamespace = false;
            this.parseRule(this.getNs(attributes), attributes);
        }

        private void parseAnyNamespace(Attributes attributes) throws SAXException {
            this.anyNamespace = true;
            this.parseRule("##any", attributes);
        }

        private void parseRule(String ns, Attributes attributes) throws SAXException {
            this.match = this.toElementsOrAttributes(attributes.getValue("", "match"), ElementsOrAttributes.ELEMENTS);
            if (this.match.containsAttributes()) {
                this.attributeActions = new AttributeActionSet();
                if (!this.currentMode.bindAttribute(ns, this.attributeActions)) {
                    if (ns.equals("##any")) {
                        this.error("duplicate_attribute_action_any_namespace");
                    } else {
                        this.error("duplicate_attribute_action", ns);
                    }
                }
            }
            if (this.match.containsElements()) {
                this.actions = new ActionSet();
                if (!this.currentMode.bindElement(ns, this.actions)) {
                    if (ns.equals("##any")) {
                        this.error("duplicate_element_action_any_namespace");
                    } else {
                        this.error("duplicate_element_action", ns);
                    }
                }
            } else {
                this.actions = null;
            }
        }

        private void parseValidate(Attributes attributes) throws SAXException {
            this.schemaUri = this.getSchema(attributes);
            this.schemaType = this.getSchemaType(attributes);
            if (this.schemaType == null) {
                this.schemaType = this.defaultSchemaType;
            }
            this.modeUsage = this.actions != null ? this.getModeUsage(attributes) : null;
            this.options = new PropertyMapBuilder();
            this.mustSupportOptions.clear();
        }

        private void finishValidate() throws SAXException {
            try {
                Schema schema;
                if (this.attributeActions != null) {
                    schema = this.createSubSchema(true);
                    this.attributeActions.addSchema(schema);
                }
                if (this.actions != null) {
                    schema = this.createSubSchema(false);
                    this.actions.addNoResultAction(new ValidateAction(this.modeUsage, schema));
                }
            }
            catch (IncorrectSchemaException e) {
                this.hadError = true;
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
        }

        private InputSource makeInputSource(XMLReader xr, String systemId) throws IOException, SAXException {
            InputSource inputSource;
            EntityResolver er = xr.getEntityResolver();
            if (er != null && (inputSource = er.resolveEntity(null, systemId)) != null) {
                return inputSource;
            }
            return new InputSource(systemId);
        }

        private Schema createSubSchema(boolean isAttributesSchema) throws IOException, IncorrectSchemaException, SAXException {
            PropertyMap requestedProperties = this.options.toPropertyMap();
            Schema schema = this.sr.createChildSchema(this.makeInputSource(SchemaImpl.this.xrc.createXMLReader(), this.schemaUri), this.schemaType, requestedProperties, isAttributesSchema);
            PropertyMap actualProperties = schema.getProperties();
            Enumeration enumList = this.mustSupportOptions.elements();
            while (enumList.hasMoreElements()) {
                MustSupportOption mso = (MustSupportOption)enumList.nextElement();
                Object actualValue = actualProperties.get(mso.pid);
                if (actualValue == null) {
                    this.error("unsupported_option", mso.name, mso.locator);
                    continue;
                }
                if (actualValue.equals(requestedProperties.get(mso.pid))) continue;
                this.error("unsupported_option_arg", mso.name, mso.locator);
            }
            return schema;
        }

        private void parseOption(Attributes attributes) throws SAXException {
            String mustSupportValue = attributes.getValue("", "mustSupport");
            boolean mustSupport = mustSupportValue != null ? (mustSupportValue = mustSupportValue.trim()).equals("1") || mustSupportValue.equals("true") : false;
            String name = Uri.resolve(SchemaImpl.NRL_URI, attributes.getValue("", "name"));
            Option option = this.sr.getOption(name);
            if (option == null) {
                if (mustSupport) {
                    this.error("unknown_option", name);
                }
            } else {
                String arg = attributes.getValue("", "arg");
                try {
                    PropertyId pid = option.getPropertyId();
                    Object value = option.valueOf(arg);
                    Object oldValue = this.options.get(pid);
                    if (oldValue != null) {
                        if ((value = option.combine(new Object[]{oldValue, value})) == null) {
                            this.error("duplicate_option", name);
                        } else {
                            this.options.put(pid, value);
                        }
                    } else {
                        this.options.put(pid, value);
                        this.mustSupportOptions.addElement(new MustSupportOption(name, pid, this.locator == null ? null : new LocatorImpl(this.locator)));
                    }
                }
                catch (OptionArgumentPresenceException e) {
                    this.error(arg == null ? "option_requires_argument" : "option_unexpected_argument", name);
                }
                catch (OptionArgumentException e) {
                    if (arg == null) {
                        this.error("option_requires_argument", name);
                    }
                    this.error("option_bad_argument", name, arg);
                }
            }
        }

        private void parseAttach(Attributes attributes) {
            if (this.attributeActions != null) {
                this.attributeActions.setAttach(true);
            }
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.setResultAction(new AttachAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
        }

        private void parseUnwrap(Attributes attributes) {
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.setResultAction(new UnwrapAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
        }

        private void parseAllow(Attributes attributes) {
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.addNoResultAction(new AllowAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
        }

        private void parseReject(Attributes attributes) {
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.addNoResultAction(new RejectAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
            if (this.attributeActions != null) {
                this.attributeActions.setReject(true);
            }
        }

        private void parseContext(Attributes attributes) throws SAXException {
            if (this.anyNamespace) {
                this.error("context_any_namespace");
                return;
            }
            Mode mode = this.getUseMode(attributes);
            try {
                Vector paths = Path.parse(attributes.getValue("", "path"));
                if (this.modeUsage != null) {
                    int len = paths.size();
                    for (int i = 0; i < len; ++i) {
                        Path path = (Path)paths.elementAt(i);
                        if (this.modeUsage.addContext(path.isRoot(), path.getNames(), mode)) continue;
                        this.error("duplicate_path", path.toString());
                    }
                }
            }
            catch (Path.ParseException e) {
                this.error(e.getMessageKey());
            }
        }

        private String getSchema(Attributes attributes) throws SAXException {
            String schemaUri = attributes.getValue("", "schema");
            if (Uri.hasFragmentId(schemaUri)) {
                this.error("schema_fragment_id");
            }
            return Uri.resolve(this.xmlBaseHandler.getBaseUri(), Uri.escapeDisallowedChars(schemaUri));
        }

        private String getSchemaType(Attributes attributes) {
            return attributes.getValue("", "schemaType");
        }

        private ElementsOrAttributes toElementsOrAttributes(String value, ElementsOrAttributes defaultValue) {
            if (value == null) {
                return defaultValue;
            }
            ElementsOrAttributes eoa = ElementsOrAttributes.NEITHER;
            if (value.indexOf("elements") >= 0) {
                eoa = eoa.addElements();
            }
            if (value.indexOf("attributes") >= 0) {
                eoa = eoa.addAttributes();
            }
            return eoa;
        }

        private ModeUsage getModeUsage(Attributes attributes) {
            return new ModeUsage(this.getUseMode(attributes), this.currentMode);
        }

        private Mode getUseMode(Attributes attributes) {
            Mode mode = SchemaImpl.this.getModeAttribute(attributes, "useMode");
            if (mode == null) {
                return Mode.CURRENT;
            }
            mode.noteUsed(this.locator);
            return mode;
        }

        private String getNs(Attributes attributes) throws SAXException {
            String ns = attributes.getValue("", "ns");
            if (ns != null && !Uri.isAbsolute(ns) && !ns.equals("")) {
                this.error("ns_absolute");
            }
            return ns;
        }

        void error(String key) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key), this.locator));
        }

        void error(String key, String arg) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key, arg), this.locator));
        }

        void error(String key, String arg, Locator locator) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key, arg), locator));
        }

        void error(String key, String arg1, String arg2) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key, arg1, arg2), this.locator));
        }
    }

    private static class MustSupportOption {
        private final String name;
        private final PropertyId pid;
        private final Locator locator;

        MustSupportOption(String name, PropertyId pid, Locator locator) {
            this.name = name;
            this.pid = pid;
            this.locator = locator;
        }
    }

    private static final class WrappedIOException
    extends RuntimeException {
        private final IOException exception;

        private WrappedIOException(IOException exception) {
            this.exception = exception;
        }

        private IOException getException() {
            return this.exception;
        }
    }
}

