/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public interface CleanupFrequency {
    public static final CleanupFrequency DAILY = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(@Nullable Instant lastCleanupTime) {
            if (lastCleanupTime == null) {
                return true;
            }
            return Duration.between(lastCleanupTime, Instant.now()).toHours() >= 24L;
        }
    };
    public static final CleanupFrequency ALWAYS = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(@Nullable Instant lastCleanupTime) {
            return true;
        }

        @Override
        public boolean shouldCleanupOnEndOfSession() {
            return true;
        }
    };
    public static final CleanupFrequency NEVER = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(@Nullable Instant lastCleanupTime) {
            return false;
        }
    };

    public boolean requiresCleanup(@Nullable Instant var1);

    default public boolean shouldCleanupOnEndOfSession() {
        return false;
    }
}

