/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.RelativePathUtil;

public class DefaultBasePluginExtension
implements BasePluginExtension {
    private final Project project;
    private final DirectoryProperty distsDirectory;
    private final DirectoryProperty libsDirectory;
    private final Property<String> archivesName;

    public DefaultBasePluginExtension(Project project) {
        this.project = project;
        this.distsDirectory = project.getObjects().directoryProperty();
        this.libsDirectory = project.getObjects().directoryProperty();
        this.archivesName = project.getObjects().property(String.class);
    }

    @Override
    public DirectoryProperty getDistsDirectory() {
        return this.distsDirectory;
    }

    @Override
    public DirectoryProperty getLibsDirectory() {
        return this.libsDirectory;
    }

    @Override
    public Property<String> getArchivesName() {
        return this.archivesName;
    }

    @Override
    @Deprecated
    public String getDistsDirName() {
        DefaultBasePluginExtension.logPropertyDeprecation("distsDirName", "distsDirectory");
        File buildDir = ((Directory)this.project.getLayout().getBuildDirectory().get()).getAsFile();
        File distsDir = ((Directory)this.getDistsDirectory().get()).getAsFile();
        return RelativePathUtil.relativePath((File)buildDir, (File)distsDir);
    }

    @Override
    @Deprecated
    public void setDistsDirName(String distsDirName) {
        DefaultBasePluginExtension.logPropertyDeprecation("distsDirName", "distsDirectory");
        this.getDistsDirectory().set(this.project.getLayout().getBuildDirectory().dir(distsDirName));
    }

    @Override
    @Deprecated
    public String getLibsDirName() {
        DefaultBasePluginExtension.logPropertyDeprecation("libsDirName", "libsDirectory");
        File buildDir = ((Directory)this.project.getLayout().getBuildDirectory().get()).getAsFile();
        File libsDir = ((Directory)this.getLibsDirectory().get()).getAsFile();
        return RelativePathUtil.relativePath((File)buildDir, (File)libsDir);
    }

    @Override
    @Deprecated
    public void setLibsDirName(String libsDirName) {
        DefaultBasePluginExtension.logPropertyDeprecation("libsDirName", "libsDirectory");
        this.getLibsDirectory().set(this.project.getLayout().getBuildDirectory().dir(libsDirName));
    }

    @Override
    @Deprecated
    public String getArchivesBaseName() {
        DefaultBasePluginExtension.logPropertyDeprecation("archivesBaseName", "archivesName");
        return (String)this.getArchivesName().get();
    }

    @Override
    @Deprecated
    public void setArchivesBaseName(String archivesBaseName) {
        DefaultBasePluginExtension.logPropertyDeprecation("archivesBaseName", "archivesName");
        this.getArchivesName().set((Object)archivesBaseName);
    }

    private static void logPropertyDeprecation(String propertyName, String replacementPropertyName) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(BasePluginExtension.class, (String)propertyName).replaceWith((Object)replacementPropertyName)).willBeRemovedInGradle9().withDslReference(BasePluginExtension.class, replacementPropertyName)).nagUser();
    }
}

