/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.presentation.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.icons.AllIcons;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProvider;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightJavaModule;

public class JavaModulePresentationProvider
implements ItemPresentationProvider<PsiJavaModule> {
    private static final Pattern JAR_NAME = Pattern.compile(".+/([^/]+\\.jar)!/.*");

    @Override
    public ItemPresentation getPresentation(final @NotNull PsiJavaModule item) {
        if (item == null) {
            JavaModulePresentationProvider.$$$reportNull$$$0(0);
        }
        return new ItemPresentation(){

            public String getPresentableText() {
                return item.getName();
            }

            @Override
            @Nullable
            public String getLocationString() {
                Module module2;
                VirtualFile file2 = PsiImplUtil.getModuleVirtualFile(item);
                FileIndexFacade index2 = FileIndexFacade.getInstance(item.getProject());
                if (index2.isInLibraryClasses(file2)) {
                    Matcher matcher = JAR_NAME.matcher(file2.getPath());
                    if (matcher.find()) {
                        return matcher.group(1);
                    }
                } else if (index2.isInSource(file2) && (module2 = index2.getModuleForFile(file2)) != null) {
                    return '[' + module2.getName() + ']';
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean unused2) {
                return item instanceof LightJavaModule ? AllIcons.FileTypes.Archive : AllIcons.Nodes.JavaModule;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaModulePresentationProvider", "getPresentation"));
    }
}

