/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public class DeclarationScopeProviderImpl
implements DeclarationScopeProvider {
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private final FileScopeProvider fileScopeProvider;

    public DeclarationScopeProviderImpl(@NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull FileScopeProvider fileScopeProvider) {
        if (lazyDeclarationResolver == null) {
            DeclarationScopeProviderImpl.$$$reportNull$$$0(0);
        }
        if (fileScopeProvider == null) {
            DeclarationScopeProviderImpl.$$$reportNull$$$0(1);
        }
        this.lazyDeclarationResolver = lazyDeclarationResolver;
        this.fileScopeProvider = fileScopeProvider;
    }

    @Override
    @NotNull
    public LexicalScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            DeclarationScopeProviderImpl.$$$reportNull$$$0(2);
        }
        KtDeclaration ktDeclaration = KtStubbedPsiUtil.getPsiOrStubParent(elementOfDeclaration, KtDeclaration.class, false);
        assert (!(elementOfDeclaration instanceof KtDeclaration) || ktDeclaration == elementOfDeclaration) : "For KtDeclaration element getParentOfType() should return itself.";
        assert (ktDeclaration != null) : "Should be contained inside declaration.";
        KtDeclaration parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(ktDeclaration);
        if (ktDeclaration instanceof KtPropertyAccessor) {
            parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(parentDeclaration, KtDeclaration.class);
        }
        if (parentDeclaration == null) {
            LexicalScope lexicalScope = this.fileScopeProvider.getFileResolutionScope((KtFile)elementOfDeclaration.getContainingFile());
            if (lexicalScope == null) {
                DeclarationScopeProviderImpl.$$$reportNull$$$0(3);
            }
            return lexicalScope;
        }
        if (parentDeclaration instanceof KtClassOrObject) {
            KtClassOrObject parentClassOrObject = (KtClassOrObject)parentDeclaration;
            LazyClassDescriptor parentClassDescriptor = (LazyClassDescriptor)this.lazyDeclarationResolver.getClassDescriptor(parentClassOrObject, NoLookupLocation.WHEN_GET_DECLARATION_SCOPE);
            if (ktDeclaration instanceof KtAnonymousInitializer || ktDeclaration instanceof KtProperty) {
                LexicalScope lexicalScope = parentClassDescriptor.getScopeForInitializerResolution();
                if (lexicalScope == null) {
                    DeclarationScopeProviderImpl.$$$reportNull$$$0(4);
                }
                return lexicalScope;
            }
            if (ktDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)ktDeclaration).isCompanion()) {
                LexicalScope lexicalScope = parentClassDescriptor.getScopeForCompanionObjectHeaderResolution();
                if (lexicalScope == null) {
                    DeclarationScopeProviderImpl.$$$reportNull$$$0(5);
                }
                return lexicalScope;
            }
            if (ktDeclaration instanceof KtObjectDeclaration || ktDeclaration instanceof KtClass && !((KtClass)ktDeclaration).isInner()) {
                LexicalScope lexicalScope = parentClassDescriptor.getScopeForStaticMemberDeclarationResolution();
                if (lexicalScope == null) {
                    DeclarationScopeProviderImpl.$$$reportNull$$$0(6);
                }
                return lexicalScope;
            }
            LexicalScope lexicalScope = parentClassDescriptor.getScopeForMemberDeclarationResolution();
            if (lexicalScope == null) {
                DeclarationScopeProviderImpl.$$$reportNull$$$0(7);
            }
            return lexicalScope;
        }
        if (parentDeclaration instanceof KtScript) {
            ClassDescriptorWithResolutionScopes scriptDescriptor = (ClassDescriptorWithResolutionScopes)this.lazyDeclarationResolver.resolveToDescriptor(parentDeclaration);
            LexicalScope lexicalScope = scriptDescriptor.getScopeForInitializerResolution();
            if (lexicalScope == null) {
                DeclarationScopeProviderImpl.$$$reportNull$$$0(8);
            }
            return lexicalScope;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + ktDeclaration + "\n" + PsiUtilsKt.getElementTextWithContext(ktDeclaration));
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfoForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            DeclarationScopeProviderImpl.$$$reportNull$$$0(9);
        }
        DataFlowInfo dataFlowInfo = DataFlowInfoFactory.EMPTY;
        if (dataFlowInfo == null) {
            DeclarationScopeProviderImpl.$$$reportNull$$$0(10);
        }
        return dataFlowInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyDeclarationResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileScopeProvider";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementOfDeclaration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolutionScopeForDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterDataFlowInfoForDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolutionScopeForDeclaration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOuterDataFlowInfoForDeclaration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

