/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.AbstractVagrantItemManager;
import com.jetbrains.plugins.vagrant.VagrantItem;
import com.jetbrains.plugins.vagrant.VagrantPlugin;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantPluginManager
extends AbstractVagrantItemManager<VagrantPlugin> {
    public VagrantPluginManager(Project project) {
        super(project);
    }

    @Override
    protected VagrantPlugin createItem(String line) {
        return new VagrantPlugin(line);
    }

    @Override
    protected String emptyListText() {
        return "No plugins installed.";
    }

    @Override
    protected String[] listItemsArguments() {
        return new String[]{"plugin", "list"};
    }

    @Override
    protected String getItemName() {
        return "Plugin";
    }

    @Override
    protected String[] removeItemArguments(VagrantItem plugin) {
        return new String[]{"plugin", "uninstall", plugin.getName()};
    }

    @NotNull
    public FutureResult<VagrantPlugin> add(final String ... args) {
        if (args == null) {
            VagrantPluginManager.$$$reportNull$$$0(0);
        }
        final FutureResult futurePlugin = new FutureResult();
        final VagrantTask task = this.createTask(ArrayUtil.mergeArrays((String[])new String[]{"plugin", "install"}, (String[])args));
        if (task != null) {
            Task.Backgroundable backgroundableTask = new Task.Backgroundable(this.myProject, "Installing '" + StringUtil.join((String[])args) + "' plugin. This can take a few minutes...", true, new PerformInBackgroundOption(){

                public boolean shouldStartInBackground() {
                    return false;
                }
            }){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setFraction(0.0);
                    indicator.isIndeterminate();
                    try {
                        CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(task.createCommandLine());
                        ProcessOutput output = handler.runProcess();
                        if (output.getExitCode() != 0) {
                            UIUtil.invokeLaterIfNeeded(() -> {
                                Messages.showErrorDialog((Project)this.myProject, (String)output.getStderr(), (String)"Error Installing Plugin");
                                futurePlugin.set(null);
                            });
                        } else {
                            VagrantPluginManager.this.dropCache();
                            futurePlugin.set((Object)new VagrantPlugin(args[0]));
                            VagrantPluginManager.this.fireEvent();
                        }
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        UIUtil.invokeLaterIfNeeded(() -> {
                            if (args == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            Messages.showErrorDialog((Project)this.myProject, (String)("Can't install plugin '" + StringUtil.join((String[])args) + "':" + message), (String)"Error Installing Plugin");
                        });
                        futurePlugin.set(null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "args";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantPluginManager$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$run$1";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            ProgressManager.getInstance().run((Task)backgroundableTask);
        } else {
            futurePlugin.set(null);
        }
        FutureResult futureResult = futurePlugin;
        if (futureResult == null) {
            VagrantPluginManager.$$$reportNull$$$0(1);
        }
        return futureResult;
    }

    @Override
    @Nullable
    public FutureResult<VagrantPlugin> add() {
        String pluginName = Messages.showInputDialog((Project)this.myProject, (String)"Enter plugin name:", (String)"Install Vagrant Plugin", (Icon)Messages.getQuestionIcon());
        if (!StringUtil.isEmpty((String)pluginName)) {
            String[] args = pluginName.split("\\s+");
            return this.add(args);
        }
        return null;
    }

    public void update(@NotNull VagrantPlugin plugin) {
        VagrantTask task;
        if (plugin == null) {
            VagrantPluginManager.$$$reportNull$$$0(2);
        }
        if ((task = this.createTask("plugin", "update", plugin.getName())) != null) {
            this.runTask(task, "Upgrading plugin " + plugin.getName(), true);
        }
    }

    public void attachLicense(@NotNull VagrantPlugin plugin) {
        if (plugin == null) {
            VagrantPluginManager.$$$reportNull$$$0(3);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle("Choose License File");
        FileChooserDialog fc = FileChooserFactory.getInstance().createFileChooser(descriptor, this.myProject, null);
        VirtualFile[] files = fc.choose(this.myProject, new VirtualFile[0]);
        if (files.length == 1) {
            String licensePath = files[0].getPath();
            VagrantTask task = this.createTask("plugin", "license", plugin.getName(), licensePath);
            if (task != null) {
                this.runTask(task, "Attaching License To Plugin", true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantPluginManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantPluginManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachLicense";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

