/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.repo.AsyncFilesManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgLocalIgnoredHolder
implements Disposable {
    private static final Logger LOG = Logger.getInstance(HgLocalIgnoredHolder.class);
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @NotNull
    private final AtomicBoolean myInUpdateMode;
    @NotNull
    private final HgRepository myRepository;
    @NotNull
    private final Set<VirtualFile> myIgnoredSet;
    @NotNull
    private final ReentrantReadWriteLock SET_LOCK;
    private final EventDispatcher<AsyncFilesManagerListener> myListeners;

    public HgLocalIgnoredHolder(@NotNull HgRepository repository) {
        if (repository == null) {
            HgLocalIgnoredHolder.$$$reportNull$$$0(0);
        }
        this.SET_LOCK = new ReentrantReadWriteLock();
        this.myListeners = EventDispatcher.create(AsyncFilesManagerListener.class);
        this.myRepository = repository;
        this.myIgnoredSet = ContainerUtil.newHashSet();
        this.myInUpdateMode = new AtomicBoolean(false);
        this.myUpdateQueue = new MergingUpdateQueue("HgIgnoreUpdate", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void addUpdateStateListener(@NotNull AsyncFilesManagerListener listener) {
        if (listener == null) {
            HgLocalIgnoredHolder.$$$reportNull$$$0(1);
        }
        this.myListeners.addListener((EventListener)listener, (Disposable)this);
    }

    public void startRescan() {
        if (Registry.is((String)"hg4idea.process.ignored")) {
            this.myUpdateQueue.queue(new Update("hgRescanIgnored"){

                public boolean canEat(Update update) {
                    return true;
                }

                public void run() {
                    if (HgLocalIgnoredHolder.this.myInUpdateMode.compareAndSet(false, true)) {
                        HgLocalIgnoredHolder.this.fireUpdateStarted();
                        HgLocalIgnoredHolder.this.rescanAllIgnored();
                        HgLocalIgnoredHolder.this.myInUpdateMode.set(false);
                        HgLocalIgnoredHolder.this.fireUpdateFinished();
                    }
                }
            });
        }
    }

    private void fireUpdateStarted() {
        ((AsyncFilesManagerListener)this.myListeners.getMulticaster()).updateStarted();
    }

    private void fireUpdateFinished() {
        ((AsyncFilesManagerListener)this.myListeners.getMulticaster()).updateFinished();
    }

    private void rescanAllIgnored() {
        HashSet ignored = ContainerUtil.newHashSet();
        ignored.addAll(new HgStatusCommand.Builder(false).ignored(true).build(this.myRepository.getProject()).getFiles(this.myRepository.getRoot(), null));
        try {
            this.SET_LOCK.writeLock().lock();
            this.myIgnoredSet.clear();
            this.myIgnoredSet.addAll(ignored);
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<FilePath> removeIgnoredFiles(@NotNull Collection<FilePath> files) {
        if (files == null) {
            HgLocalIgnoredHolder.$$$reportNull$$$0(2);
        }
        ArrayList removedIgnoredFiles = ContainerUtil.newArrayList();
        try {
            this.SET_LOCK.writeLock().lock();
            Iterator<VirtualFile> iter = this.myIgnoredSet.iterator();
            while (iter.hasNext()) {
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)iter.next());
                if (!files.contains(filePath)) continue;
                iter.remove();
                removedIgnoredFiles.add(filePath);
            }
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
        ArrayList arrayList = removedIgnoredFiles;
        if (arrayList == null) {
            HgLocalIgnoredHolder.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void addFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            HgLocalIgnoredHolder.$$$reportNull$$$0(4);
        }
        try {
            this.SET_LOCK.writeLock().lock();
            this.myIgnoredSet.addAll(files);
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            HgLocalIgnoredHolder.$$$reportNull$$$0(5);
        }
        try {
            this.SET_LOCK.readLock().lock();
            boolean bl = this.myIgnoredSet.contains(file);
            return bl;
        }
        finally {
            this.SET_LOCK.readLock().unlock();
        }
    }

    public boolean isInUpdateMode() {
        return this.myInUpdateMode.get();
    }

    @NotNull
    public Set<VirtualFile> getIgnoredFiles() {
        this.SET_LOCK.readLock().lock();
        HashSet hashSet = ContainerUtil.newHashSet(this.myIgnoredSet);
        HashSet hashSet2 = hashSet;
        if (hashSet2 == null) {
            HgLocalIgnoredHolder.$$$reportNull$$$0(6);
        }
        return hashSet2;
        finally {
            this.SET_LOCK.readLock().unlock();
        }
    }

    public void dispose() {
        try {
            this.myUpdateQueue.cancelAllUpdates();
            this.SET_LOCK.writeLock().lock();
            this.myIgnoredSet.clear();
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
    }

    public int getSize() {
        try {
            this.SET_LOCK.readLock().lock();
            int n = this.myIgnoredSet.size();
            return n;
        }
        finally {
            this.SET_LOCK.readLock().unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/HgLocalIgnoredHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/HgLocalIgnoredHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeIgnoredFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateStateListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeIgnoredFiles";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

