/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class GitVersion
implements Comparable<GitVersion> {
    public static final GitVersion MIN = new GitVersion(1, 8, 0, 0);
    public static final GitVersion NULL = new GitVersion(0, 0, 0, 0, Type.NULL);
    private static final Pattern FORMAT = Pattern.compile("git version (\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(.*)", 2);
    private static final Logger LOG = Logger.getInstance((String)GitVersion.class.getName());
    private final int myMajor;
    private final int myMinor;
    private final int myRevision;
    private final int myPatchLevel;
    @NotNull
    private final Type myType;
    private final int myHashCode;

    public GitVersion(int major, int minor, int revision, int patchLevel, @NotNull Type type) {
        if (type == null) {
            GitVersion.$$$reportNull$$$0(0);
        }
        this.myMajor = major;
        this.myMinor = minor;
        this.myRevision = revision;
        this.myPatchLevel = patchLevel;
        this.myType = type;
        this.myHashCode = Objects.hash(this.myMajor, this.myMinor, this.myRevision, this.myPatchLevel);
    }

    public GitVersion(int major, int minor, int revision, int patchLevel) {
        this(major, minor, revision, patchLevel, Type.UNDEFINED);
    }

    @NotNull
    public static GitVersion parse(@NotNull String output) throws ParseException {
        String suffix;
        if (output == null) {
            GitVersion.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            throw new ParseException("Empty git --version output: " + output, 0);
        }
        Matcher m = FORMAT.matcher(output.trim());
        if (!m.matches()) {
            throw new ParseException("Unsupported format of git --version output: " + output, 0);
        }
        int major = GitVersion.getIntGroup(m, 1);
        int minor = GitVersion.getIntGroup(m, 2);
        int rev = GitVersion.getIntGroup(m, 3);
        int patch = GitVersion.getIntGroup(m, 4);
        Type type = SystemInfo.isWindows ? ((suffix = GitVersion.getStringGroup(m, 5)).toLowerCase(Locale.ENGLISH).contains("msysgit") || suffix.toLowerCase(Locale.ENGLISH).contains("windows") ? Type.MSYS : Type.CYGWIN) : Type.UNIX;
        GitVersion gitVersion = new GitVersion(major, minor, rev, patch, type);
        if (gitVersion == null) {
            GitVersion.$$$reportNull$$$0(2);
        }
        return gitVersion;
    }

    private static int getIntGroup(@NotNull Matcher matcher, int group) {
        if (matcher == null) {
            GitVersion.$$$reportNull$$$0(3);
        }
        if (group > matcher.groupCount() + 1) {
            return 0;
        }
        String match = matcher.group(group);
        if (match == null) {
            return 0;
        }
        return Integer.parseInt(match);
    }

    @NotNull
    private static String getStringGroup(@NotNull Matcher matcher, int group) {
        if (matcher == null) {
            GitVersion.$$$reportNull$$$0(4);
        }
        if (group > matcher.groupCount() + 1) {
            if ("" == null) {
                GitVersion.$$$reportNull$$$0(5);
            }
            return "";
        }
        String match = matcher.group(group);
        if (match == null) {
            if ("" == null) {
                GitVersion.$$$reportNull$$$0(6);
            }
            return "";
        }
        String string = match.trim();
        if (string == null) {
            GitVersion.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static GitVersion identifyVersion(@NotNull String gitExecutable) throws TimeoutException, ExecutionException, ParseException {
        ProcessOutput result2;
        if (gitExecutable == null) {
            GitVersion.$$$reportNull$$$0(8);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(gitExecutable);
        commandLine.addParameter("--version");
        commandLine.setCharset(CharsetToolkit.getDefaultSystemCharset());
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ProcessOutput processOutput = result2 = indicator == null ? handler.runProcess(ExecutableValidator.TIMEOUT_MS) : handler.runProcessWithProgressIndicator(indicator);
        if (result2.isTimeout()) {
            throw new TimeoutException("Couldn't identify the version of Git - stopped by timeout.");
        }
        if (result2.isCancelled()) {
            LOG.info("Cancelled by user. exitCode=" + result2.getExitCode());
            throw new ProcessCanceledException();
        }
        if (result2.getExitCode() != 0 || !result2.getStderr().isEmpty()) {
            LOG.info("getVersion exitCode=" + result2.getExitCode() + " errors: " + result2.getStderr());
            try {
                GitVersion.parse(result2.getStdout());
            }
            catch (ParseException pe) {
                throw new ExecutionException("Errors while executing git --version. exitCode=" + result2.getExitCode() + " errors: " + result2.getStderr());
            }
        }
        GitVersion gitVersion = GitVersion.parse(result2.getStdout());
        if (gitVersion == null) {
            GitVersion.$$$reportNull$$$0(9);
        }
        return gitVersion;
    }

    public boolean isSupported() {
        return this.getType() != Type.NULL && this.compareTo(MIN) >= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GitVersion)) {
            return false;
        }
        GitVersion other = (GitVersion)obj;
        if (this.compareTo(other) != 0) {
            return false;
        }
        if (this.myType == Type.UNDEFINED || other.myType == Type.UNDEFINED) {
            return true;
        }
        return this.myType == other.myType;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    public int compareTo(@NotNull GitVersion o) {
        if (o == null) {
            GitVersion.$$$reportNull$$$0(10);
        }
        if (o.getType() == Type.NULL) {
            return this.getType() == Type.NULL ? 0 : 1;
        }
        int d = this.myMajor - o.myMajor;
        if (d != 0) {
            return d;
        }
        d = this.myMinor - o.myMinor;
        if (d != 0) {
            return d;
        }
        d = this.myRevision - o.myRevision;
        if (d != 0) {
            return d;
        }
        return this.myPatchLevel - o.myPatchLevel;
    }

    @NotNull
    public String getPresentation() {
        String presentation = this.myMajor + "." + this.myMinor + "." + this.myRevision;
        if (this.myPatchLevel > 0) {
            presentation = presentation + "." + this.myPatchLevel;
        }
        String string = presentation;
        if (string == null) {
            GitVersion.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String toString() {
        return this.myMajor + "." + this.myMinor + "." + this.myRevision + "." + this.myPatchLevel + " (" + (Object)((Object)this.myType) + ")";
    }

    @NotNull
    public String getSemanticPresentation() {
        String presentation = this.myMajor + "." + this.myMinor + "." + this.myRevision;
        if (this.myPatchLevel > 0) {
            presentation = presentation + "." + this.myPatchLevel;
        }
        String string = presentation + "-" + (Object)((Object)this.myType);
        if (string == null) {
            GitVersion.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isOlderOrEqual(GitVersion gitVersion) {
        return gitVersion != null && this.compareTo(gitVersion) <= 0;
    }

    public boolean isLaterOrEqual(GitVersion version) {
        return version != null && this.compareTo(version) >= 0;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            GitVersion.$$$reportNull$$$0(13);
        }
        return type;
    }

    public boolean isNull() {
        return this.getType() == Type.NULL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitExecutable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSemanticPresentation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntGroup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStringGroup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        UNIX,
        MSYS,
        CYGWIN,
        UNDEFINED,
        NULL;

    }
}

