/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.SyncDateFormat;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttributes {
    private static final Logger LOG = Logger.getInstance(FileAttributes.class);
    private static final SyncDateFormat DATE_FORMAT;
    private final long mySize;
    private final long myLastModified;
    private final String myErrorMessage;
    private final int myPermissions;

    static FileAttributes createFor(@NotNull FileObject file, boolean accurateTimestamp) {
        if (file == null) {
            FileAttributes.$$$reportNull$$$0(0);
        }
        try {
            return new FileAttributes(file, accurateTimestamp);
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            return new FileAttributes(PublishUtils.getMessage(e, false));
        }
    }

    private FileAttributes(FileObject file, boolean accurateTimestamp) throws FileSystemException {
        FileContent content = file.getContent();
        if (file.getType() == FileType.FILE && content != null) {
            this.mySize = content.getSize();
            this.myLastModified = content.getLastModifiedTime(accurateTimestamp);
        } else {
            this.mySize = 0L;
            this.myLastModified = 0L;
        }
        this.myErrorMessage = null;
        this.myPermissions = file.getPermissions();
    }

    public FileAttributes(@Nullable String errorMessage) {
        this.mySize = 0L;
        this.myLastModified = 0L;
        this.myPermissions = -1;
        this.myErrorMessage = errorMessage;
    }

    public String getPermissionsString(boolean asNumber) {
        if (this.myPermissions == -1) {
            return "";
        }
        if (asNumber) {
            return String.valueOf(this.myPermissions);
        }
        return Util.getPermissionsAsString(this.myPermissions);
    }

    public String getFormattedLastModified() {
        return DATE_FORMAT.format(this.myLastModified);
    }

    public String getFormattedSize() {
        return PublishUtils.formatSize(this.mySize, "size.byte", "size.kilobyte", "size.megabyte");
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    static {
        SyncDateFormat format = null;
        String customPattern = System.getProperty("com.jetbrains.plugins.webDeployment.timestamp_pattern");
        if (!StringUtil.isEmptyOrSpaces((String)customPattern)) {
            try {
                format = new SyncDateFormat((DateFormat)new SimpleDateFormat(customPattern));
            }
            catch (Throwable t) {
                LOG.warn("Invalid timestamp pattern: '" + customPattern + "'", t);
            }
        }
        DATE_FORMAT = format != null ? format : DateFormatUtil.getDateTimeFormat();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/FileAttributes", "createFor"));
    }
}

