/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NotNull;

public abstract class Compatibility
implements Comparable<Compatibility> {
    private static final Compatibility UNCOMPATIBLE = new Uncompatible();
    private final Cardinality myCardinality;
    private final int myPriority;
    private final boolean myCanContains;
    private final int myLabelSimilarity;
    private final boolean myCompatible;

    protected Compatibility(@NotNull Cardinality cardinality, int labelSimilarity, int priority, boolean canContains, boolean compatible) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(0);
        }
        this.myCardinality = cardinality;
        this.myPriority = priority;
        this.myCanContains = canContains;
        this.myLabelSimilarity = labelSimilarity;
        this.myCompatible = compatible;
    }

    boolean isCanContains() {
        return this.myCanContains;
    }

    public boolean isCompatible() {
        return this.myCompatible;
    }

    public int getPriority() {
        return this.myPriority;
    }

    Cardinality getCardinality() {
        return this.myCardinality;
    }

    int getLabelSimilarity() {
        return this.myLabelSimilarity;
    }

    @Override
    public int compareTo(Compatibility o) {
        int byLabel = Integer.compare(o.myLabelSimilarity, this.myLabelSimilarity);
        if (byLabel != 0) {
            return byLabel;
        }
        int byPriority = Integer.compare(o.getPriority(), this.myPriority);
        if (byPriority != 0) {
            return byPriority;
        }
        return this.myCardinality.compareTo(o.myCardinality);
    }

    @NotNull
    public static Compatibility full(@NotNull Cardinality cardinality, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(1);
        }
        if (first == null) {
            Compatibility.$$$reportNull$$$0(2);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(3);
        }
        Compatibility compatibility = Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)(x$0, x$1) -> new Full((Cardinality)x$0, (int)x$1)), cardinality, first, second);
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(4);
        }
        return compatibility;
    }

    @NotNull
    public static Compatibility compatibleLossy(@NotNull Cardinality cardinality, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(5);
        }
        if (first == null) {
            Compatibility.$$$reportNull$$$0(6);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(7);
        }
        Compatibility compatibility = Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)CompatibleLossy::new), cardinality, first, second);
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(8);
        }
        return compatibility;
    }

    @NotNull
    public static Compatibility uncompatibleLossless(@NotNull Cardinality cardinality, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(9);
        }
        if (first == null) {
            Compatibility.$$$reportNull$$$0(10);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(11);
        }
        Compatibility compatibility = Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)UncompatibleLossless::new), cardinality, first, second);
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(12);
        }
        return compatibility;
    }

    @NotNull
    public static Compatibility uncompatibleLossy(@NotNull Cardinality cardinality, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(13);
        }
        if (first == null) {
            Compatibility.$$$reportNull$$$0(14);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(15);
        }
        Compatibility compatibility = Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)UncompatibleLossy::new), cardinality, first, second);
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(16);
        }
        return compatibility;
    }

    @NotNull
    public static Compatibility uncompatible() {
        Compatibility compatibility = UNCOMPATIBLE;
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(17);
        }
        return compatibility;
    }

    @NotNull
    private static Compatibility create(@NotNull PairFunction<Cardinality, Integer, Compatibility> constructor, @NotNull Cardinality cardinality, @NotNull LogicalType from, @NotNull LogicalType to) {
        if (constructor == null) {
            Compatibility.$$$reportNull$$$0(18);
        }
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(19);
        }
        if (from == null) {
            Compatibility.$$$reportNull$$$0(20);
        }
        if (to == null) {
            Compatibility.$$$reportNull$$$0(21);
        }
        Compatibility compatibility = (Compatibility)constructor.fun((Object)cardinality, (Object)to.getSuitability(from));
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(22);
        }
        return compatibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cardinality";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/Compatibility";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/Compatibility";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "full";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "compatibleLossy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "uncompatibleLossless";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "uncompatibleLossy";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "uncompatible";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "full";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 22: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compatibleLossy";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "uncompatibleLossless";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "uncompatibleLossy";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Uncompatible
    extends Compatibility {
        protected Uncompatible() {
            super(Cardinality.EMPTY, 0, 1, false, false);
        }
    }

    private static class UncompatibleLossy
    extends Compatibility {
        protected UncompatibleLossy(@NotNull Cardinality cardinality, int label) {
            if (cardinality == null) {
                UncompatibleLossy.$$$reportNull$$$0(0);
            }
            super(cardinality, label, 2, true, false);
        }

        @Override
        public int compareTo(Compatibility o) {
            if (!(o instanceof UncompatibleLossy)) {
                return super.compareTo(o);
            }
            int byLabel = Integer.compare(o.getLabelSimilarity(), this.getLabelSimilarity());
            if (byLabel != 0) {
                return byLabel;
            }
            return o.getCardinality().compareTo(this.getCardinality());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$UncompatibleLossy", "<init>"));
        }
    }

    private static class UncompatibleLossless
    extends Compatibility {
        protected UncompatibleLossless(@NotNull Cardinality cardinality, int label) {
            if (cardinality == null) {
                UncompatibleLossless.$$$reportNull$$$0(0);
            }
            super(cardinality, label, 3, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$UncompatibleLossless", "<init>"));
        }
    }

    private static class CompatibleLossy
    extends Compatibility {
        protected CompatibleLossy(@NotNull Cardinality cardinality, int label) {
            if (cardinality == null) {
                CompatibleLossy.$$$reportNull$$$0(0);
            }
            super(cardinality, label, 4, true, true);
        }

        @Override
        public int compareTo(Compatibility o) {
            if (!(o instanceof CompatibleLossy)) {
                return super.compareTo(o);
            }
            int byLabel = Integer.compare(o.getLabelSimilarity(), this.getLabelSimilarity());
            if (byLabel != 0) {
                return byLabel;
            }
            return o.getCardinality().compareTo(this.getCardinality());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$CompatibleLossy", "<init>"));
        }
    }

    private static class Full
    extends Compatibility {
        private Full(@NotNull Cardinality c2, int label) {
            if (c2 == null) {
                Full.$$$reportNull$$$0(0);
            }
            super(c2, label, 5, true, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/data/types/domain/Compatibility$Full", "<init>"));
        }
    }
}

