/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDefinedTypeAttributeIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> {
    private final Dbms myDbms;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final TIntHashSet myPositions;
    private String myPrevName;

    public UserDefinedTypeAttributeIt(@Nullable ResultSet rs, @NotNull Dbms dbms, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (dbms == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(1);
        }
        super(rs);
        this.myPositions = new TIntHashSet();
        this.myDbms = dbms;
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.UserDefinedTypeAttribute createStorage() {
        DatabaseMetaDataWrapper.UserDefinedTypeAttribute userDefinedTypeAttribute = new DatabaseMetaDataWrapper.UserDefinedTypeAttribute(new DatabaseMetaDataWrapper.UserDefinedType(this.mySchema));
        if (userDefinedTypeAttribute == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(2);
        }
        return userDefinedTypeAttribute;
    }

    @Override
    protected DatabaseMetaDataWrapper.UserDefinedTypeAttribute calcValue() throws SQLException {
        DatabaseMetaDataWrapper.UserDefinedTypeAttribute res2 = (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.getStorageToFill();
        try {
            String type = this.myRs.getString("TYPE_NAME", 3);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TYPE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Comparing.equal((String)this.mySchema.schema, (String)schema)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            if (StringUtil.isEmpty((String)type)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            if (!Comparing.equal((String)this.myPrevName, (String)type)) {
                this.myPositions.clear();
                this.myPrevName = type;
            }
            res2.userDefinedType.name = type;
            res2.name = this.myRs.getString("ATTR_NAME", 4);
            if (StringUtil.isEmpty((String)res2.name)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            res2.type = this.myRs.getInt("DATA_TYPE", 5, 0);
            res2.typeName = StringUtil.notNullize((String)this.myRs.getString("ATTR_TYPE_NAME", 6));
            res2.length = this.myRs.getInt("ATTR_SIZE", 7, 0);
            res2.scale = this.myRs.getInt("DECIMAL_DIGITS", 8, 0);
            if (this.myDbms.isSqlite()) {
                res2.length = 0;
                res2.scale = -1;
            }
            res2.nullable = "yes".equalsIgnoreCase(this.myRs.getString("IS_NULLABLE", 17));
            res2.def = this.myRs.getString("ATTR_DEF", 12);
            res2.position = this.myRs.getInt("ORDINAL_POSITION", 16, 0);
            if (res2.position == -1) {
                res2.position = 0;
            }
            while (this.myPositions.contains(res2.position)) {
                ++res2.position;
            }
            this.myPositions.add(res2.position);
            res2.comment = this.myRs.getString("REMARKS", 11);
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
        }
        return res2;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.UserDefinedTypeAttribute cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(StringUtil.notNullize((String)cur.userDefinedType.schema.database), cur.userDefinedType.schema.schema, StringUtil.notNullize((String)cur.userDefinedType.name));
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/UserDefinedTypeAttributeIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/UserDefinedTypeAttributeIt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> it) {
            final String tableName = ((DatabaseMetaDataWrapper.UserDefinedTypeAttribute)it.current()).userDefinedType.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.UserDefinedTypeAttribute item) {
                    return Comparing.equal((String)tableName, (String)item.userDefinedType.name);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.UserDefinedType getItem(ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> it) {
            return ((DatabaseMetaDataWrapper.UserDefinedTypeAttribute)it.current()).userDefinedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/UserDefinedTypeAttributeIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/UserDefinedTypeAttributeIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

