/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ImportException;
import com.intellij.database.model.serialization.ModelExporter;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/model/serialization/ModelSerializer;", "", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/model/ModelFactory;)V", "exporter", "Lcom/intellij/database/model/serialization/ModelExporter;", "getExporter", "()Lcom/intellij/database/model/serialization/ModelExporter;", "importer", "Lcom/intellij/database/model/serialization/ModelImporter;", "getImporter", "()Lcom/intellij/database/model/serialization/ModelImporter;", "getModelFactory", "()Lcom/intellij/database/model/ModelFactory;", "deserialize", "Lcom/intellij/database/model/basic/BasicModModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "modelName", "", "serialize", "", "model", "Lcom/intellij/database/model/DasModel;", "writer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "intellij.database.impl"})
public final class ModelSerializer {
    @NotNull
    private final ModelExporter exporter;
    @NotNull
    private final ModelImporter importer;
    @NotNull
    private final ModelFactory modelFactory;

    @NotNull
    public final ModelExporter getExporter() {
        return this.exporter;
    }

    @NotNull
    public final ModelImporter getImporter() {
        return this.importer;
    }

    public final void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        ModelSerializerKt.access$serialize(model, writer, this.exporter);
    }

    @NotNull
    public final BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @Nullable String modelName) throws ImportException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return ModelSerializerKt.access$deserialize(reader, this.importer, modelName);
    }

    @NotNull
    public static /* synthetic */ BasicModModel deserialize$default(ModelSerializer modelSerializer, HierarchicalStreamReader hierarchicalStreamReader, String string, int n, Object object) throws ImportException {
        if ((n & 2) != 0) {
            string = null;
        }
        return modelSerializer.deserialize(hierarchicalStreamReader, string);
    }

    @NotNull
    public final ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public ModelSerializer(@NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        this.modelFactory = modelFactory;
        this.exporter = new ModelExporter();
        this.importer = new ModelImporter(this.modelFactory);
    }
}

