/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.SessionToolWindowHelper;
import com.intellij.database.run.session.SessionView;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import icons.DatabaseIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class BaseSessionView<Self extends SessionView<Self, S>, S extends VisibleSession<?, S, Self>>
implements SessionView<Self, S> {
    public static final String OUTPUT_CONTENT_ID = "Input";
    private final LanguageConsoleView myConsoleView;
    private final RunnerLayoutUi myUi;
    private final DataAuditor.ConsoleLogger myHistoryLogger;
    private final SessionToolWindowHelper myToolWindowHelper;
    private final S mySession;
    private Content myContent;
    private SyntaxHighlighter myHighlighter;

    public BaseSessionView(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull LanguageConsoleView consoleView, @NotNull SessionToolWindowHelper toolWindowHelper, @NotNull S session2) {
        if (project == null) {
            BaseSessionView.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            BaseSessionView.$$$reportNull$$$0(1);
        }
        if (consoleView == null) {
            BaseSessionView.$$$reportNull$$$0(2);
        }
        if (toolWindowHelper == null) {
            BaseSessionView.$$$reportNull$$$0(3);
        }
        if (session2 == null) {
            BaseSessionView.$$$reportNull$$$0(4);
        }
        this.myToolWindowHelper = toolWindowHelper;
        this.myConsoleView = consoleView;
        this.mySession = session2;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create(toolWindowHelper.getToolWindowId(), this.getTitle(), this.getTitle(), (Disposable)this);
        this.myUi.getContentManager().addDataProvider((DataProvider)this);
        this.recreateContent();
        ((ConsoleViewImpl)consoleView).setEmulateCarriageReturn(false);
        this.myHistoryLogger = this.createHistoryLogger(consoleView);
        SessionLogger sessionLogger = this.createAuditor();
        messageBus.addAuditor(sessionLogger);
        Disposer.register((Disposable)this, (Disposable)this.myConsoleView);
        Disposer.register(session2, (Disposable)this);
    }

    @Override
    @NotNull
    public S getSession() {
        S s = this.mySession;
        if (s == null) {
            BaseSessionView.$$$reportNull$$$0(5);
        }
        return s;
    }

    @Override
    public boolean isShowing() {
        return this.isValid() && this.myUi.getComponent().isShowing();
    }

    @Override
    @NotNull
    public DataAuditor.ConsoleLogger getHistoryLogger() {
        DataAuditor.ConsoleLogger consoleLogger = this.myHistoryLogger;
        if (consoleLogger == null) {
            BaseSessionView.$$$reportNull$$$0(6);
        }
        return consoleLogger;
    }

    @Override
    @NotNull
    public LanguageConsoleView getConsoleView() {
        LanguageConsoleView languageConsoleView = this.myConsoleView;
        if (languageConsoleView == null) {
            BaseSessionView.$$$reportNull$$$0(7);
        }
        return languageConsoleView;
    }

    @Override
    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.myUi;
        if (runnerLayoutUi == null) {
            BaseSessionView.$$$reportNull$$$0(8);
        }
        return runnerLayoutUi;
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            BaseSessionView.$$$reportNull$$$0(9);
        }
        return content;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myConsoleView.getProject();
        if (project == null) {
            BaseSessionView.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.myConsoleView.getTitle();
        if (string == null) {
            BaseSessionView.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BaseSessionView.$$$reportNull$$$0(12);
        }
        return Session.SESSION_KEY.is(dataId) ? this.mySession : null;
    }

    @Override
    @NotNull
    public Promise<Void> show(boolean activate, boolean requestFocus) {
        ContentManager contentManager;
        if (!this.mySession.isValid()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                BaseSessionView.$$$reportNull$$$0(13);
            }
            return promise;
        }
        ToolWindowEx window = this.myToolWindowHelper.getOrCreateToolWindow(this.getProject());
        this.ensureContentInitialized(requestFocus);
        this.beforeExecution();
        ContentManager contentManager2 = contentManager = this.myContent.getManager() == null ? this.retrieveContentManager((ToolWindow)window) : this.myContent.getManager();
        if (activate) {
            AsyncPromise callback = new AsyncPromise();
            window.activate(() -> {
                if (!this.myContent.isValid()) {
                    return;
                }
                contentManager.setSelectedContent(this.myContent, requestFocus, false);
                callback.setResult(null);
            }, false, requestFocus);
            AsyncPromise asyncPromise = callback;
            if (asyncPromise == null) {
                BaseSessionView.$$$reportNull$$$0(14);
            }
            return asyncPromise;
        }
        contentManager.setSelectedContent(this.myContent, requestFocus, false);
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            BaseSessionView.$$$reportNull$$$0(15);
        }
        return promise;
    }

    @NotNull
    protected ContentManager retrieveContentManager(ToolWindow window) {
        ContentManager contentManager = window.getContentManager();
        window.setAvailable(true, null);
        this.myContent.getComponent().updateUI();
        contentManager.addContent(this.myContent);
        ContentManager contentManager2 = contentManager;
        if (contentManager2 == null) {
            BaseSessionView.$$$reportNull$$$0(16);
        }
        return contentManager2;
    }

    @Override
    public void beforeExecution() {
        EditorHighlighter highlighter = this.myConsoleView.getConsoleEditor().getHighlighter();
        this.myHighlighter = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
    }

    @Override
    public void addRequestToHistory(@NotNull DataRequest.Context context) {
        String query;
        if (context == null) {
            BaseSessionView.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)(query = context.getQuery()))) {
            return;
        }
        LanguageConsoleView console = this.getConsoleView();
        String prompt = console.getPrompt();
        if (StringUtil.isNotEmpty((String)prompt)) {
            console.print(prompt, (ConsoleViewContentType)ObjectUtils.notNull((Object)console.getPromptAttributes(), (Object)ConsoleViewContentType.USER_INPUT));
        }
        String adjustedQuery = StringUtil.convertLineSeparators((String)query);
        if (this.myHighlighter != null) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)console, (String)adjustedQuery, (SyntaxHighlighter)this.myHighlighter, () -> this.onLineBreak(console));
        } else {
            console.print(adjustedQuery, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }

    protected void onLineBreak(@NotNull LanguageConsoleView console) {
        if (console == null) {
            BaseSessionView.$$$reportNull$$$0(18);
        }
    }

    @Override
    @Nullable
    public Content getOutputContent() {
        return this.getUi().findContent(OUTPUT_CONTENT_ID);
    }

    public void dispose() {
        ContentManager manager = this.getContent().getManager();
        if (manager != null) {
            manager.removeContent(this.getContent(), false);
        }
        Disposer.dispose((Disposable)this.getContent());
    }

    @Override
    public void startLoading() {
        this.withLoadingPanel((Consumer<JBLoadingPanel>)((Consumer)p2 -> p2.startLoading()));
    }

    @Override
    public void stopLoading() {
        this.withLoadingPanel((Consumer<JBLoadingPanel>)((Consumer)p2 -> p2.stopLoading()));
    }

    public void ensureContentInitialized(boolean focused) {
        if (this.myContent.getDisposer() != null) {
            return;
        }
        this.myContent.setDisposer(this::onContentDisposal);
        this.buildConsoleUi(focused);
    }

    @Override
    public boolean isValid() {
        return !this.getUi().isDisposed() && !this.getConsoleView().getHistoryViewer().isDisposed() && this.getConsoleView().getVirtualFile().isValid();
    }

    protected final void recreateContent() {
        Disposable disposable = this.myContent == null ? null : this.myContent.getDisposer();
        this.myContent = ContentFactory.SERVICE.getInstance().createContent(this.myUi.getComponent(), this.getTitle(), false);
        this.myContent.setIcon(DatabaseIcons.Table);
        if (disposable != null) {
            this.myContent.setDisposer(disposable);
        }
    }

    protected void onContentDisposal() {
        if (this.readyToDie() || this.myUi.isDisposed()) {
            this.destroySession();
            return;
        }
        this.recreateContent();
    }

    protected void destroySession() {
        Disposer.dispose(this.mySession);
    }

    protected boolean readyToDie() {
        return true;
    }

    @Override
    @NotNull
    public SessionToolWindowHelper getToolWindowHelper() {
        SessionToolWindowHelper sessionToolWindowHelper = this.myToolWindowHelper;
        if (sessionToolWindowHelper == null) {
            BaseSessionView.$$$reportNull$$$0(19);
        }
        return sessionToolWindowHelper;
    }

    @NotNull
    protected DataAuditor.ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            BaseSessionView.$$$reportNull$$$0(20);
        }
        DataAuditor.ConsoleLogger consoleLogger = new DataAuditor.ConsoleLogger((ConsoleView)consoleView);
        if (consoleLogger == null) {
            BaseSessionView.$$$reportNull$$$0(21);
        }
        return consoleLogger;
    }

    @NotNull
    protected SessionLogger createAuditor() {
        SessionLogger sessionLogger = new SessionLogger(this);
        if (sessionLogger == null) {
            BaseSessionView.$$$reportNull$$$0(22);
        }
        return sessionLogger;
    }

    private void withLoadingPanel(@NotNull Consumer<JBLoadingPanel> consumer2) {
        Content content;
        JComponent component;
        if (consumer2 == null) {
            BaseSessionView.$$$reportNull$$$0(23);
        }
        JComponent jComponent = component = (content = this.getOutputContent()) == null ? null : content.getComponent();
        if (!(component instanceof JBLoadingPanel)) {
            return;
        }
        JBLoadingPanel loadingPanel = (JBLoadingPanel)component;
        consumer2.consume((Object)loadingPanel);
    }

    protected abstract void buildConsoleUi(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/session/BaseSessionView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/session/BaseSessionView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLogger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveContentManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowHelper";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createHistoryLogger";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRequestToHistory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onLineBreak";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createHistoryLogger";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withLoadingPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

