/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.editor.QuoteIdentifierQuickFix;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialectEx
extends SqlLanguageDialect
implements CasingProvider {
    private final Object myLock;
    private DatabaseDialectEx myDatabaseDialect;
    private Map<SqlType.Category, SqlType> myPrimitiveTypes;
    private Map<String, SqlFunctionDefinition.Type> myTypes;

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        SqlFunctionDefinition.addSimpleTypes(myTypes, this);
    }

    protected SqlType booleanType() {
        return this.primitiveType(SqlType.Category.BOOLEAN);
    }

    protected SqlType stringType() {
        return this.primitiveType(SqlType.Category.STRING);
    }

    protected SqlType integerType() {
        return this.primitiveType(SqlType.Category.INTEGER);
    }

    protected SqlType realType() {
        return this.primitiveType(SqlType.Category.REAL);
    }

    protected SqlType dateTimeType() {
        return this.primitiveType(SqlType.Category.DATE_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlType primitiveType(SqlType.Category category) {
        Object object = this.myLock;
        synchronized (object) {
            Map<SqlType.Category, SqlType> primitiveTypes = this.myPrimitiveTypes;
            if (primitiveTypes == null) {
                this.myPrimitiveTypes = primitiveTypes = new EnumMap<SqlType.Category, SqlType>(SqlType.Category.class);
            }
            return primitiveTypes.computeIfAbsent(category, c2 -> SqlTypeFactory.defaultType(c2, this));
        }
    }

    public SqlLanguageDialectEx(@NonNls @NotNull String id) {
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(0);
        }
        super(id);
        this.myLock = new Object();
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getDbms().getDisplayName();
        if (string == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myDatabaseDialect == null) {
            this.myDatabaseDialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DatabaseDialect.EP.forDbms(this.getDbms()));
        }
        DatabaseDialectEx databaseDialectEx = this.myDatabaseDialect;
        // MONITOREXIT : object
        if (databaseDialectEx != null) return databaseDialectEx;
        SqlLanguageDialectEx.$$$reportNull$$$0(2);
        return databaseDialectEx;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getDatabaseDialect().getDbms();
        if (dbms == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(3);
        }
        return dbms;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.getDatabaseDialect().getIcon();
        if (icon == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return null;
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return false;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(6);
        }
        if ((SqlImplUtil.equalsInsensitiveOrTrue(name, ReservedEntities.RE_NEXTVAL.name, resolve) || SqlImplUtil.equalsInsensitiveOrTrue(name, ReservedEntities.RE_CURRVAL.name, resolve)) && SqlImplUtil.getQualifierKind(element2) == ObjectKind.SEQUENCE) {
            if (!processor.executeTarget(ReservedEntities.RE_NEXTVAL, element2, this.integerType(), false, ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget(ReservedEntities.RE_CURRVAL, element2, this.integerType(), false, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, false);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly, boolean pl) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
        if (!(type instanceof SqlKeywordTokenType) || !(!pl ? this.isReservedKeyword(type) : this.isReservedKeywordPL(type))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.1.should.be.quoted", o.getName()), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierStartsWithLetter(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        String text2 = o.getText();
        if (text2.length() <= 0 || Character.isLetter(text2.charAt(0))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
    }

    protected static boolean processReservedEntitiesWithTypeDual(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(8);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element2, SqlFromClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class}) == null) {
            return true;
        }
        if (element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).getQualifierExpression() != null) {
            return true;
        }
        return SqlLanguageDialectEx.processReservedEntitiesWithTypeSimple(ReservedEntities.RE_DUAL, (SqlType)SqlTableTypeBase.EMPTY_TABLE, name, element2, resolve, processor, true, false);
    }

    protected static boolean processReservedEntitiesWithTypeSimple(DasObject entity, SqlType result2, @Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor, boolean checkType, Boolean forcedCaseSense) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(10);
        }
        return !SqlImplUtil.equalsInsensitiveOrTrue(name, entity.getName(), resolve) || checkType && !processor.isExpected(entity.getKind()) || processor.executeTarget(entity, element2, result2, forcedCaseSense, ResolveState.initial());
    }

    public TokenSet getStatementSeparators() {
        return SqlCommonTokens.STATEMENT_SEPARATORS;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        ASTNode node;
        SqlColumnStub stub;
        if (column2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(11);
        }
        SqlColumnStub sqlColumnStub = stub = column2 instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)column2).getStub() : null;
        if (stub != null) {
            return stub.isAutoVal();
        }
        ASTNode aSTNode = node = column2 instanceof PsiElement ? ((PsiElement)column2).getNode() : null;
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE) != null;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type instanceof SqlDbElementType) {
            ContainerUtil.addIfNotNull(result2, (Object)((SqlDbElementType)type).parentType);
        }
        if (type == ObjectKind.VARIABLE) {
            result2.add((ObjectKind)ObjectKind.VARIABLE);
        }
        if (type == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.TRIGGER) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OBJECT_TYPE) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        this.getDatabaseDialect().getMetaModel().getParentKinds(this.unaliased(type)).addAllTo(result2);
        if (type == ObjectKind.USER) {
            result2.add((ObjectKind)ObjectKind.USER);
        }
        if (type == SqlDbElementType.SYSTEM_VARIABLE) {
            result2.add((ObjectKind)SqlDbElementType.SYSTEM_VARIABLE);
        }
        return result2;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(12);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "bytes";
            }
            case ARRAY: {
                return "array";
            }
            case TABLE: {
                return "table";
            }
            case RECORD: {
                return "record";
            }
            case COLLECTION: {
                return null;
            }
            case REFERENCE: {
                return null;
            }
            case UNKNOWN: {
                return null;
            }
            case DEFAULT: {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(13);
        }
        if (this.getDatabaseDialect().isQuotedIdentifier(name)) {
            String string = name;
            if (string == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(14);
            }
            return string;
        }
        Case casing = this.getCasing((ObjectKind)ObjectKind.OBJECT_TYPE, null).plain;
        if (casing == Case.MIXED) {
            casing = Case.LOWER;
        }
        String string = casing.apply(name);
        if (string == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public SqlType.Category getTypeCategory(@NotNull DataType dataType) {
        int type;
        String name;
        SqlType.Category cat;
        if (dataType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(16);
        }
        if ((cat = this.getTypeCategoryByName(name = this.getNormalizedTypeName(dataType.typeName))) != SqlType.Category.UNKNOWN) {
            SqlType.Category category = cat;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(17);
            }
            return category;
        }
        int n = type = dataType.jdbcType == 0 ? this.getDatabaseDialect().getJavaTypeForNativeType(name) : dataType.jdbcType;
        if (type != 1111) {
            SqlType.Category category = SqlType.Category.findByJdbcType((int)type);
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(18);
            }
            return category;
        }
        if (StringUtil.isEmpty((String)name)) {
            SqlType.Category category = SqlType.Category.UNKNOWN;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(19);
            }
            return category;
        }
        SqlType.Category category = cat;
        if (category == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(20);
        }
        return category;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        String fixed;
        if (typeName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(21);
        }
        if ((fixed = StringUtil.toUpperCase((String)typeName)).contains("BINARY")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(22);
            }
            return category;
        }
        if (fixed.contains("BOOL")) {
            SqlType.Category category = SqlType.Category.BOOLEAN;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(23);
            }
            return category;
        }
        if (fixed.equals("DATE")) {
            SqlType.Category category = SqlType.Category.DATE;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(24);
            }
            return category;
        }
        if (fixed.equals("TIME")) {
            SqlType.Category category = SqlType.Category.TIME;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(25);
            }
            return category;
        }
        if (fixed.equals("TIMESTAMP")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(26);
            }
            return category;
        }
        if (fixed.contains("DATE") || fixed.contains("TIME")) {
            SqlType.Category category = SqlType.Category.DATE_TIME;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(27);
            }
            return category;
        }
        if (fixed.contains("REAL") || fixed.contains("DOUBLE") || fixed.contains("FLOAT") || fixed.contains("NUMBER")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(28);
            }
            return category;
        }
        if (fixed.contains("INTERVAL")) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(29);
            }
            return category;
        }
        if (fixed.contains("INT")) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(30);
            }
            return category;
        }
        if (fixed.contains("CHAR")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(31);
            }
            return category;
        }
        if (fixed.contains("TEXT")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(32);
            }
            return category;
        }
        if (fixed.contains("REFERENCE")) {
            SqlType.Category category = SqlType.Category.REFERENCE;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(33);
            }
            return category;
        }
        if (fixed.contains("RECORD")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(34);
            }
            return category;
        }
        SqlType.Category category = SqlType.Category.UNKNOWN;
        if (category == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(35);
        }
        return category;
    }

    public boolean canBeCalledWithoutParens(@NotNull SqlFunctionDefinition.Prototype prototype) {
        if (prototype == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(36);
        }
        SqlFunctionDefinition def = prototype.getFunction();
        return prototype.getParams().length == 0 && !"required".equals(def.getDialectAttribute("parens")) && !"true".equals(def.getDialectAttribute("analytic"));
    }

    @NotNull
    public SqlType getDefinitionType(@NotNull SqlTypedDefinition definition, @Nullable PsiElement usage) {
        if (definition == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(37);
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(38);
        }
        return sqlPrimitiveType;
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(39);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(40);
        }
        return this.quoteIdentifier(identifier.getProject(), newElementName);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName) {
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(41);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(42);
        }
        SqlCodeStyleSettings settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        boolean force = settings.QUOTE_IDENTIFIER == 0 || this.isReservedKeyword((IElementType)SqlTokenRegistry.findTokenType((String)newElementName));
        return this.getDatabaseDialect().quoteIdentifier(newElementName, force, !force);
    }

    public JBIterable<? extends SqlDefinition> extractDefinitions(@NotNull SqlElement statement) {
        if (statement == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(43);
        }
        if (statement instanceof SqlSelectStatement) {
            return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)statement).expand(Conditions.notInstanceOf(SqlSelectIntoNewTableClauseImpl.class))).filter(SqlSelectIntoNewTableClauseImpl.class);
        }
        if (statement instanceof SqlBlockStatementImpl) {
            JBIterable children2 = SqlImplUtil.childrenIt((PsiElement)statement).filter(SqlElement.class);
            return children2.filter(SqlDefinition.class).append((Iterable)children2.flatten(this::extractDefinitions));
        }
        return JBIterable.empty();
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(44);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(45);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(46);
        }
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(47);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(48);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(49);
        }
        if (qualifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(50);
        }
        return true;
    }

    public boolean processTypeExtra(SqlTableType type, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        return true;
    }

    public boolean shouldWrap(SqlDefinition o, ObjectKind kind) {
        return kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.CHARSET && type != ObjectKind.COLLATION && type != ObjectKind.TABLESPACE && type != ObjectKind.DB_LINK && type != SqlDbElementType.GENERIC_AT_LINK && type != ObjectKind.USER && type != SqlDbElementType.SYSTEM_VARIABLE && type != ObjectKind.ROLE && type != ObjectKind.OPERATOR;
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(51);
        }
        return true;
    }

    @NotNull
    public abstract BuiltinFunctions getSupportedFunctions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myTypes == null) {
            this.myTypes = ContainerUtil.newHashMap();
            this.addTypes(this.myTypes);
        }
        Map<String, SqlFunctionDefinition.Type> map = this.myTypes;
        // MONITOREXIT : object
        if (map != null) return map;
        SqlLanguageDialectEx.$$$reportNull$$$0(52);
        return map;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(53);
        }
        Casing casing = this.getDatabaseDialect().getCasing(kind, context);
        if (casing == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(54);
        }
        return casing;
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return null;
    }

    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element2) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(55);
        }
        return false;
    }

    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(56);
        }
        return ";";
    }

    public boolean mayContainExternalPsi() {
        return false;
    }

    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(57);
        }
        return kind == ObjectKind.TRIGGER || kind == ObjectKind.INDEX;
    }

    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(58);
        }
        return kind == ObjectKind.TABLE;
    }

    @NotNull
    public TreePattern getDefaultImports(@Nullable DbDataSource dataSource) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        TreePattern imports = this.getBaseImports(dataSource, dsNames);
        TreePattern treePattern = this.applyImplicitImports(dsNames, imports);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(59);
        }
        return treePattern;
    }

    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectKind kind;
        JBIterable kinds = this.getDatabaseDialect().getMetaModel().getRootNamespaceKinds();
        if (kinds.contains((Object)ObjectKind.DATABASE)) {
            kind = ObjectKind.DATABASE;
        } else if (kinds.contains((Object)ObjectKind.SCHEMA)) {
            kind = ObjectKind.SCHEMA;
        } else {
            throw new AssertionError((Object)"Unexpected root kind");
        }
        ObjectName userName = ObjectName.plain((String)SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource)));
        DasNamespace namespace = SqlLanguageDialectEx.getDefaultNamespace(dataSource, userName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : SqlImportUtil.createNodeIfNotNull(userName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(60);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(userName, kind, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(61);
        }
        return treePattern;
    }

    @NotNull
    protected TreePattern getSchemaBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames, boolean useSchemaDefault) {
        String schemaName = SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource));
        if (schemaName == null && useSchemaDefault) {
            schemaName = "default";
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(ObjectName.quoted((String)schemaName), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(62);
        }
        return treePattern;
    }

    @Nullable
    protected static DasNamespace getDefaultNamespace(@Nullable DbDataSource dataSource, @Nullable ObjectName fallback) {
        DasModel model;
        LocalDataSource ds = dataSource == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class);
        DasModel dasModel = model = ds == null ? null : ds.getModel();
        if (model == null) {
            return null;
        }
        DasNamespace cur = model.getCurrentRootNamespace();
        if (cur == null && fallback != null) {
            cur = (DasNamespace)model.getModelRoots().filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
        }
        if (cur == null || cur.getKind() == ObjectKind.SCHEMA) {
            return cur;
        }
        DasNamespace sc = SqlLanguageDialectEx.getCurrentSchema(cur);
        return (DasNamespace)ObjectUtils.chooseNotNull((Object)sc, (Object)cur);
    }

    @Nullable
    protected static DasNamespace getCurrentSchema(@Nullable DasNamespace cur) {
        return cur == null ? null : (DasNamespace)cur.getDasChildren(ObjectKind.SCHEMA).filter(BasicNamespace.class).filter(BasicNamespace::isCurrent).first();
    }

    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(63);
        }
        TreePattern treePattern = pattern;
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(64);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        List elements = SearchPath.getElements((SearchPath)searchPath);
        TreePattern treePattern = this.applyImplicitImports(dsNames, !elements.isEmpty() ? TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)elements).transform(n -> SqlDialectImplUtil.createObjectPattern(dsNames, this.getDatabaseDialect(), n, (TreePatternNode.Group[])null))) : (dsNames == null ? TreePattern.EMPTY : this.getBaseImports(dataSource, dsNames)));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(65);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath object) {
        if (object == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(66);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, object);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(67);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern processImports(@NotNull SqlUseDatabaseStatement stmt, @NotNull TreePattern prev) {
        int k;
        if (stmt == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(68);
        }
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(69);
        }
        List refs = ContainerUtil.newSmartList();
        ObjectKind kind = null;
        boolean reset = false;
        for (SqlReferenceExpression ref : ContainerUtil.iterateBackward((List)stmt.getUseReferences())) {
            if (ref == null) {
                reset = true;
                break;
            }
            refs.add(ref);
            ObjectKind k2 = ref.getReferenceElementType().getTargetKind();
            assert (kind == null || kind == k2);
            kind = k2;
        }
        if (reset) {
            TreePattern treePattern = SqlDialectImplUtil.getDefaultInitialPattern((SqlFile)stmt.getContainingFile());
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(70);
            }
            return treePattern;
        }
        boolean empty = refs.isEmpty();
        if (empty || kind == null) {
            if (!this.canBeWithoutCurrentSchema()) {
                TreePattern treePattern = prev;
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(71);
                }
                return treePattern;
            }
            List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDatabaseDialect());
            if (path == null) {
                TreePattern treePattern = this.applyImplicitImports(null, TreePattern.EMPTY);
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(72);
                }
                return treePattern;
            }
            ObjectKind[] kinds = ContainerUtil.reverse(path.subList(1, path.size())).toArray(new ObjectKind[path.size() - 1]);
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            TreePattern treePattern = this.applyImplicitImports(null, TreePatternUtils.mask(prev, kinds, mask, false));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(73);
            }
            return treePattern;
        }
        TreePattern state = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)refs).transform(r -> SqlImportUtil.createRefPattern(r, this.getDatabaseDialect())).filter(x -> x != null));
        List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDatabaseDialect());
        int n = k = path == null ? -1 : path.indexOf(kind);
        if (k != -1 && path.size() > 0) {
            ObjectKind[] kinds = ContainerUtil.reverse(path).toArray(new ObjectKind[path.size()]);
            k = kinds.length - 1 - k;
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            mask[k] = false;
            TreePattern masked = TreePatternUtils.mask(prev, kinds, mask, false);
            for (int i2 = k; i2 < mask.length; ++i2) {
                mask[i2] = i2 == k;
            }
            TreePattern maskedState = k == mask.length - 1 ? state : TreePatternUtils.mask(state, kinds, mask, false);
            state = TreePatternUtils.union(stmt.isInclusive() ? prev : TreePatternUtils.minus(prev, masked), TreePatternUtils.intersect(maskedState, masked));
        }
        TreePattern treePattern = this.applyImplicitImports(null, state);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(74);
        }
        return treePattern;
    }

    protected boolean canBeWithoutCurrentSchema() {
        return false;
    }

    @NotNull
    public SqlTableType createSequenceType(@NotNull PsiElement element2, @Nullable PsiElement object) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(75);
        }
        SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(76);
        }
        return sqlTableType;
    }

    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target) {
        if (target == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(77);
        }
        Set<ObjectKind> set = Collections.emptySet();
        if (set == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(78);
        }
        return set;
    }

    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(79);
        }
        SqlReferenceElementType unused = SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
        return SqlTokenRegistry.findCompositeType((String)("SQL_" + name));
    }

    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(80);
        }
        ObjectKind objectKind = kind;
        if (objectKind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(81);
        }
        return objectKind;
    }

    @Nullable
    public SqlType getUnqualifiedAsteriskType(@NotNull PsiElement element2) {
        SqlQueryExpression queryExpression;
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(82);
        }
        SqlTableExpression tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression();
        return tableExpression == null ? null : tableExpression.getSqlType();
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(83);
        }
        return false;
    }

    @NotNull
    public Set<SqlFunctionDefinition.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        if (expression != null && SqlLanguageDialectEx.isTableFunctionCallRef((PsiElement)expression)) {
            EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.NORMAL, SqlFunctionDefinition.Location.TABLE_FUNCTION);
            if (enumSet == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(84);
            }
            return enumSet;
        }
        EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.NORMAL);
        if (enumSet == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(85);
        }
        return enumSet;
    }

    private static boolean isTableFunctionCallRef(@NotNull PsiElement expr) {
        PsiElement parent2;
        if (expr == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(86);
        }
        return (parent2 = expr.getParent()) instanceof SqlFunctionCallExpression && parent2.getParent() instanceof SqlFunctionCallTableExpressionImpl || parent2 instanceof SqlQueryExpression;
    }

    @NotNull
    public SqlType getSqlType(@Nullable SqlReferenceImpl ref, @Nullable PsiElement resolved) {
        ObjectKind kind;
        if (ref == null && resolved == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(87);
            }
            return sqlPrimitiveType;
        }
        PsiElement refElement = ref == null ? null : ref.getElement();
        ObjectKind objectKind = kind = ref == null ? ObjectKind.NONE : ref.getReferenceElementType().getTargetKind();
        if (resolved == refElement && "*".equals(ref.getReferenceName())) {
            SqlType sqlType = this.getAsteriskType(refElement);
            if (sqlType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(88);
            }
            return sqlType;
        }
        if (kind == ObjectKind.SEQUENCE || resolved instanceof DasObject && ((DasObject)resolved).getKind() == ObjectKind.SEQUENCE) {
            SqlTableType sqlTableType = this.createSequenceType(refElement == null ? resolved : refElement, resolved);
            if (sqlTableType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(89);
            }
            return sqlTableType;
        }
        if (resolved instanceof DasRoutine && refElement instanceof SqlReferenceExpression) {
            SqlType sqlType = SqlFunctionCallExpressionImpl.createFunctionReturnType((SqlReferenceExpression)refElement, refElement);
            if (sqlType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(90);
            }
            return sqlType;
        }
        if (resolved instanceof PsiTable) {
            SqlTableType sqlTableType = SqlTableTypeBase.createType((PsiTable)resolved, refElement);
            if (sqlTableType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(91);
            }
            return sqlTableType;
        }
        if (resolved instanceof SqlCreateTypeStatement) {
            SqlType type = ((SqlCreateTypeStatement)resolved).getSqlType();
            Object object = type == null ? SqlType.UNKNOWN : type;
            if (object == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(92);
            }
            return object;
        }
        if (resolved instanceof SqlFileImpl.FakeDefinition && ((SqlFileImpl.FakeDefinition)resolved).getKind() == ObjectKind.OBJECT_TYPE) {
            SqlCreateTypeStatement o = (SqlCreateTypeStatement)((SqlFileImpl.FakeDefinition)resolved).delegates().filter(SqlCreateTypeStatement.class).first();
            SqlType type = o == null ? null : o.getSqlType();
            Object object = type == null ? SqlType.UNKNOWN : type;
            if (object == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(93);
            }
            return object;
        }
        if (resolved instanceof SqlTypedDefinition) {
            SqlTypedDefinition definition = (SqlTypedDefinition)resolved;
            SqlType type = SqlImplUtil.getSqlType(definition, this, refElement);
            SqlType sqlType = type == SqlType.UNKNOWN ? this.getReservedEntityType(definition.getName(), kind, (PsiElement)definition) : type;
            if (sqlType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(94);
            }
            return sqlType;
        }
        if (resolved instanceof PsiObject && ((PsiObject)resolved).getKind() == ObjectKind.OBJECT_TYPE) {
            DbCustomType customType = (DbCustomType)ObjectUtils.tryCast((Object)resolved, DbCustomType.class);
            if (customType != null && customType.getSuperType() == null && customType.getDasChildren(ObjectKind.OBJECT_ATTRIBUTE).filter(DasTypedObject.class).isEmpty()) {
                DataType dataType = this.getDatabaseDialect().convertUDTToDataType((DasUserDefinedType)customType);
                SqlType customSqlType = dataType == null ? null : SqlTypeFactory.of(dataType, this);
                SqlType sqlType = customSqlType != null ? customSqlType : SqlImplUtil.getSqlType((DasUserDefinedType)customType, (PsiElement)customType, SqlImplUtil.getSqlDialectSafe((PsiElement)customType));
                if (sqlType == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(95);
                }
                return sqlType;
            }
            SqlTableType sqlTableType = SqlTableTypeBase.createObjectTypeType((PsiObject)resolved, refElement);
            if (sqlTableType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(96);
            }
            return sqlTableType;
        }
        if (resolved instanceof DasSynonym) {
            DasObject target = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)resolved));
            PsiTable info = target instanceof PsiTable ? (PsiTable)target : null;
            Object object = info != null ? SqlTableTypeBase.createType(info, refElement) : SqlType.UNKNOWN;
            if (object == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(97);
            }
            return object;
        }
        if (resolved instanceof DasColumn) {
            SqlType sqlType = SqlImplUtil.getSqlType((DasTypedObject)((DasColumn)resolved), this, resolved);
            if (sqlType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(98);
            }
            return sqlType;
        }
        if (resolved == null && DbImplUtil.isTypeKind(kind)) {
            String name = ref.getReferenceName();
            Object object = StringUtil.isEmpty((String)name) ? SqlType.UNKNOWN : SqlTypeFactory.of(DataTypeFactory.of(name), this);
            if (object == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(99);
            }
            return object;
        }
        if (resolved == refElement) {
            SqlType sqlType = this.getReservedEntityType(ref.getReferenceName(), kind, refElement);
            if (sqlType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(100);
            }
            return sqlType;
        }
        if (resolved instanceof PomTargetPsiElement) {
            if (((PomTargetPsiElement)resolved).getTarget() instanceof BuiltinFunction && refElement != null && refElement.getParent() instanceof SqlFunctionCallExpression) {
                SqlType sqlType = ((SqlFunctionCallExpression)refElement.getParent()).getSqlType();
                if (sqlType == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(101);
                }
                return sqlType;
            }
        } else {
            if (resolved instanceof SqlExpression) {
                SqlType sqlType = ((SqlExpression)resolved).getSqlType();
                if (sqlType == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(102);
                }
                return sqlType;
            }
            if (resolved instanceof SqlDefinition && resolved.getParent() instanceof SqlSelectIntoClause) {
                SqlSelectClause clause = (SqlSelectClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)resolved.getParent(), SqlSelectClause.class);
                if (clause != null) {
                    SqlTableType sqlTableType = SqlImplUtil.getSelectType(clause.getExpressions(), resolved);
                    if (sqlTableType == null) {
                        SqlLanguageDialectEx.$$$reportNull$$$0(103);
                    }
                    return sqlTableType;
                }
            } else {
                if (kind == ObjectKind.TABLE) {
                    SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)ref);
                    if (sqlTableType == null) {
                        SqlLanguageDialectEx.$$$reportNull$$$0(104);
                    }
                    return sqlTableType;
                }
                if (resolved instanceof DbCustomType && ((DbCustomType)resolved).getDelegate() instanceof DasTypedObject) {
                    SqlType sqlType = SqlImplUtil.getSqlType((DasTypedObject)((DbCustomType)resolved).getDelegate(), this, resolved);
                    if (sqlType == null) {
                        SqlLanguageDialectEx.$$$reportNull$$$0(105);
                    }
                    return sqlType;
                }
                if (resolved instanceof DasTypedObject) {
                    SqlType sqlType = SqlImplUtil.getSqlType((DasTypedObject)resolved, this, resolved);
                    if (sqlType == null) {
                        SqlLanguageDialectEx.$$$reportNull$$$0(106);
                    }
                    return sqlType;
                }
                if (resolved instanceof DasUserDefinedType) {
                    SqlType sqlType = SqlImplUtil.getSqlType((DasUserDefinedType)resolved, resolved, this);
                    if (sqlType == null) {
                        SqlLanguageDialectEx.$$$reportNull$$$0(107);
                    }
                    return sqlType;
                }
            }
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(108);
        }
        return sqlPrimitiveType;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        DFABuildingVisitor dFABuildingVisitor = new DFABuildingVisitor(this);
        if (dFABuildingVisitor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(109);
        }
        return dFABuildingVisitor;
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        SqlErrorSpecHelper sqlErrorSpecHelper = SqlErrorSpecHelper.DEFAULT_INSTANCE;
        if (sqlErrorSpecHelper == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(110);
        }
        return sqlErrorSpecHelper;
    }

    private SqlType getReservedEntityType(@Nullable String name, @NotNull ObjectKind kind, @NotNull PsiElement element2) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(111);
        }
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(112);
        }
        final Ref ref = Ref.create();
        this.processReservedEntitiesWithType(name, element2, true, new SqlScopeProcessor(name, this, (Iterable)JBIterable.empty(), element2){

            @Override
            public boolean isResultEmpty() {
                return ref.isNull();
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element2, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sqlType != null) {
                    ref.set((Object)sqlType);
                }
                return sqlType != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!ref.isNull()) {
            return (SqlType)ref.get();
        }
        if (kind == ObjectKind.TABLE) {
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        if (StringUtil.isNotEmpty((String)name) && DbImplUtil.isTypeKind(kind)) {
            return SqlTypeFactory.of(DataTypeFactory.of(name), this);
        }
        return SqlType.UNKNOWN;
    }

    @NotNull
    private SqlType getAsteriskType(@NotNull PsiElement element2) {
        SqlType targetType;
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(113);
        }
        PsiElement parent2 = element2.getParent();
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        SqlType sqlType = targetType = qualifier != null ? qualifier.getSqlType() : this.getUnqualifiedAsteriskType(element2);
        if (targetType == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(114);
            }
            return sqlTableType;
        }
        Dbms dbms = this.getDbms();
        if (dbms == Dbms.CLICKHOUSE) {
            SqlType sqlType2 = targetType;
            if (sqlType2 == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(115);
            }
            return sqlType2;
        }
        if (parent2 instanceof SqlExpressionList && parent2.getParent() instanceof SqlFunctionCallExpression) {
            if (dbms.isPostgres() && qualifier != null) {
                SqlType sqlType3 = targetType;
                if (sqlType3 == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(116);
                }
                return sqlType3;
            }
            BuiltinFunction definition = ((SqlFunctionCallExpression)parent2.getParent()).getFunctionDefinition();
            if (definition == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(117);
                }
                return sqlPrimitiveType;
            }
            if (qualifier != null && !this.getDatabaseDialect().supportsQualifiedAsteriskInCalls() || !Comparing.strEqual((String)definition.getName(), (String)"count", (boolean)false) && (!dbms.isMicrosoft() || !Comparing.strEqual((String)definition.getName(), (String)"count_big", (boolean)false))) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(118);
                }
                return sqlPrimitiveType;
            }
        } else {
            PsiElement curParent = parent2;
            while (curParent instanceof SqlReferenceExpression) {
                curParent = curParent.getParent();
            }
            if (dbms.isPostgres() || dbms.isHsqldb() || dbms.isH2()) {
                while (curParent instanceof SqlParenthesizedExpression) {
                    curParent = curParent.getParent();
                }
            }
            if (!(curParent instanceof SqlSelectClause || curParent instanceof SqlDmlInstruction || curParent instanceof SqlFromClause && curParent.getParent() instanceof SqlDmlInstruction || dbms.isMysql() && PsiUtilCore.getElementType((PsiElement)curParent) == SqlCompositeElementTypes.SQL_CLAUSE && curParent.getParent() instanceof SqlDmlInstruction)) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(119);
                }
                return sqlPrimitiveType;
            }
        }
        SqlType sqlType4 = targetType;
        if (sqlType4 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(120);
        }
        return sqlType4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 52: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 52: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 52: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 55: 
            case 75: 
            case 82: 
            case 112: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 13: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 46: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 53: 
            case 57: 
            case 58: 
            case 80: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategory";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionType";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInTypes";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultImports";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaBaseImports";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "processImports";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequenceType";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "unaliased";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "createDFAVisitor";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsteriskType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 52: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeDual";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeSimple";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategory";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "canBeCalledWithoutParens";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionType";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "extractDefinitions";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createSequenceType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unaliased";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getUnqualifiedAsteriskType";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isTableFunctionCallRef";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getReservedEntityType";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getAsteriskType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 52: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class BuiltinFunctionsMap
    implements BuiltinFunctions {
        private final Map<String, SqlFunctionDefinition> myMap;

        public BuiltinFunctionsMap(@NotNull Map<String, SqlFunctionDefinition> map) {
            if (map == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(0);
            }
            this.myMap = map;
        }

        @Override
        @Nullable
        public SqlFunctionDefinition get(@Nullable String name) {
            return this.myMap.get(name);
        }

        @Override
        public boolean contains(@Nullable String name) {
            return this.myMap.containsKey(name);
        }

        @Override
        @NotNull
        public Iterable<SqlFunctionDefinition> byMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = JBIterable.from(this.myMap.entrySet()).filterMap(e -> {
                if (matcher == null) {
                    BuiltinFunctionsMap.$$$reportNull$$$0(4);
                }
                return matcher.prefixMatches((String)e.getKey()) ? (SqlFunctionDefinition)((Object)((Object)e.getValue())) : null;
            });
            if (jBIterable == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public Collection<SqlFunctionDefinition> forTokens() {
            Collection<SqlFunctionDefinition> collection = this.myMap.values();
            if (collection == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialectEx$BuiltinFunctionsMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx$BuiltinFunctionsMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byMatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forTokens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcher";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$byMatcher$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ReservedEntities {
        public static final ReservedEntity RE_NEXTVAL = new ReservedEntity("nextval", ObjectKind.COLUMN);
        public static final ReservedEntity RE_CURRVAL = new ReservedEntity("currval", ObjectKind.COLUMN);
        public static final ReservedEntity RE_DUAL = new ReservedEntity("dual", ObjectKind.TABLE);
    }

    public static interface BuiltinFunctions {
        @Nullable
        public SqlFunctionDefinition get(@Nullable String var1);

        public boolean contains(@Nullable String var1);

        @NotNull
        public Iterable<SqlFunctionDefinition> byMatcher(@NotNull PrefixMatcher var1);

        @NotNull
        public Collection<SqlFunctionDefinition> forTokens();
    }
}

