/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.inspections.suppression.SqlFileSuppressInspectionFix;
import com.intellij.sql.inspections.suppression.SqlSuppressInspectionFix;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInspectionSuppressor
implements InspectionSuppressor {
    private static final Pattern SUPPRESS_PATTERN = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    public boolean isSuppressedFor(@NotNull PsiElement element2, @NotNull String toolId) {
        if (element2 == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(1);
        }
        if (!(element2 instanceof SqlElement) && !(element2.getParent() instanceof SqlElement)) {
            return false;
        }
        if (SqlInspectionSuppressor.getSuppressionsForFile(element2.getContainingFile()).get(toolId).booleanValue()) {
            return true;
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class, (boolean)false);
        return statement != null && SqlInspectionSuppressor.getSuppressionsForStatement((PsiElement)statement).get(toolId) != false;
    }

    private static Map<String, Boolean> getSuppressionsForFile(@NotNull PsiFile file) {
        if (file == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(2);
        }
        return SqlInspectionSuppressor.getSuppressions((PsiElement)file, (Function<String, Boolean>)((Function)id -> {
            if (file == null) {
                SqlInspectionSuppressor.$$$reportNull$$$0(18);
            }
            int prefixLength = SqlInspectionSuppressor.prefixLength((PsiElement)file);
            String idForFile = id + "ForFile";
            return SqlInspectionSuppressor.leafs((PsiElement)file, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi()).takeWhile(e -> e instanceof PsiWhiteSpace || e instanceof PsiComment).find(e -> SqlInspectionSuppressor.isSuppressedInComment(e, idForFile, prefixLength)) != null;
        }));
    }

    private static Map<String, Boolean> getSuppressionsForStatement(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return SqlInspectionSuppressor.getSuppressions(element2, (Function<String, Boolean>)((Function)id -> {
            if (element2 == null) {
                SqlInspectionSuppressor.$$$reportNull$$$0(17);
            }
            int prefixLength = SqlInspectionSuppressor.prefixLength(element2);
            PsiElement first = element2.getFirstChild() instanceof PsiComment ? element2.getFirstChild() : SqlInspectionSuppressor.nextLeaf(element2, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed());
            return SqlInspectionSuppressor.leafs(first, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed()).takeWhile(e -> e instanceof PsiWhiteSpace || e instanceof PsiComment).find(e -> SqlInspectionSuppressor.isSuppressedInComment(e, id, prefixLength)) != null;
        }));
    }

    private static Map<String, Boolean> getSuppressions(@NotNull PsiElement element2, @NotNull Function<String, Boolean> compute) {
        if (element2 == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(4);
        }
        if (compute == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(5);
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)element2, () -> {
            if (compute == null) {
                SqlInspectionSuppressor.$$$reportNull$$$0(15);
            }
            if (element2 == null) {
                SqlInspectionSuppressor.$$$reportNull$$$0(16);
            }
            return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap((Function)compute), (Object[])new Object[]{element2.getContainingFile()});
        });
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element2, @NotNull String toolId) {
        if (toolId == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(6);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SqlSuppressInspectionFix(toolId, SqlStatement.class), new SqlFileSuppressInspectionFix(toolId)};
        if (suppressQuickFixArray == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(7);
        }
        return suppressQuickFixArray;
    }

    @NotNull
    private static JBIterable<PsiElement> leafs(@Nullable PsiElement element2, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(8);
        }
        JBIterable jBIterable = JBIterable.generate((Object)SqlInspectionSuppressor.firstLeaf(element2, api), e -> {
            if (api == null) {
                SqlInspectionSuppressor.$$$reportNull$$$0(14);
            }
            return SqlInspectionSuppressor.nextLeaf(e, api);
        });
        if (jBIterable == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Nullable
    private static PsiElement firstLeaf(@Nullable PsiElement e, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(10);
        }
        PsiElement next = e;
        while (next != null) {
            PsiElement first = (PsiElement)api.first((Object)next);
            if (first == null) {
                if (next.getTextLength() > 0) break;
                next = (PsiElement)api.next((Object)next);
                continue;
            }
            next = first;
        }
        return next;
    }

    @Nullable
    private static PsiElement nextLeaf(@Nullable PsiElement e, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(11);
        }
        PsiElement p2 = e;
        while (p2 != null) {
            PsiElement next = SqlInspectionSuppressor.firstLeaf((PsiElement)api.next((Object)p2), api);
            if (next != null) {
                return next;
            }
            p2 = (PsiElement)api.parent((Object)p2);
        }
        return null;
    }

    private static boolean isSuppressedInComment(@Nullable PsiElement e, @NotNull String toolId, int prefixLength) {
        if (toolId == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(12);
        }
        if (!(e instanceof PsiComment)) {
            return false;
        }
        for (String line : StringUtil.splitByLines((String)e.getText())) {
            Matcher m;
            if (line.length() < prefixLength || !(m = SUPPRESS_PATTERN.matcher(line.substring(prefixLength))).matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)m.group(1), (String)toolId)) continue;
            return true;
        }
        return false;
    }

    private static int prefixLength(@NotNull PsiElement element2) {
        Commenter commenter;
        if (element2 == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(13);
        }
        String prefix = (String)ObjectUtils.notNull((Object)((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element2.getContainingFile().getLanguage())) == null ? null : commenter.getLineCommentPrefix()), (Object)"");
        return prefix.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "leafs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionsForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionsForStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "leafs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "firstLeaf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nextLeaf";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInComment";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prefixLength";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$leafs$7";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSuppressions$6";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSuppressionsForStatement$5";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSuppressionsForFile$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

