/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.util.ProcessingContext;
import java.io.File;
import java.util.Map;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationOnPath;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class P4MoveToChangeListOperation
extends VcsOperationOnPath {
    public P4MoveToChangeListOperation() {
    }

    public P4MoveToChangeListOperation(Change c, String changeList) {
        super(changeList, ChangesUtil.getFilePath((Change)c).getPath());
    }

    @Override
    public void execute(Project project, ProcessingContext context) throws VcsException {
        File f = new File(this.myPath);
        long changeListNumber = this.getPerforceChangeList(project, P4File.createInefficientFromLocalPath(this.myPath), context);
        PerforceRunner.getInstance(project).reopen(new File[]{f}, changeListNumber);
        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(this.getFilePath());
    }

    @Override
    public void fillReopenedPaths(Map<String, String> result) {
        result.put(this.myPath, this.myChangeList);
    }

    @Override
    public VcsOperation checkMerge(VcsOperation oldOp) {
        if (oldOp instanceof VcsOperationOnPath && ((VcsOperationOnPath)oldOp).getPath().equals(this.myPath) || oldOp instanceof P4MoveRenameOperation && ((P4MoveRenameOperation)oldOp).newPath.equals(this.myPath)) {
            VcsOperation clone = (VcsOperation)oldOp.clone();
            clone.setChangeList(this.myChangeList);
            return clone;
        }
        return super.checkMerge(oldOp);
    }
}

