/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSTypeCastImpl;
import com.intellij.lang.javascript.frameworks.react.ReactComponent;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXPropTypesUtil {
    public static final String PROPS_IS_REQUIRED_NAME = "isRequired";
    public static final String PROPS_FIELD_NAME = "props";

    @NotNull
    public static Stream<JSPsiElementBase> resolveNamespacePropTypes(@NotNull ReactComponent reactComponent, @NotNull GlobalSearchScope scope) {
        if (reactComponent == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(1);
        }
        String namespace = reactComponent.getNamespace().replace(".props", ".propTypes");
        Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(namespace, scope);
        if (elements.size() == 0) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(2);
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = elements.stream().flatMap(element -> {
            Collection<PsiElement> meaningfulElements = JSStubBasedPsiTreeUtil.calculateMeaningfulElements((PsiElement)element);
            return meaningfulElements.stream().flatMap(meaningfulElement -> {
                JSExpression initializer;
                if (meaningfulElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)meaningfulElement).getInitializerOrStub()) != null) {
                    meaningfulElement = initializer;
                }
                if (meaningfulElement instanceof JSDefinitionExpression) {
                    String reference = ((JSDefinitionExpression)meaningfulElement).getInitializerReference();
                    if (!StringUtil.isEmptyOrSpaces((String)reference)) {
                        Collection<PsiElement> resolvedElements = new ES6QualifiedNameResolver((PsiElement)meaningfulElement, true).resolveQualifiedName(reference);
                        meaningfulElement = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
                    } else {
                        JSExpression initializerOrStub = ((JSDefinitionExpression)meaningfulElement).getInitializerOrStub();
                        if (initializerOrStub != null) {
                            meaningfulElement = initializerOrStub;
                        }
                    }
                }
                if (meaningfulElement instanceof JSObjectLiteralExpression) {
                    return JSXPropTypesUtil.convertObjectLiteralToPropsType((JSObjectLiteralExpression)meaningfulElement);
                }
                return Stream.empty();
            });
        }).distinct();
        if (stream == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSPsiElementBase> convertObjectLiteralToPropsType(@NotNull JSObjectLiteralExpression expression) {
        JSProperty[] properties;
        if (expression == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(4);
        }
        if ((properties = expression.getProperties()).length == 0) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(5);
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = Arrays.stream(properties).filter(el -> el.getName() != null).map(property -> {
            Collection elements;
            JSElementIndexingData data = property.getIndexingData();
            if (data != null && (elements = data.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    if (!element.getQualifiedName().endsWith("props." + element.getName())) continue;
                    return element;
                }
            }
            String name = property.getName();
            assert (name != null);
            return JSXPropTypesUtil.createSimpleImplicitElement(property, name);
        });
        if (stream == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    public static JSImplicitElementImpl createImplicitReactPropsElement(@NotNull JSProperty property, @NotNull JSQualifiedNameImpl prop) {
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(7);
        }
        if (prop == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(8);
        }
        JSImplicitElementImpl.Builder propBuilder = new JSImplicitElementImpl.Builder(prop, (PsiElement)property).setContext(JSContext.UNKNOWN).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(true);
        JSExpression value = property.getValue();
        if (value != null) {
            JSType jsType = JSXPropTypesUtil.fromPropType(value);
            propBuilder = propBuilder.setTypeString(JSTypeUtils.serializeType(jsType));
        }
        if (JSXPropTypesUtil.isRequired(value)) {
            propBuilder.setUserString("r");
        }
        JSImplicitElementImpl jSImplicitElementImpl = propBuilder.toImplicitElement();
        if (jSImplicitElementImpl == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(9);
        }
        return jSImplicitElementImpl;
    }

    private static JSImplicitElement createSimpleImplicitElement(@NotNull JSProperty property, @NotNull String name) {
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(10);
        }
        if (name == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(11);
        }
        return new JSLocalImplicitElementImpl(name, null, (PsiElement)property, JSImplicitElement.Type.Property);
    }

    private static boolean isRequired(@Nullable JSExpression value) {
        return value instanceof JSReferenceExpression && PROPS_IS_REQUIRED_NAME.equals(((JSReferenceExpression)value).getReferenceName());
    }

    @Nullable
    public static JSType getFlowGenericTypes(@NotNull JSClass contextClass, boolean stateGenerics) {
        JSReferenceList list;
        if (contextClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(12);
        }
        if ((list = contextClass.getExtendsList()) == null) {
            return null;
        }
        for (JSReferenceListMember refMember : list.getMembers()) {
            int startIndex;
            String text = refMember.getReferenceText();
            if (text == null || !JSXPropTypesUtil.isPossibleReactClassName(text)) continue;
            JSTypeDeclaration[] arguments = refMember.getTypeArguments();
            int argsLength = arguments.length;
            int n = startIndex = stateGenerics ? 1 : 0;
            if (argsLength <= startIndex) continue;
            return TypeScriptTypeParser.buildTypeFromTypeScript(argsLength == 3 ? arguments[startIndex + 1] : arguments[startIndex]);
        }
        return null;
    }

    public static boolean isPossibleReactClassName(@NotNull String text) {
        if (text == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(13);
        }
        int index = text.lastIndexOf(46) + 1;
        String className = text.contains(".") && index < text.length() ? text.substring(index) : text;
        return TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(className);
    }

    @NotNull
    public static JSType fromPropType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(14);
        }
        if (expression instanceof JSReferenceExpression && PROPS_IS_REQUIRED_NAME.equals(((JSReferenceExpression)expression).getReferenceName())) {
            expression = ((JSReferenceExpression)expression).getQualifier();
        }
        JSTypeSource emptySource = JSTypeSource.EMPTY;
        if (expression instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)expression).getReferenceName();
            if ("string".equals(name) || "object".equals(name) || "number".equals(name) || "array".equals(name) || "symbol".equals(name)) {
                JSType jSType = JSNamedTypeFactory.createType(StringUtil.capitalize((String)name), emptySource, JSContext.INSTANCE);
                if (jSType == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(15);
                }
                return jSType;
            }
            if ("bool".equals(name)) {
                JSType jSType = JSNamedTypeFactory.createType("Boolean", emptySource, JSContext.INSTANCE);
                if (jSType == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(16);
                }
                return jSType;
            }
            if ("func".equals(name)) {
                JSType jSType = JSNamedTypeFactory.createFunctionType(emptySource, JSTypeContext.INSTANCE, false);
                if (jSType == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(17);
                }
                return jSType;
            }
        }
        if (expression instanceof JSCallExpression) {
            JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                JSAnyType jSAnyType = JSAnyType.get(emptySource);
                if (jSAnyType == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(18);
                }
                return jSAnyType;
            }
            String name = ((JSReferenceExpression)methodExpression).getReferenceName();
            JSExpression firstArgument = (JSExpression)ArrayUtil.getFirstElement((Object[])((JSCallExpression)expression).getArguments());
            if (StringUtil.equals((CharSequence)name, (CharSequence)"instanceOf") && firstArgument instanceof JSReferenceExpression) {
                String text = firstArgument.getText();
                JSType jSType = JSNamedTypeFactory.createType(text, emptySource, JSContext.INSTANCE);
                if (jSType == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(19);
                }
                return jSType;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"shape") && firstArgument instanceof JSObjectLiteralExpression) {
                JSObjectLiteralExpression shapeLiteral = (JSObjectLiteralExpression)firstArgument;
                List properties = ContainerUtil.mapNotNull((Object[])shapeLiteral.getProperties(), t -> {
                    String propertyName = t.getName();
                    JSExpression value = t.getValue();
                    if (propertyName == null || value == null) {
                        return null;
                    }
                    return new JSRecordTypeImpl.PropertySignatureImpl(propertyName, JSXPropTypesUtil.fromPropType(value), JSXPropTypesUtil.isRequired(value));
                });
                JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(emptySource, properties);
                if (jSRecordTypeImpl == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(20);
                }
                return jSRecordTypeImpl;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"oneOf") && firstArgument instanceof JSArrayLiteralExpression) {
                Object[] expressions = ((JSArrayLiteralExpression)firstArgument).getExpressions();
                List types = ContainerUtil.mapNotNull((Object[])expressions, e -> e instanceof JSLiteralExpression ? JSTypeEvaluator.getTypeFromConstant(e) : null);
                JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(emptySource, types);
                if (jSCompositeTypeImpl == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(21);
                }
                return jSCompositeTypeImpl;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"arrayOf") && firstArgument != null) {
                JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(JSXPropTypesUtil.fromPropType(firstArgument), emptySource);
                if (jSArrayTypeImpl == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(22);
                }
                return jSArrayTypeImpl;
            }
        }
        JSAnyType jSAnyType = JSAnyType.get(emptySource);
        if (jSAnyType == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(23);
        }
        return jSAnyType;
    }

    @NotNull
    public static String toPropType(String qualifier, @Nullable JSType type, @NotNull PsiElement context) {
        if (context == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(24);
        }
        if (type != null && !(type instanceof JSAnyType) && !(type instanceof JSUnionOrIntersectionType) && JSTypeUtils.hasFunctionType(type, false, context)) {
            String string = qualifier + ".func";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        if (type instanceof JSRecordType) {
            String string = qualifier + String.format(".shape({%s})", StringUtil.join((Collection)((JSRecordType)type).getTypeMembers(), t -> {
                if (context == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(47);
                }
                if (t instanceof JSRecordType.PropertySignature) {
                    return ((JSRecordType.PropertySignature)t).getMemberName() + ":" + JSXPropTypesUtil.toPropType(qualifier, ((JSRecordType.PropertySignature)t).getType(), context);
                }
                return "";
            }, (String)","));
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        if (type instanceof JSBooleanType) {
            String string = qualifier + ".bool";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (type instanceof JSStringType) {
            String string = qualifier + ".string";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        if (type instanceof JSNumberType) {
            String string = qualifier + ".number";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(29);
            }
            return string;
        }
        if (type instanceof JSArrayType) {
            String string = qualifier + String.format(".arrayOf(%s)", JSXPropTypesUtil.toPropType(qualifier, ((JSArrayType)type).getType(), context));
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = qualifier + ".any";
        if (string == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public static JSType getGenericPropType(@NotNull XmlTag tag, @NotNull ReactComponent reactComponent) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(32);
        }
        if (reactComponent == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(33);
        }
        if (!DialectDetector.isJSX((PsiElement)tag)) {
            return null;
        }
        Collection<? extends PsiElement> elements = reactComponent.getElements();
        if (elements.isEmpty()) {
            return null;
        }
        List results = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            JSType currentResult = JSXPropTypesUtil.getPropsTypeFromPsiElement(psiElement, tag);
            JSXPropTypesUtil.addWithForceOptional(results, currentResult, reactComponent.isWeakResolve());
        }
        return JSXPropTypesUtil.unionPropTypes(tag, results);
    }

    private static void addWithForceOptional(@NotNull List<JSType> results, @Nullable JSType currentResult, boolean forceOptional) {
        if (results == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(34);
        }
        if (currentResult != null) {
            results.add(forceOptional ? currentResult.copyWithStrict(false) : currentResult);
        }
    }

    @Nullable
    private static JSType unionPropTypes(@NotNull XmlTag tag, @NotNull List<JSType> results) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(35);
        }
        if (results == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(36);
        }
        return results.size() <= 1 ? (JSType)ContainerUtil.getFirstItem(results) : JSContextualUnionTypeImpl.getContextualUnionType(results, JSTypeSourceFactory.createTypeSource((PsiElement)tag, false));
    }

    @Nullable
    private static JSType getTypeFromFunctionParameter(@NotNull JSFunction resolve) {
        JSParameterListElement[] parameters;
        JSType typeFromParam;
        if (resolve == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(37);
        }
        if ((typeFromParam = JSXPropTypesUtil.getPropsTypeFromParameters(parameters = resolve.getParameters())) != null) {
            return typeFromParam;
        }
        return null;
    }

    @Nullable
    private static JSType getPropsTypeFromParameters(@NotNull JSParameterListElement[] parameters) {
        if (parameters == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(38);
        }
        if (parameters.length == 0 || parameters.length > 2) {
            return null;
        }
        JSParameterListElement propParameter = parameters[0];
        boolean hasTypeElement = propParameter.getTypeElement() != null;
        JSType type = propParameter.getType();
        if (type != null) {
            return hasTypeElement ? type : type.copyWithStrict(false);
        }
        JSType elementType = DialectDetector.isTypeScript((PsiElement)propParameter) ? JSResolveUtil.getElementJSType((PsiElement)propParameter, JSEvaluateContext.JSEvaluationPlace.DEFAULT) : null;
        return elementType;
    }

    @Nullable
    private static JSType getPropsTypeFromPsiElementImpl(@NotNull XmlTag tag, @Nullable PsiElement elementOrExpression) {
        JSTypeDeclaration type;
        JSExpression initializerOrStub;
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(39);
        }
        if (elementOrExpression == null) {
            return null;
        }
        if (elementOrExpression instanceof JSDefinitionExpression && (initializerOrStub = ((JSDefinitionExpression)elementOrExpression).getInitializerOrStub()) != null) {
            elementOrExpression = initializerOrStub;
        }
        if (elementOrExpression instanceof FlowJSTypeCastImpl && (type = ((FlowJSTypeCastImpl)elementOrExpression).getResultType()) != null) {
            JSType jsType = TypeScriptTypeParser.buildTypeFromTypeScript(type);
            return JSXPropTypesUtil.getPropsTypeFromJsType(tag, jsType);
        }
        if (elementOrExpression instanceof JSClass) {
            return JSXPropTypesUtil.getPropsTypeFromClass(tag, (JSClass)elementOrExpression);
        }
        if (elementOrExpression instanceof JSFunction) {
            return JSXPropTypesUtil.getPropsTypeFromFunction(tag, (JSFunction)elementOrExpression);
        }
        if (!DialectDetector.isTypeScript(elementOrExpression)) {
            return null;
        }
        JSType varType = JSResolveUtil.getElementJSType(elementOrExpression, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        if (varType != null) {
            JSType genericStatelessArg;
            if (varType instanceof JSGenericTypeImpl && (genericStatelessArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)varType, JSXPropTypesUtil::isReactSingleVariantComponent, true)) != null) {
                return genericStatelessArg;
            }
            return JSXPropTypesUtil.getPropsTypeFromJsType(tag, varType);
        }
        return null;
    }

    @Nullable
    private static JSType getPropsTypeFromClass(@NotNull XmlTag tag, @NotNull JSClass componentClass) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(40);
        }
        if (componentClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(41);
        }
        JSType props = JSXPropTypesUtil.getPropsFieldType(componentClass);
        JSType propTypes = JSXPropTypesUtil.getPropTypesStaticFieldType(componentClass);
        return JSXPropTypesUtil.unionPropTypes(tag, StreamEx.of((Object[])new JSType[]{props, propTypes}).nonNull().toList());
    }

    @Nullable
    private static JSType getPropTypesStaticFieldType(@NotNull JSClass componentClass) {
        JSField propTypes;
        if (componentClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(42);
        }
        if ((propTypes = componentClass.findFieldByName("propTypes")) == null || propTypes.getTypeElement() == null) {
            return null;
        }
        JSType type = JSTypeUtils.getValuableType(propTypes.getType());
        if (type == null) {
            return null;
        }
        return type;
    }

    @Nullable
    private static JSType getPropsFieldType(@NotNull JSClass componentClass) {
        JSType result2;
        JSType genericsType;
        if (componentClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(43);
        }
        if (DialectDetector.isFlow((PsiElement)componentClass) && (genericsType = JSXPropTypesUtil.getFlowGenericTypes(componentClass, false)) != null && !(genericsType instanceof JSAnyType)) {
            return genericsType;
        }
        JSRecordType type = TypeScriptTypeParser.buildTypeFromClass(componentClass, false);
        if (!type.hasMembers()) {
            return null;
        }
        JSRecordType.PropertySignature signature = type.findPropertySignature(PROPS_FIELD_NAME);
        if (signature != null && (result2 = signature.getType()) != null && !(result2 instanceof JSAnyType)) {
            return result2;
        }
        return null;
    }

    @Nullable
    @Contract(value="_,null -> null")
    private static JSType getPropsTypeFromJsType(XmlTag tag, @Nullable JSType type) {
        if (type == null) {
            return null;
        }
        StreamEx returnTypes = ((StreamEx)StreamEx.of((Collection)type.asRecordType().getCallSignatures()).filter(el -> el.hasNew())).nonNull().map(el -> el.getReturnType());
        for (JSType returnType : returnTypes.toList()) {
            String className;
            JSGenericTypeImpl genericType;
            JSType innerType;
            JSType classPropTypes;
            JSResolvedTypeInfo info;
            JSClass resolved;
            if (returnType instanceof JSResolvableType && (resolved = (info = ((JSResolvableType)returnType).resolveType()).getDeclarationOfType(JSClass.class)) != null && (classPropTypes = JSXPropTypesUtil.getPropsTypeFromClass(tag, resolved)) != null) {
                return classPropTypes;
            }
            if (!(returnType instanceof JSGenericTypeImpl) || !((innerType = (genericType = (JSGenericTypeImpl)returnType).getType()) instanceof JSResolvableType)) continue;
            JSResolvedTypeInfo info2 = ((JSResolvableType)innerType).resolveType();
            JSClass aClass = info2.getDeclarationOfType(JSClass.class);
            String string = className = aClass == null ? null : aClass.getName();
            if (className == null) {
                String string2 = className = innerType instanceof JSNamedType ? innerType.getTypeText() : null;
            }
            if (!TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(className)) continue;
            JSRecordType.PropertySignature signature = returnType.asRecordType().findPropertySignature(PROPS_FIELD_NAME);
            if (signature != null) {
                return signature.getType();
            }
            return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
        }
        return null;
    }

    @Nullable
    private static JSType getPropsTypeFromFunction(@NotNull XmlTag tag, @NotNull JSFunction resolvedElementOrExpression) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(44);
        }
        if (resolvedElementOrExpression == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(45);
        }
        if (resolvedElementOrExpression instanceof TypeScriptFunction && ((TypeScriptFunction)resolvedElementOrExpression).isOverloadImplementation()) {
            ArrayList allTypes = ContainerUtil.newArrayList();
            for (TypeScriptFunction overload : ((TypeScriptFunction)resolvedElementOrExpression).getOverloadDeclarations()) {
                JSType typeFromParam;
                if (overload.isOverloadImplementation() || (typeFromParam = JSXPropTypesUtil.getTypeFromFunctionParameter((JSFunction)overload)) == null) continue;
                allTypes.add(typeFromParam);
            }
            if (allTypes.size() >= 1) {
                return JSContextualUnionTypeImpl.getContextualUnionType(allTypes, JSTypeSourceFactory.createTypeSource((PsiElement)tag, true));
            }
        }
        return JSXPropTypesUtil.getTypeFromFunctionParameter(resolvedElementOrExpression);
    }

    @Contract(value="null -> false")
    private static boolean isReactSingleVariantComponent(@Nullable JSType t) {
        if (!(t instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)t).resolveType();
        JSClass declaration = (JSClass)info.getDeclarationOfType(TypeScriptInterface.class);
        if (declaration == null) {
            declaration = (JSClass)info.getDeclarationOfType(TypeScriptTypeAlias.class);
        }
        return declaration != null && TypeScriptReactComponentUtil.REACT_SINGLE_VARIANT_COMPONENT_NAMES.contains(declaration.getName());
    }

    @Nullable
    private static JSType getPropsTypeFromPsiElement(@Nullable PsiElement resolve, @NotNull XmlTag tag) {
        JSType result2;
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(46);
        }
        if ((result2 = JSXPropTypesUtil.getPropsTypeFromPsiElementImpl(tag, resolve)) == null) {
            return null;
        }
        return JSTypeUtils.applyGenericArguments(result2, TypeScriptReactComponentUtil.getGenericSubstitutorForTag(resolve, tag));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reactComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: 
            case 35: 
            case 39: 
            case 40: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElementOrExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNamespacePropTypes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertObjectLiteralToPropsType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitReactPropsElement";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPropType";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "toPropType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespacePropTypes";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertObjectLiteralToPropsType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitReactPropsElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleImplicitElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFlowGenericTypes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleReactClassName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fromPropType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toPropType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGenericPropType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addWithForceOptional";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "unionPropTypes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromFunctionParameter";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromParameters";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromPsiElementImpl";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromClass";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPropTypesStaticFieldType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPropsFieldType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromFunction";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromPsiElement";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$toPropType$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

