/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSConstructorReturnsPrimitiveInspection
extends JSInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.constructor.returns.primitive.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSConstructorReturnsPrimitiveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReturnStatement(JSReturnStatement node) {
                DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
                if (dialect != null && !dialect.isJavaScript()) {
                    return;
                }
                super.visitJSReturnStatement(node);
                JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                if (function == null || JSPsiImplUtils.isArrowFunction(function)) {
                    return;
                }
                if (JSClassUtils.isClassMember((PsiElement)function) && !function.isConstructor()) {
                    return;
                }
                if (function.isGetProperty()) {
                    return;
                }
                String name = function.getName();
                if (!JSSymbolUtil.isDefinitelyConstructor((PsiElement)function) && !JSSymbolUtil.isConstructorName(name)) {
                    return;
                }
                JSType returnType = function.getReturnType();
                if (returnType != null && returnType.getSource().isExplicitlyDeclared()) {
                    return;
                }
                JSExpression expression = node.getExpression();
                JSType type = JSResolveUtil.getExpressionJSType(expression);
                if (type instanceof JSPrimitiveType && ((JSPrimitiveType)type).isPrimitive() || type instanceof JSNullType || type instanceof JSUndefinedType) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.constructor.returns.primitive.inspection.problem", (Object[])new Object[0]), new LocalQuickFix[]{new SetJSDocReturnTypeFix(type.getTypeText(JSType.TypeTextFormat.CODE))});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSConstructorReturnsPrimitiveInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SetJSDocReturnTypeFix
    implements LocalQuickFix {
        private final String myType;

        private SetJSDocReturnTypeFix(String type) {
            this.myType = type;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.constructor.returns.primitive.inspection.quickfix", (Object[])new Object[]{this.myType});
            if (string == null) {
                SetJSDocReturnTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            JSFunction function;
            if (project == null) {
                SetJSDocReturnTypeFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                SetJSDocReturnTypeFix.$$$reportNull$$$0(2);
            }
            if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), JSFunction.class)) != null) {
                List<String> tagsToCreate = Collections.singletonList("return {" + this.myType + "}");
                JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)function, tagsToCreate, null, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

