/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;

public class JSReferencingArgumentsOutsideOfFunctionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "arguments") && PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class) == null && PsiTreeUtil.getParentOfType((PsiElement)node, XmlAttributeValue.class) == null && node.multiResolve(false).length == 0) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.validation.message.arguments.out.of.function", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (jSElementVisitor == null) {
            JSReferencingArgumentsOutsideOfFunctionInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.bitwise.operator.usage.name", (Object[])new Object[0]);
        if (string == null) {
            JSReferencingArgumentsOutsideOfFunctionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSReferencingArgumentsOutsideOfFunctionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

