/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInsertModifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(JSInsertModifierFix.class);
    private final JSAttributeList.ModifierType myModifier;

    public JSInsertModifierFix(JSAttributeListOwner element, JSAttributeList.ModifierType modifier) {
        super((PsiElement)element);
        this.myModifier = modifier;
    }

    public static String getSetModifierText(@NotNull JSAttributeListOwner myClassOrMethod, @NotNull String modifierOrVisibility) {
        if (myClassOrMethod == null) {
            JSInsertModifierFix.$$$reportNull$$$0(0);
        }
        if (modifierOrVisibility == null) {
            JSInsertModifierFix.$$$reportNull$$$0(1);
        }
        return JSBundle.message((String)"javascript.fix.set.element.visibility", (Object[])new Object[]{new JSNamedElementPresenter((PsiElement)myClassOrMethod).describeWithShortName(), modifierOrVisibility});
    }

    @Nls
    @NotNull
    public String getText() {
        JSAttributeListOwner myClassOrMethod = (JSAttributeListOwner)this.getStartElement();
        if (myClassOrMethod == null) {
            if ("" == null) {
                JSInsertModifierFix.$$$reportNull$$$0(2);
            }
            return "";
        }
        String string = JSInsertModifierFix.getSetModifierText(myClassOrMethod, this.getModifier().keyword);
        if (string == null) {
            JSInsertModifierFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private JSAttributeList.ModifierType getModifier() {
        return this.myModifier;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSInsertModifierFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSInsertModifierFix.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            JSInsertModifierFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            JSInsertModifierFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            JSInsertModifierFix.$$$reportNull$$$0(8);
        }
        if (!(endElement instanceof JSAttributeListOwner)) {
            return;
        }
        JSAttributeListOwner owner = (JSAttributeListOwner)endElement;
        JSAttributeList list = owner.getAttributeList();
        if (list == null) {
            LOG.error("Attribute list must exist");
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(list);
        wrapper.overrideModifier(this.getModifier(), true);
        wrapper.applyTo(owner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClassOrMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierOrVisibility";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSetModifierText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

