/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.intentions.ES6ReplaceImportFromClauseFix;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptPreferShortImportInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptPreferShortImportInspection.calcShortNameFromClass(TypeScriptPreferShortImportInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
                if (importDeclaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                TypeScriptPreferShortImportInspection.inspectImport(holder, importDeclaration);
                super.visitES6ImportDeclaration(importDeclaration);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDeclaration", "com/intellij/lang/typescript/inspection/TypeScriptPreferShortImportInspection$1", "visitES6ImportDeclaration"));
            }
        };
        if (jSElementVisitor == null) {
            TypeScriptPreferShortImportInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static void inspectImport(ProblemsHolder holder, ES6ImportDeclaration importDeclaration) {
        PsiFile currentFile;
        boolean toProcess;
        if (!DialectDetector.isTypeScript((PsiElement)importDeclaration)) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!ArrayUtil.isEmpty((Object[])importDeclaration.getImportedBindings())) {
            return;
        }
        Object[] specifiers = importDeclaration.getImportSpecifiers();
        if (ArrayUtil.isEmpty((Object[])specifiers)) {
            return;
        }
        ArrayList elements = ContainerUtil.newArrayList();
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return;
        }
        String text = StringUtil.notNullize((String)clause.getReferenceText());
        String unquotedOldText = JSStringUtil.unquoteAndUnescapeStringLiteralValue(text);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        boolean bl = toProcess = unquotedOldText.startsWith(".") || unquotedOldText.endsWith("index");
        if (!toProcess) {
            return;
        }
        Collection refElements = clause.resolveReferencedElements();
        if (refElements.isEmpty()) {
            return;
        }
        if (!TypeScriptPreferShortImportInspection.fillSpecifierElements((ES6ImportSpecifier[])specifiers, elements) || elements.isEmpty()) {
            return;
        }
        JSQualifiedNamedElement item = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((List)elements);
        assert (item != null);
        Project project = importDeclaration.getProject();
        JSModuleNameInfo info = ES6CreateImportUtil.getExternalFileModuleName((JSElement)item, (PsiElement)importDeclaration, false);
        ProgressIndicatorProvider.checkCanceled();
        if (info == null) {
            return;
        }
        String unquotedNewName = info.getModuleName();
        if (unquotedNewName.length() >= StringUtil.trimEnd((String)unquotedOldText, (String)"/").length()) {
            return;
        }
        if (unquotedNewName.equals("./") || unquotedNewName.equals("../")) {
            return;
        }
        List sublist = elements.subList(1, elements.size());
        VirtualFile module = info.getResolvedFile();
        if (module.equals((currentFile = importDeclaration.getContainingFile()).getVirtualFile())) {
            return;
        }
        for (JSQualifiedNamedElement elementToImport : sublist) {
            if (ES6CreateImportUtil.checkSymbolInFile(project, module, (PsiElement)elementToImport, (PsiElement)currentFile)) continue;
            return;
        }
        ASTNode node = clause.getNode();
        ASTNode literalNode = node.findChildByType(JSTokenTypes.STRING_LITERALS);
        if (literalNode == null) {
            return;
        }
        holder.registerProblem(literalNode.getPsi(), JSBundle.message((String)"typescript.prefer.short.import.name", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ReplaceImportFromClauseFix((ES6ImportExportDeclaration)importDeclaration, unquotedNewName)});
    }

    private static boolean fillSpecifierElements(@NotNull ES6ImportSpecifier[] specifiers, @NotNull List<JSQualifiedNamedElement> elements) {
        if (specifiers == null) {
            TypeScriptPreferShortImportInspection.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            TypeScriptPreferShortImportInspection.$$$reportNull$$$0(2);
        }
        for (ES6ImportSpecifier specifier : specifiers) {
            String name = specifier.getName();
            ResolveResult[] results = specifier.resolveOverAliases();
            List<PsiElement> candidates = JSResolveResult.toElements(results);
            for (PsiElement candidate : candidates) {
                if (!(candidate instanceof JSQualifiedNamedElement)) {
                    return false;
                }
                String candidateName = ((JSQualifiedNamedElement)candidate).getName();
                if (!StringUtil.equals((CharSequence)name, (CharSequence)candidateName)) {
                    return false;
                }
                elements.add((JSQualifiedNamedElement)candidate);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptPreferShortImportInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptPreferShortImportInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillSpecifierElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

