/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.symfonycomponent;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.data.FrameworkOption;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentOption;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentParameter;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import java.util.ArrayList;
import java.util.List;

class SymfonyComponentCommand
implements Cloneable {
    private String name;
    private String description;
    private String usageText;
    private List<SymfonyComponentParameter> params = new ArrayList<SymfonyComponentParameter>();
    private List<SymfonyComponentOption> options = new ArrayList<SymfonyComponentOption>();
    private String helpText;

    SymfonyComponentCommand() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public void setUsageText(String usageText) {
        this.usageText = usageText;
    }

    public List<SymfonyComponentParameter> getParams() {
        return this.params;
    }

    public void addParam(SymfonyComponentParameter parameter) {
        this.params.add(parameter);
    }

    public List<SymfonyComponentOption> getOptions() {
        return this.options;
    }

    public void addOption(SymfonyComponentOption option) {
        this.options.add(option);
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public FrameworkCommand standardize(FrameworkDescription framework) {
        ArrayList<FrameworkCommand.Parameter> standardParameters = new ArrayList<FrameworkCommand.Parameter>(this.params.size());
        for (SymfonyComponentParameter param : this.params) {
            standardParameters.add(param.standardize());
        }
        StringBuilder extendedHelp = new StringBuilder();
        if (!StringUtil.isEmptyOrSpaces((String)this.helpText)) {
            extendedHelp.append(this.helpText).append("<br/><br/>");
        } else if (!StringUtil.isEmptyOrSpaces((String)this.description)) {
            extendedHelp.append(this.description).append("<br/><br/>");
        }
        SymfonyComponentUtils.appendOptions(extendedHelp, this.options);
        ArrayList<FrameworkOption> beforeOptions = new ArrayList<FrameworkOption>();
        for (SymfonyComponentOption option : this.options) {
            beforeOptions.add(option.standardize());
        }
        return new FrameworkCommand(this.name, standardParameters, false, extendedHelp.toString(), beforeOptions, framework);
    }

    protected SymfonyComponentCommand clone() {
        try {
            return (SymfonyComponentCommand)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public SymfonyComponentCommand cloneWithAlias(String alias) {
        SymfonyComponentCommand clone = this.clone();
        ArrayList<SymfonyComponentParameter> params = new ArrayList<SymfonyComponentParameter>(clone.getParams().size());
        for (SymfonyComponentParameter param : clone.getParams()) {
            params.add(param.clone());
        }
        clone.params = params;
        ArrayList<SymfonyComponentOption> options = new ArrayList<SymfonyComponentOption>(clone.getOptions().size());
        for (SymfonyComponentOption option : clone.getOptions()) {
            options.add(option.clone());
        }
        clone.options = options;
        clone.setName(alias);
        return clone;
    }
}

