/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.ImportQueryGenerator;
import com.intellij.database.remote.dbimport.Query;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import com.intellij.util.ThrowableRunnable;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteBatchPreparedStatementImpl
extends RemotePreparedStatementImpl<PreparedStatement>
implements RemoteBatchPreparedStatement {
    private static final String CHECK_CONNECTION = "Check connection and database settings and try again";
    private static final String ROLLBACK_ERROR = "Can't rollback changes with error records. Check connection and database settings and try again";
    private static final String SAVE_ERROR = "Can't save current transaction state. Check connection and database settings and try again";
    private static final int MAX_LINES_PER_TRANSACTION = 1000;
    private static final int[] EMPTY_INTS = new int[0];
    protected int myBatchSize;
    private final ImportQueryGenerator myGenerator;
    private final RemotePreparedStatement myOneLineStatement;
    private final String myLockQuery;
    private final Connection myConnection;
    private final int myLines;
    private final boolean myUseTransactions;
    private Savepoint myLastState;
    private int myCurrentLines;
    private int myApprovedLines;
    private int myImportedLines;

    protected RemoteBatchPreparedStatementImpl(@NotNull Configuration configuration, @NotNull PreparedStatement delegate, @NotNull PreparedStatement oneLineStatement, @NotNull Connection connection, @NotNull JdbcHelperImpl helper) {
        if (configuration == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(1);
        }
        if (oneLineStatement == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(2);
        }
        if (connection == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(3);
        }
        if (helper == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(4);
        }
        super(delegate, helper);
        this.myOneLineStatement = new MyInsider(oneLineStatement, 1);
        this.myLockQuery = configuration.lockQuery;
        this.myGenerator = new ImportQueryGenerator(this, configuration.infos, configuration.useBatches, configuration.lines);
        this.myConnection = connection;
        this.myLines = configuration.lines;
        this.myUseTransactions = configuration.useTransactions;
    }

    @Override
    @NotNull
    public List<ErrorRecord> addBatch(@NotNull BatchRecords records, @NotNull String lastSql) throws SQLException, RemoteException {
        if (records == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(5);
        }
        if (lastSql == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(6);
        }
        try {
            List<Query> generate = this.myGenerator.generate(lastSql, records);
            for (Query query : generate) {
                query.execute();
            }
        }
        catch (SQLException e) {
            throw this.rethrowException(e);
        }
        List<ErrorRecord> list = this.myGenerator.getErrors();
        if (list == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public void addBatch() throws RemoteException, SQLException {
        this.addBatchInternal(new MyComputable<Void>(){

            @Override
            public Void compute() throws SQLException, RemoteException {
                RemoteBatchPreparedStatementImpl.super.addBatch();
                return null;
            }
        }, this.myLines);
    }

    @NotNull
    public RemotePreparedStatement withLines(String sql, int lines) throws SQLException, RemoteException {
        PreparedStatement statement = this.myConnection.prepareStatement(sql);
        MyInsider myInsider = new MyInsider(statement, lines);
        if (myInsider == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(8);
        }
        return myInsider;
    }

    @Override
    public long getInsertedLinesCount() {
        return this.myImportedLines;
    }

    @Override
    public void close() throws RemoteException, SQLException {
        try {
            this.commitIfNeeded(true);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        finally {
            JdbcNativeUtil.closeRemoteStatementSafe(this.myOneLineStatement);
            super.close();
        }
    }

    private void addBatchInternal(@NotNull MyComputable<Void> computable, int lines) throws RemoteException, SQLException {
        if (computable == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(9);
        }
        try {
            if (this.myBatchSize == 0) {
                this.onBatchStart();
            }
            computable.compute();
            this.myBatchSize += lines;
        }
        catch (SQLException e) {
            this.onAddBatchError();
        }
    }

    private int[] executeBatchInternal(@NotNull MyComputable<int[]> computable) throws RemoteException, SQLException {
        if (computable == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(10);
        }
        try {
            if (this.myBatchSize == 0) {
                return EMPTY_INTS;
            }
            int[] result = computable.compute();
            this.myCurrentLines += this.myBatchSize;
            this.myBatchSize = 0;
            this.approveLines();
            this.commitIfNeeded();
            this.onSuccessfulExecuteBatch();
            return result;
        }
        catch (IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException e) {
            this.onExecuteBatchError();
            throw e;
        }
    }

    private int executeUpdateInternal(@NotNull MyComputable<Integer> computable) throws RemoteException, SQLException {
        if (computable == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(11);
        }
        try {
            int result = computable.compute();
            this.myCurrentLines += result;
            this.approveLines();
            this.commitIfNeeded();
            this.onSuccessfulExecuteUpdate();
            return result;
        }
        catch (IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException e) {
            this.onExecuteUpdateError();
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws RemoteException, SQLException {
        return this.executeBatchInternal(new MyComputable<int[]>(){

            @Override
            public int[] compute() throws SQLException, RemoteException {
                return RemoteBatchPreparedStatementImpl.super.executeBatch();
            }
        });
    }

    @Override
    public int executeUpdate() throws RemoteException, SQLException {
        return this.executeUpdateInternal(new MyComputable<Integer>(){

            @Override
            public Integer compute() throws SQLException, RemoteException {
                return RemoteBatchPreparedStatementImpl.super.executeUpdate();
            }
        });
    }

    protected void rollback() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.myBatchSize = 0;
        this.myCurrentLines = 0;
        this.myApprovedLines = 0;
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                RemoteBatchPreparedStatementImpl.this.myConnection.rollback();
                RemoteBatchPreparedStatementImpl.this.lock();
            }
        }, ROLLBACK_ERROR);
    }

    protected void checkoutLastState() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.myCurrentLines = 0;
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                RemoteBatchPreparedStatementImpl.this.myLastState = RemoteBatchPreparedStatementImpl.this.myConnection.setSavepoint();
            }
        }, SAVE_ERROR);
    }

    protected void releaseLastState() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.approveLines();
        try {
            RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    if (RemoteBatchPreparedStatementImpl.this.myLastState != null) {
                        RemoteBatchPreparedStatementImpl.this.myConnection.releaseSavepoint(RemoteBatchPreparedStatementImpl.this.myLastState);
                    }
                }
            }, SAVE_ERROR);
        }
        finally {
            this.myLastState = null;
        }
    }

    protected void rollbackToLastState() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.myCurrentLines = 0;
        this.myBatchSize = 0;
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                if (RemoteBatchPreparedStatementImpl.this.myLastState == null) {
                    RemoteBatchPreparedStatementImpl.this.myConnection.rollback();
                    return;
                }
                RemoteBatchPreparedStatementImpl.this.myConnection.rollback(RemoteBatchPreparedStatementImpl.this.myLastState);
            }
        }, ROLLBACK_ERROR);
    }

    public void commitIfNeeded() throws SQLException {
        this.commitIfNeeded(false);
    }

    public void commitIfNeeded(boolean force) throws SQLException {
        if (!this.myUseTransactions) {
            this.linesCommitted();
            return;
        }
        if (!force && this.myApprovedLines < 1000) {
            return;
        }
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                RemoteBatchPreparedStatementImpl.this.myConnection.commit();
                RemoteBatchPreparedStatementImpl.this.linesCommitted();
                RemoteBatchPreparedStatementImpl.this.lock();
                RemoteBatchPreparedStatementImpl.this.myLastState = null;
            }
        }, SAVE_ERROR);
    }

    private void linesCommitted() {
        this.myImportedLines += this.myApprovedLines;
        this.myApprovedLines = 0;
    }

    private void approveLines() {
        this.myApprovedLines += this.myCurrentLines;
        this.myCurrentLines = 0;
    }

    protected abstract void onAddBatchError() throws RemoteException, SQLException;

    protected abstract void onBatchStart() throws RemoteException, SQLException;

    protected abstract void onExecuteBatchError() throws RemoteException, SQLException;

    protected abstract void onExecuteUpdateError() throws RemoteException, SQLException;

    protected abstract void onSuccessfulExecuteBatch() throws RemoteException, SQLException;

    protected abstract void onSuccessfulExecuteUpdate() throws RemoteException, SQLException;

    private void lock() throws SQLException {
        if (!this.myUseTransactions || this.myLockQuery == null) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.myConnection.createStatement();
            statement.execute(this.myLockQuery);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private static void run(@NotNull ThrowableRunnable<SQLException> runnable, @NotNull String message) throws SQLException {
        if (runnable == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(12);
        }
        if (message == null) {
            RemoteBatchPreparedStatementImpl.$$$reportNull$$$0(13);
        }
        try {
            runnable.run();
        }
        catch (SQLException e) {
            throw new IllegalTransactionStateException(e, message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oneLineStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastSql";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addBatch";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBatch";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBatchInternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeBatchInternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateInternal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyInsider
    extends RemotePreparedStatementImpl<PreparedStatement> {
        private final int myLines;

        private MyInsider(PreparedStatement delegate, int lines) {
            if (delegate == null) {
                MyInsider.$$$reportNull$$$0(0);
            }
            super(delegate, RemoteBatchPreparedStatementImpl.this.myHelper);
            this.myLines = lines;
        }

        @Override
        public void addBatch() throws RemoteException, SQLException {
            RemoteBatchPreparedStatementImpl.this.addBatchInternal(new MyComputable<Void>(){

                @Override
                public Void compute() throws SQLException, RemoteException {
                    MyInsider.super.addBatch();
                    return null;
                }
            }, this.myLines);
        }

        @Override
        public int[] executeBatch() throws RemoteException, SQLException {
            return RemoteBatchPreparedStatementImpl.this.executeBatchInternal(new MyComputable<int[]>(){

                @Override
                public int[] compute() throws SQLException, RemoteException {
                    return MyInsider.super.executeBatch();
                }
            });
        }

        @Override
        public int executeUpdate() throws RemoteException, SQLException {
            return RemoteBatchPreparedStatementImpl.this.executeUpdateInternal(new MyComputable<Integer>(){

                @Override
                public Integer compute() throws SQLException, RemoteException {
                    return MyInsider.super.executeUpdate();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl$MyInsider", "<init>"));
        }
    }

    public static class Configuration
    implements Serializable {
        public final String sql;
        public final String oneLineSql;
        public final String lockQuery;
        public final List<ColumnInfo> infos;
        public final boolean useTransactions;
        public final boolean useSavepoints;
        public final boolean useBatches;
        public final int lines;

        public Configuration(@NotNull String sql, @NotNull String oneLineSql, @Nullable String lockQuery, @NotNull List<ColumnInfo> infos, boolean useTransactions, boolean useSavepoints, boolean useBatches, int lines) {
            if (sql == null) {
                Configuration.$$$reportNull$$$0(0);
            }
            if (oneLineSql == null) {
                Configuration.$$$reportNull$$$0(1);
            }
            if (infos == null) {
                Configuration.$$$reportNull$$$0(2);
            }
            this.sql = sql;
            this.oneLineSql = oneLineSql;
            this.lockQuery = lockQuery;
            this.infos = infos;
            this.useTransactions = useTransactions;
            this.useSavepoints = useSavepoints;
            this.useBatches = useBatches;
            this.lines = lines;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sql";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oneLineSql";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "infos";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl$Configuration";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class IllegalTransactionStateException
    extends SQLException {
        public IllegalTransactionStateException(Throwable cause, String error) {
            super(error, cause);
        }
    }

    private static interface MyComputable<T> {
        public T compute() throws SQLException, RemoteException;
    }
}

