/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="PhpAnalysisConfiguration", storages={@Storage(value="php.xml")})
public class PhpAnalysisConfiguration
implements PersistentStateComponent<State> {
    public static final int ACCEPTABLE_CALL_TREE_ANALYSIS_DEPTH = 1;
    public static final int MAX_CALL_TREE_ANALYSIS_DEPTH = 3;
    public static final String RUNTIME_EXCEPTION = "\\RuntimeException";
    public static final String LOGIC_EXCEPTION = "\\LogicException";
    private final Project myProject;
    private State myState;

    public static PhpAnalysisConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            PhpAnalysisConfiguration.$$$reportNull$$$0(0);
        }
        return (PhpAnalysisConfiguration)ServiceManager.getService((Project)project, PhpAnalysisConfiguration.class);
    }

    public PhpAnalysisConfiguration(@NotNull Project project) {
        if (project == null) {
            PhpAnalysisConfiguration.$$$reportNull$$$0(1);
        }
        this.myState = new State();
        this.myProject = project;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            PhpAnalysisConfiguration.$$$reportNull$$$0(2);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpAnalysisConfiguration.$$$reportNull$$$0(3);
        }
        this.myState = state;
    }

    public void noStateLoaded() {
        State state = this.getState();
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(PhpCodeStyleSettings.class);
        state.setCallTreeAnalysisDepth(settings.PHPDOC_THROWS_CALL_TREE_ANALYSIS_DEPTH);
        Set<String> uncheckedExceptions = state.getUncheckedExceptions();
        if (!settings.PHPDOC_THROWS_IGNORE_RUNTIME_EXCEPTIONS) {
            uncheckedExceptions.remove(RUNTIME_EXCEPTION);
        }
        if (!settings.PHPDOC_THROWS_IGNORE_LOGIC_EXCEPTIONS) {
            uncheckedExceptions.remove(LOGIC_EXCEPTION);
        }
    }

    public int getCallTreeAnalysisDepth() {
        this.migrateCallTreeAnalysisDepth();
        return this.getState().getCallTreeAnalysisDepth();
    }

    private void migrateCallTreeAnalysisDepth() {
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(PhpCodeStyleSettings.class);
        this.getState().setCallTreeAnalysisDepth(settings.PHPDOC_THROWS_CALL_TREE_ANALYSIS_DEPTH);
    }

    public void setCallTreeAnalysisDepth(int callTreeAnalysisDepth) {
        this.setOldCallTreeAnalysisDepth(callTreeAnalysisDepth);
        this.getState().setCallTreeAnalysisDepth(callTreeAnalysisDepth);
    }

    private void setOldCallTreeAnalysisDepth(int callTreeAnalysisDepth) {
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(PhpCodeStyleSettings.class);
        settings.PHPDOC_THROWS_CALL_TREE_ANALYSIS_DEPTH = callTreeAnalysisDepth;
    }

    @NotNull
    public Set<String> getUncheckedExceptions() {
        this.migrateUncheckedExceptions();
        Set<String> set = Collections.unmodifiableSet(this.getState().getUncheckedExceptions());
        if (set == null) {
            PhpAnalysisConfiguration.$$$reportNull$$$0(4);
        }
        return set;
    }

    private void migrateUncheckedExceptions() {
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(PhpCodeStyleSettings.class);
        Set<String> uncheckedExceptions = this.getState().getUncheckedExceptions();
        if (!settings.PHPDOC_THROWS_IGNORE_RUNTIME_EXCEPTIONS) {
            uncheckedExceptions.remove(RUNTIME_EXCEPTION);
        }
        if (!settings.PHPDOC_THROWS_IGNORE_LOGIC_EXCEPTIONS) {
            uncheckedExceptions.remove(LOGIC_EXCEPTION);
        }
    }

    public void setUncheckedExceptions(@NotNull Set<String> uncheckedExceptions) {
        if (uncheckedExceptions == null) {
            PhpAnalysisConfiguration.$$$reportNull$$$0(5);
        }
        this.setOldUncheckedExceptions(uncheckedExceptions);
        this.getState().setUncheckedExceptions(uncheckedExceptions);
    }

    private void setOldUncheckedExceptions(@NotNull Set<String> uncheckedExceptions) {
        if (uncheckedExceptions == null) {
            PhpAnalysisConfiguration.$$$reportNull$$$0(6);
        }
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(PhpCodeStyleSettings.class);
        settings.PHPDOC_THROWS_IGNORE_RUNTIME_EXCEPTIONS = uncheckedExceptions.contains(RUNTIME_EXCEPTION);
        settings.PHPDOC_THROWS_IGNORE_LOGIC_EXCEPTIONS = uncheckedExceptions.contains(LOGIC_EXCEPTION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpAnalysisConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uncheckedExceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpAnalysisConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncheckedExceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUncheckedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setOldUncheckedExceptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        private int myCallTreeAnalysisDepth = 1;
        private Set<String> myUncheckedExceptions = ContainerUtil.newTroveSet((Object[])new String[]{"\\RuntimeException", "\\LogicException", "\\Error"});

        @Attribute(value="call_tree_analysis_depth")
        public int getCallTreeAnalysisDepth() {
            return this.myCallTreeAnalysisDepth;
        }

        public void setCallTreeAnalysisDepth(int callTreeAnalysisDepth) {
            this.myCallTreeAnalysisDepth = callTreeAnalysisDepth;
        }

        @XCollection(propertyElementName="unchecked_exceptions", elementName="fqn")
        @NotNull
        public Set<String> getUncheckedExceptions() {
            Set<String> set = this.myUncheckedExceptions;
            if (set == null) {
                State.$$$reportNull$$$0(0);
            }
            return set;
        }

        public void setUncheckedExceptions(@NotNull Set<String> uncheckedExceptions) {
            if (uncheckedExceptions == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myUncheckedExceptions = uncheckedExceptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/PhpAnalysisConfiguration$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uncheckedExceptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUncheckedExceptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/PhpAnalysisConfiguration$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setUncheckedExceptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

