/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.classAlias;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassAliasImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasToClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassToClassAliasIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassAliasIndexImpl
implements PhpClassAliasIndex {
    private final Project myProject;

    public PhpClassAliasIndexImpl(@NotNull Project project) {
        if (project == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Collection<String> getClassNames() {
        Collection<String> collection = this.getAliasNames(c -> !c.isInterface() && !c.isTrait());
        if (collection == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getInterfaceNames() {
        Collection<String> collection = this.getAliasNames(PhpClass::isInterface);
        if (collection == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getTraitNames() {
        Collection<String> collection = this.getAliasNames(PhpClass::isTrait);
        if (collection == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private Collection<String> getAliasNames(@Nullable Predicate<PhpClassAlias> filter) {
        Collection names = FileBasedIndex.getInstance().getAllKeys(PhpClassAliasNameIndex.KEY, this.myProject);
        if (!names.isEmpty()) {
            if (filter == null) {
                Collection collection = names;
                if (collection == null) {
                    PhpClassAliasIndexImpl.$$$reportNull$$$0(4);
                }
                return collection;
            }
            List classes = ContainerUtil.newSmartList();
            for (String name : names) {
                if (this.getAliasesByName(name, filter).isEmpty()) continue;
                classes.add(name);
            }
            List list = classes;
            if (list == null) {
                PhpClassAliasIndexImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Collection<PhpClassAlias> getClassesByName(@NotNull String name) {
        if (name == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(7);
        }
        Collection<PhpClassAlias> collection = this.getAliasesByName(name, c -> !c.isInterface() && !c.isTrait());
        if (collection == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClassAlias> getInterfacesByName(@NotNull String name) {
        if (name == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(9);
        }
        Collection<PhpClassAlias> collection = this.getAliasesByName(name, PhpClass::isInterface);
        if (collection == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClassAlias> getTraitsByName(@NotNull String name) {
        if (name == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(11);
        }
        Collection<PhpClassAlias> collection = this.getAliasesByName(name, PhpClass::isTrait);
        if (collection == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private Collection<PhpClassAlias> getAliasesByName(@NotNull String name, @Nullable Predicate<PhpClassAlias> filter) {
        if (name == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(13);
        }
        return this.getAliasesByName(name, filter, PhpIndex.getInstance((Project)this.myProject).getSearchScope());
    }

    @NotNull
    public Collection<PhpClassAlias> getAliasesByName(@NotNull String name, @Nullable Predicate<PhpClassAlias> filter, @NotNull GlobalSearchScope scope) {
        FileBasedIndex index;
        List values;
        if (name == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(15);
        }
        if (!(values = (index = FileBasedIndex.getInstance()).getValues(PhpClassAliasNameIndex.KEY, (Object)name.toLowerCase(), scope)).isEmpty()) {
            List classes = ContainerUtil.newSmartList();
            for (Set fqns : values) {
                for (String fqn : fqns) {
                    Collection files = index.getContainingFiles(PhpClassAliasToClassIndex.KEY, (Object)fqn.toLowerCase(), scope);
                    if (files.isEmpty()) continue;
                    FileBasedIndex.ValueProcessor collector = (file, location) -> {
                        Map<String, PhpClassAlias> cache = PhpCaches.getInstance((Project)this.myProject).classAliasCache;
                        String key = file.getPath() + ':' + location.offset + ':' + location.originalFqn;
                        classes.add(cache.computeIfAbsent(key, __ -> new PhpClassAliasImpl(fqn, location.originalFqn, this.myProject, file, (Lazy<? extends FunctionReference>)LazyKt.lazy(() -> {
                            PsiFile psi = PsiManager.getInstance((Project)this.myProject).findFile(file);
                            PsiElement child = psi != null ? psi.findElementAt(location.offset) : null;
                            return (FunctionReference)PhpPsiUtil.getParentByCondition(child, true, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                        }))));
                        return true;
                    };
                    for (VirtualFile file2 : files) {
                        index.processValues(PhpClassAliasToClassIndex.KEY, (Object)fqn.toLowerCase(), file2, collector, scope);
                    }
                }
            }
            List list = filter != null ? ((StreamEx)StreamEx.of((Collection)classes).filter(filter)).toList() : classes;
            if (list == null) {
                PhpClassAliasIndexImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<PhpClassAlias> list = Collections.emptyList();
        if (list == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public Collection<String> getClassFqnsByAlias(@NotNull String fqn) {
        if (fqn == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(18);
        }
        GlobalSearchScope scope = PhpIndex.getInstance((Project)this.myProject).getSearchScope();
        Set set = StreamEx.of((Collection)FileBasedIndex.getInstance().getValues(PhpClassAliasToClassIndex.KEY, (Object)fqn.toLowerCase(), scope)).map(location -> location.originalFqn).toSet();
        if (set == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    public Collection<String> getAliasFqnsByClass(@NotNull String fqn) {
        if (fqn == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(20);
        }
        GlobalSearchScope scope = PhpIndex.getInstance((Project)this.myProject).getSearchScope();
        List list = FileBasedIndex.getInstance().getValues(PhpClassToClassAliasIndex.KEY, (Object)fqn.toLowerCase(), scope);
        if (list == null) {
            PhpClassAliasIndexImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/classAlias/PhpClassAliasIndexImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/classAlias/PhpClassAliasIndexImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitNames";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfacesByName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitsByName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasesByName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqnsByAlias";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasFqnsByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInterfacesByName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTraitsByName";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAliasesByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqnsByAlias";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAliasFqnsByClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

