/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.phpdoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class PhpDocFormatPreprocessor
implements PreFormatProcessor {
    private static final Logger LOG = Logger.getInstance(PhpDocFormatPreprocessor.class);

    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psiElement;
        if (element == null) {
            PhpDocFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpDocFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpDocFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (!psiElement.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpDocFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange textRange = new PhpDocFormatter(psiElement).process(psiElement, range);
        if (textRange == null) {
            PhpDocFormatPreprocessor.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyChangeInfo {
        private final TextRange myOriginalRange;
        private final String myNewComment;

        private MyChangeInfo(TextRange originalRange, String newComment) {
            this.myOriginalRange = originalRange;
            this.myNewComment = newComment;
        }

        public TextRange getOriginalRange() {
            return this.myOriginalRange;
        }

        public String getNewComment() {
            return this.myNewComment;
        }
    }

    private static class PhpDocFormatter
    extends PhpElementVisitor {
        private final PhpCodeStyleSettings myPhpSettings;
        private final Project myProject;
        private TextRange myOrigRange;
        private TextRange myRange;
        private final Map<Integer, MyChangeInfo> myCollectedChanges;

        PhpDocFormatter(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocFormatter.$$$reportNull$$$0(0);
            }
            this.myCollectedChanges = new TreeMap<Integer, MyChangeInfo>();
            this.myProject = element.getProject();
            this.myPhpSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), PhpCodeStyleSettings.class);
        }

        public TextRange process(PsiElement element, TextRange range) {
            Document doc;
            PsiFile file = element.getContainingFile();
            this.myOrigRange = range;
            this.myRange = new TextRange(this.myOrigRange.getStartOffset(), this.myOrigRange.getEndOffset());
            element.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            Document document = doc = file.isPhysical() ? documentManager.getDocument(file) : file.getViewProvider().getDocument();
            if (doc != null) {
                int delta = this.doReplacements(doc);
                documentManager.commitDocument(doc);
                this.myRange = this.grown(delta);
            }
            return this.myRange;
        }

        public void visitElement(PsiElement element) {
            if (element instanceof PhpDocComment && (this.myOrigRange.contains(element.getTextRange()) || element.getTextRange().contains(this.myOrigRange))) {
                int originalLength = element.getTextRange().getLength();
                this.processDocComment((PhpDocComment)element);
                int delta = element.getTextRange().getLength() - originalLength;
                this.myRange = this.grown(delta);
            } else {
                element.acceptChildren((PsiElementVisitor)this);
            }
        }

        @NotNull
        private TextRange grown(int delta) {
            TextRange textRange = this.myRange.getLength() + delta > 0 ? this.myRange.grown(delta) : TextRange.from((int)this.myRange.getStartOffset(), (int)0);
            if (textRange == null) {
                PhpDocFormatter.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processDocComment(PhpDocComment docComment) {
            StringBuilder newCommentBuf = new StringBuilder();
            PsiElement child = docComment.getFirstChild();
            boolean beforeFirstTag = true;
            boolean isInParamTags = false;
            boolean blankLineExists = false;
            boolean isAtStart = false;
            while (child != null) {
                block26: {
                    String childText = child.getText();
                    if (PhpDocUtil.isSimpleTag(child)) {
                        if (!PhpDocFormatter.isInLineTag((PhpDocTag)child)) {
                            boolean isBlankLineNeeded = false;
                            if (this.myPhpSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS && beforeFirstTag) {
                                isBlankLineNeeded = true;
                            }
                            if (childText.startsWith("@param")) {
                                if (this.myPhpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS && !isInParamTags) {
                                    isBlankLineNeeded = true;
                                }
                                isInParamTags = true;
                            } else {
                                if (this.myPhpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS && isInParamTags) {
                                    isBlankLineNeeded = true;
                                }
                                isInParamTags = false;
                            }
                            if (isBlankLineNeeded && !blankLineExists && !isAtStart) {
                                Condition whiteSpaceBeforeAsteriskCondition = element -> element instanceof PsiWhiteSpace && PhpPsiUtil.isOfType(element.getNextSibling(), PhpDocTokenTypes.DOC_LEADING_ASTERISK);
                                Object prevSiblingByCondition = PhpPsiUtil.getPrevSiblingByCondition(child, (Condition<? super PsiElement>)whiteSpaceBeforeAsteriskCondition);
                                String whiteSpaceAlligned = prevSiblingByCondition != null ? prevSiblingByCondition.getText() : "\n";
                                int lastIndexOf = newCommentBuf.lastIndexOf("*");
                                if (lastIndexOf == -1) {
                                    newCommentBuf.append(whiteSpaceAlligned);
                                    newCommentBuf.append("*");
                                } else {
                                    newCommentBuf.insert(lastIndexOf, "*");
                                    newCommentBuf.insert(lastIndexOf + 1, whiteSpaceAlligned);
                                }
                            }
                            beforeFirstTag = false;
                            blankLineExists = false;
                        }
                        isAtStart = false;
                        newCommentBuf.append(childText);
                    } else if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_LEADING_ASTERISK)) {
                        PsiElement next = child.getNextSibling();
                        if (next instanceof PsiWhiteSpace && next.getNode().textContains('\n')) {
                            PsiElement afterWhitespace = next.getNextSibling();
                            if (afterWhitespace instanceof PsiWhiteSpace) {
                                afterWhitespace = afterWhitespace.getNextSibling();
                            }
                            boolean isAtEnd = PhpPsiUtil.isOfType(afterWhitespace, PhpDocTokenTypes.DOC_COMMENT_END);
                            if (this.myPhpSettings.PHPDOC_KEEP_BLANK_LINES || isAtStart && isAtEnd) {
                                newCommentBuf.append(childText).append(next.getText());
                                child = next;
                                blankLineExists = true;
                                break block26;
                            } else {
                                child = next.getNextSibling();
                                continue;
                            }
                        }
                        newCommentBuf.append(childText);
                    } else if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IGNORED)) {
                        this.prefixWithStar(newCommentBuf, child);
                    } else {
                        int lineBreaks;
                        if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_COMMENT_START)) {
                            isAtStart = true;
                        } else if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER)) {
                            isAtStart = false;
                            blankLineExists = false;
                        }
                        if (child instanceof PsiWhiteSpace && childText.contains("\n") && (lineBreaks = StringUtil.getLineBreakCount((CharSequence)childText)) > 1) {
                            childText = "\n ";
                        }
                        newCommentBuf.append(childText);
                    }
                }
                child = child.getNextSibling();
            }
            String newCommentText = newCommentBuf.toString();
            PhpDocComment newDocComment = PhpPsiElementFactory.createFromText(this.myProject, PhpDocComment.class, newCommentText);
            assert (newDocComment != null) : "Invalid doc comment: " + newCommentText;
            if (!newDocComment.getText().equals(docComment.getText())) {
                this.myCollectedChanges.put(new Integer(docComment.getTextOffset()), new MyChangeInfo(docComment.getTextRange(), newCommentText));
            }
        }

        private static boolean isInLineTag(PhpDocTag tag) {
            PsiElement prev = tag.getPrevSibling();
            if (PhpPsiUtil.isOfType(prev, PhpDocTokenTypes.DOC_TEXT)) {
                prev = prev.getPrevSibling();
            }
            return PhpPsiUtil.isOfType(prev, PhpDocTokenTypes.DOC_LBRACE);
        }

        private int doReplacements(Document doc) {
            int delta = 0;
            for (MyChangeInfo info : this.myCollectedChanges.values()) {
                int newDelta = delta + (info.getNewComment().length() - info.getOriginalRange().getLength());
                TextRange replaceRange = info.getOriginalRange().shiftRight(delta);
                doc.replaceString(replaceRange.getStartOffset(), replaceRange.getEndOffset(), (CharSequence)info.getNewComment());
                delta = newDelta;
            }
            return delta;
        }

        private static int lineFeedCount(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocFormatter.$$$reportNull$$$0(2);
            }
            return StringUtil.countChars((CharSequence)element.getNode().getChars(), (char)'\n');
        }

        private void prefixWithStar(StringBuilder builder, PsiElement currElement) {
            int lineFeeds;
            PsiElement prev = currElement.getPrevSibling();
            if (prev instanceof PsiWhiteSpace && (lineFeeds = PhpDocFormatter.lineFeedCount(prev)) > 0) {
                if (this.myPhpSettings.PHPDOC_KEEP_BLANK_LINES) {
                    for (int i = 0; i < lineFeeds - 1; ++i) {
                        builder.append("*\n");
                    }
                }
                builder.append("* ");
            }
            builder.append(currElement.getNode().getChars());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor$PhpDocFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/formatter/phpdoc/PhpDocFormatPreprocessor$PhpDocFormatter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "grown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lineFeedCount";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

