/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class PhpDuplicateCaseInspection
extends PhpInspection {
    private static final String DESCRIPTION_BATCH = "Duplicate case expression";
    private static final String DESCRIPTION = "Duplicate case expression: #ref";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateCaseInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                THashSet conditions = new THashSet();
                for (PhpCase phpCase : switchStatement.getAllCases()) {
                    String key;
                    PhpPsiElement condition = phpCase.getCondition();
                    if (condition == null || condition.getTextLength() <= 0 || conditions.add(key = PhpDuplicateCaseInspection.convertToString((PsiElement)condition))) continue;
                    holder.registerProblem((PsiElement)condition, isOnTheFly ? PhpDuplicateCaseInspection.DESCRIPTION : PhpDuplicateCaseInspection.DESCRIPTION_BATCH, new LocalQuickFix[0]);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpDuplicateCaseInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static String convertToString(@NotNull PsiElement element) {
        String unquotedString;
        if (element == null) {
            PhpDuplicateCaseInspection.$$$reportNull$$$0(2);
        }
        if (element instanceof StringLiteralExpression && (unquotedString = PhpCodeInsightUtil.toString(element)) != null) {
            try {
                Double.parseDouble(unquotedString);
                return unquotedString.trim();
            }
            catch (NumberFormatException e) {
                return "'" + unquotedString + "'";
            }
        }
        return element.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDuplicateCaseInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDuplicateCaseInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

