/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitUndefinedDataProviderInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpCreateDataProviderQuickFix()};
    private static final String DATA_PROVIDER_TAG = "@dataProvider";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                Object[] dataProvidersTags = PhpUnitUndefinedDataProviderInspection.getDataProvidersTags(method);
                if (ArrayUtil.isEmpty((Object[])dataProvidersTags)) {
                    return;
                }
                PhpClass containingClass = method.getContainingClass();
                if (containingClass == null || !PhpUnitUtil.isTestMethod(containingClass, method)) {
                    return;
                }
                for (Object dataProviderTag : dataProvidersTags) {
                    this.check((PhpDocRef)PsiTreeUtil.getChildOfType((PsiElement)dataProviderTag, PhpDocRef.class), containingClass);
                }
            }

            private void check(@Nullable PhpDocRef dataProvider, @NotNull PhpClass testClass) {
                if (testClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataProvider != null) {
                    Pair classAndMethod;
                    Pair<String, String> classFqnAndMethodName = PhpUnitUtil.getClassFqnAndMethodName(dataProvider, testClass.getNamespaceName());
                    String classFqn = (String)classFqnAndMethodName.getFirst();
                    String methodName = (String)classFqnAndMethodName.getSecond();
                    if (methodName != null && (classAndMethod = PhpUnitUndefinedDataProviderInspection.resolveClassAndMethod(classFqn, methodName, dataProvider, testClass)).getSecond() == null) {
                        LocalQuickFix[] fixes = isOnTheFly && PhpUnitUndefinedDataProviderInspection.getProviderTargetClass(dataProvider, (PhpClass)classAndMethod.getFirst(), classFqn) != null ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                        holder.registerProblem((PsiElement)dataProvider, PhpBundle.message("inspection.undefined.phpunit.provider", this.getPresentableName(classFqn, methodName)), fixes);
                    }
                }
            }

            @NotNull
            private String getPresentableName(@Nullable String classFqn, @NotNull String methodName) {
                if (methodName == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = classFqn != null ? PhpLangUtil.toPresentableFQN(classFqn) + "::" + methodName : methodName;
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "check";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableName";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (phpElementVisitor == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @NotNull
    private static Pair<PhpClass, Method> resolveClassAndMethod(@Nullable String classFqn, @NotNull String methodName, @NotNull PhpDocRef docRef, @NotNull PhpClass containingClass) {
        if (methodName == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(2);
        }
        if (docRef == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(4);
        }
        if (classFqn != null) {
            List classes = StreamEx.of((Object[])docRef.getReferences()).map(PsiReference::resolve).select(PhpClass.class).toList();
            PhpClass clazz = classes.size() == 1 ? (PhpClass)classes.get(0) : null;
            Pair pair = clazz != null && (PhpLangUtil.isFqn(docRef.getText()) || PhpLangUtil.equalsNamespaceNames(containingClass.getNamespaceName(), clazz.getNamespaceName())) ? Pair.create((Object)clazz, (Object)clazz.findMethodByName((CharSequence)methodName)) : Pair.empty();
            if (pair == null) {
                PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(5);
            }
            return pair;
        }
        Pair pair = Pair.create(null, (Object)containingClass.findMethodByName((CharSequence)methodName));
        if (pair == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @NotNull
    private static PhpDocTag[] getDataProvidersTags(@NotNull Method method) {
        if (method == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(7);
        }
        if (method instanceof PhpDocMethod) {
            if (PhpDocTag.EMPTY_ARRAY == null) {
                PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(8);
            }
            return PhpDocTag.EMPTY_ARRAY;
        }
        PhpDocComment docComment = method.getDocComment();
        PhpDocTag[] phpDocTagArray = docComment != null ? docComment.getTagElementsByName(DATA_PROVIDER_TAG) : PhpDocTag.EMPTY_ARRAY;
        if (phpDocTagArray == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(9);
        }
        return phpDocTagArray;
    }

    @Nullable
    private static PhpClass getProviderTargetClass(@NotNull PhpDocRef dataProvider, @Nullable PhpClass resolvedClass, @Nullable String classFqn) {
        if (dataProvider == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(10);
        }
        if (classFqn == null) {
            return (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)dataProvider, PhpClass.class);
        }
        return resolvedClass != null && !resolvedClass.isInterface() ? resolvedClass : null;
    }

    private static void focusOnMethod(@NotNull PsiElement method) {
        if (method == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(11);
        }
        Project project = method.getProject();
        PhpReturn phpReturn = (PhpReturn)PsiTreeUtil.findChildOfType((PsiElement)method, PhpReturn.class);
        PsiElement returnSemicolon = phpReturn != null ? PhpPsiUtil.getChildOfType((PsiElement)phpReturn, PhpTokenTypes.opSEMICOLON) : null;
        PhpCodeUtil.openRelatedFile(project, returnSemicolon != null ? returnSemicolon : method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClassAndMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProvidersTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassAndMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvidersTags";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProviderTargetClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "focusOnMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpCreateDataProviderQuickFix
    implements LocalQuickFix {
        private static final String PHPUNIT_DATA_PROVIDER_QUICK_TEMPLATE = "public function %NAME%() { return ; }";

        private PhpCreateDataProviderQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Create data provider" == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(0);
            }
            return "Create data provider";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpDocRef dataProvider;
            if (project == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(2);
            }
            if ((dataProvider = (PhpDocRef)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PhpDocRef.class)) != null) {
                PhpClass testClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)dataProvider, PhpClass.class);
                if (testClass == null) {
                    return;
                }
                Pair<String, String> classFqnAndMethodName = PhpUnitUtil.getClassFqnAndMethodName(dataProvider, testClass.getNamespaceName());
                Pair classAndMethod = PhpUnitUndefinedDataProviderInspection.resolveClassAndMethod((String)classFqnAndMethodName.getFirst(), (String)classFqnAndMethodName.getSecond(), dataProvider, testClass);
                if (classAndMethod.getSecond() != null) {
                    PhpUnitUndefinedDataProviderInspection.focusOnMethod((PsiElement)classAndMethod.getSecond());
                } else {
                    PsiElement createdMethod;
                    PhpClass providerTargetClass = PhpUnitUndefinedDataProviderInspection.getProviderTargetClass(dataProvider, (PhpClass)classAndMethod.getFirst(), (String)classFqnAndMethodName.getFirst());
                    if (providerTargetClass != null && (createdMethod = PhpCreateDataProviderQuickFix.createProviderMethod((String)classFqnAndMethodName.getSecond(), providerTargetClass)) != null) {
                        PhpUnitUndefinedDataProviderInspection.focusOnMethod(createdMethod);
                    }
                }
            }
        }

        @Nullable
        private static PsiElement createProviderMethod(@NotNull String methodName, @NotNull PhpClass clazz) {
            Method method;
            if (methodName == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(3);
            }
            if (clazz == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(4);
            }
            return (method = PhpCodeUtil.createMethodFromTemplate(clazz, clazz.getProject(), PHPUNIT_DATA_PROVIDER_QUICK_TEMPLATE.replace("%NAME%", methodName))) != null ? PhpCodeEditUtil.insertClassMember(clazz, (PsiElement)method) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection$PhpCreateDataProviderQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection$PhpCreateDataProviderQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createProviderMethod";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

