/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUnusedPrivateFieldInspection
extends PhpInspection {
    private static final String DESCRIPTION_TEMPLATE = "Unused private field #ref";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedPrivateFieldInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpField(Field field) {
                PsiElement namePsiElement = field.getNameIdentifier();
                if (namePsiElement == null) {
                    return;
                }
                if (field.getModifier().isPrivate() && !PhpUnusedPrivateFieldInspection.isFieldUsed(field)) {
                    holder.registerProblem(namePsiElement, PhpUnusedPrivateFieldInspection.DESCRIPTION_TEMPLATE, ProblemHighlightType.LIKE_UNUSED_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpUnusedPrivateFieldInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isFieldUsed(@NotNull Field field) {
        PhpClass containingClass;
        if (field == null) {
            PhpUnusedPrivateFieldInspection.$$$reportNull$$$0(2);
        }
        if ((containingClass = field.getContainingClass()) != null && !containingClass.isTrait() && !containingClass.hasTraitUses()) {
            final CharSequence fieldName = field.getNameCS();
            final boolean isConstant = field.isConstant();
            PhpInspection.PhpReferenceSearchVisitor visitor = new PhpInspection.PhpReferenceSearchVisitor(){

                public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                    if (isConstant && PhpLangUtil.equalsClassConstantNames(fieldName, constantReference.getNameCS())) {
                        this.foundRef.set((Object)true);
                    }
                }

                public void visitPhpFieldReference(FieldReference fieldReference) {
                    if (!isConstant && PhpLangUtil.equalsFieldNames(fieldName, fieldReference.getNameCS())) {
                        this.foundRef.set((Object)true);
                    }
                    super.visitPhpFieldReference(fieldReference);
                }
            };
            containingClass.accept((PsiElementVisitor)visitor);
            return visitor.isReferenceFound();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateFieldInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateFieldInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFieldUsed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

