/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.array;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.lang.intentions.array.OffsetPair;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PhpConvertArraySyntaxBase
extends PsiElementBaseIntentionAction {
    public static PsiElement changeSyntax(ArrayCreationExpression expression) {
        if (expression.isShortSyntax()) {
            PsiElement rightBracket = expression.getLastChild();
            PsiElement leftBracket = expression.getFirstChild();
            PsiElement arrayKw = PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.kwARRAY, "array");
            PsiElement lparen = PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chLPAREN, "(");
            PsiElement rparen = PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chRPAREN, ")");
            expression.addBefore(arrayKw, leftBracket);
            leftBracket.replace(lparen);
            rightBracket.replace(rparen);
        } else {
            PsiElement arrayKw = expression.getFirstChild();
            if (arrayKw != null) {
                PsiElement lParen = PhpPsiUtil.getNextSiblingIgnoreWhitespace(arrayKw, true);
                PsiElement rParen = expression.getLastChild();
                if (rParen != null && lParen != null) {
                    rParen.replace(PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chRBRACKET, "]"));
                    lParen.replace(PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chLBRACKET, "["));
                    arrayKw.delete();
                }
            }
        }
        return expression;
    }

    abstract boolean isAvailable(ArrayCreationExpression var1);

    public abstract int getLeftStartOffset(ArrayCreationExpression var1);

    public abstract int getRightStartOffset(ArrayCreationExpression var1);

    public abstract int getEndOffset(ArrayCreationExpression var1);

    public abstract String openStringToInsert();

    abstract String closeStringToInsert();

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(1);
        }
        this.invokeWithStrategy(project, element, true);
    }

    public void invokeWithStrategy(Project project, PsiElement element, boolean isRecursive) {
        ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)ArrayCreationExpression.INSTANCEOF);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(element.getContainingFile());
        if (arrayCreationExpression != null && this.isAvailable(arrayCreationExpression)) {
            if (isRecursive) {
                this.recursiveReplace(arrayCreationExpression);
            } else {
                this.singleReplace(document, documentManager, arrayCreationExpression);
            }
        }
    }

    private void recursiveReplace(ArrayCreationExpression arrayCreationExpression) {
        List<ArrayCreationExpression> aceList = this.collectAllNestedArrays(arrayCreationExpression);
        for (ArrayCreationExpression it : aceList) {
            PhpConvertArraySyntaxBase.changeSyntax(it);
        }
    }

    private List<ArrayCreationExpression> collectAllNestedArrays(ArrayCreationExpression arrayCreationExpression) {
        final ArrayList<ArrayCreationExpression> offsetPairs = new ArrayList<ArrayCreationExpression>();
        arrayCreationExpression.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                if (PhpConvertArraySyntaxBase.this.isAvailable(expression)) {
                    offsetPairs.add(expression);
                }
                super.visitPhpArrayCreationExpression(expression);
            }
        });
        return offsetPairs;
    }

    public void makeReplaces(Document document, List<OffsetPair> offsetPairs) {
        int sumOffset = 0;
        for (OffsetPair it : offsetPairs) {
            this.makeUncommittedReplace(document, it.myOffsetTriple.leftStartOffset - sumOffset, it.myOffsetTriple.rightStartOffset - sumOffset, it.myOffsetTriple.endOffset - sumOffset);
            sumOffset += it.myOffsetTriple.getCalculatedOffset(this);
        }
    }

    private void singleReplace(Document document, PsiDocumentManager documentManager, ArrayCreationExpression arrayCreationExpression) {
        int endOffset = this.getEndOffset(arrayCreationExpression);
        int leftStartOffset = this.getLeftStartOffset(arrayCreationExpression);
        int rightStartOffset = this.getRightStartOffset(arrayCreationExpression);
        if (document != null && this.makeUncommittedReplace(document, leftStartOffset, rightStartOffset, endOffset)) {
            documentManager.commitDocument(document);
        }
    }

    public boolean makeUncommittedReplace(Document document, int leftStartOffset, int rightStartOffset, int endOffset) {
        if (endOffset > -1 && leftStartOffset > -1 && rightStartOffset > -1 && document.getTextLength() >= endOffset && document.getTextLength() > rightStartOffset && document.getTextLength() >= leftStartOffset) {
            int totalOffset = rightStartOffset - leftStartOffset - this.openStringToInsert().length();
            document.replaceString(leftStartOffset, rightStartOffset, (CharSequence)this.openStringToInsert());
            document.replaceString(endOffset - totalOffset, endOffset - totalOffset + 1, (CharSequence)this.closeStringToInsert());
            return true;
        }
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        ArrayCreationExpression expression;
        if (project == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(3);
        }
        if ((expression = (ArrayCreationExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)ArrayCreationExpression.INSTANCEOF)) != null && this.isAvailable(expression)) {
            this.setText(this.getText());
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/array/PhpConvertArraySyntaxBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/array/PhpConvertArraySyntaxBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

