/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpExtractMethodCodeFragment
implements Segment {
    private final PsiFile myFile;
    private final PhpScopeHolder myScopeHolder;

    protected PhpExtractMethodCodeFragment(@NotNull PsiFile file, @NotNull PhpScopeHolder scopeHolder) {
        if (file == null) {
            PhpExtractMethodCodeFragment.$$$reportNull$$$0(0);
        }
        if (scopeHolder == null) {
            PhpExtractMethodCodeFragment.$$$reportNull$$$0(1);
        }
        this.myFile = file;
        this.myScopeHolder = scopeHolder;
    }

    @NotNull
    public final PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            PhpExtractMethodCodeFragment.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    public final PhpScopeHolder getScopeHolder() {
        PhpScopeHolder phpScopeHolder = this.myScopeHolder;
        if (phpScopeHolder == null) {
            PhpExtractMethodCodeFragment.$$$reportNull$$$0(3);
        }
        return phpScopeHolder;
    }

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public abstract String generateCodeText();

    @Nullable
    protected String validate() {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        if (startOffset < 0 || endOffset < startOffset) {
            return "Fail to calculate text range for extracted method: [" + startOffset + ", " + endOffset + "]";
        }
        int textLength = this.getFile().getTextLength();
        if (textLength < endOffset) {
            return "Fail to calculate text range for extracted method: [" + startOffset + ", " + endOffset + "], text length: " + textLength;
        }
        return null;
    }

    public final boolean contains(@NotNull TextRange textRange) {
        if (textRange == null) {
            PhpExtractMethodCodeFragment.$$$reportNull$$$0(4);
        }
        return textRange.getStartOffset() >= this.getStartOffset() && textRange.getEndOffset() <= this.getEndOffset();
    }

    @NotNull
    protected final String extractText() {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        PsiFile file = this.getFile();
        String string = file.getText().substring(startOffset, endOffset);
        if (string == null) {
            PhpExtractMethodCodeFragment.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodCodeFragment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodCodeFragment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

