/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueFileType;
import org.jetbrains.vuejs.inspections.WrapWithFunctionFix;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/vuejs/inspections/DataFunctionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isComponent", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "intellij.vuejs"})
public final class DataFunctionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return (PsiElementVisitor)new JSElementVisitor(this, holder){
            final /* synthetic */ DataFunctionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitJSProperty(@Nullable JSProperty node) {
                block10: {
                    block9: {
                        JSProperty jSProperty = node;
                        if (Intrinsics.areEqual((Object)"data", (Object)(jSProperty != null ? jSProperty.getName() : null)) ^ true) break block9;
                        JSProperty jSProperty2 = node;
                        if ((jSProperty2 != null ? jSProperty2.getValue() : null) instanceof JSFunction) break block9;
                        JSProperty jSProperty3 = node;
                        if (!((jSProperty3 != null ? jSProperty3.getValue() : null) instanceof JSReferenceExpression)) break block10;
                    }
                    return;
                }
                JSProperty jSProperty = node;
                if (jSProperty == null) {
                    Intrinsics.throwNpe();
                }
                if (this.this$0.isComponent(jSProperty)) {
                    LocalQuickFix[] localQuickFixArray;
                    if (node.getValue() instanceof JSObjectLiteralExpression) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        JSExpression jSExpression = node.getValue();
                        if (jSExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSExpression, (String)"node.value!!");
                        localQuickFixArray2[0] = (LocalQuickFix)new WrapWithFunctionFix((PsiElement)jSExpression);
                    } else {
                        localQuickFixArray = new LocalQuickFix[]{};
                    }
                    LocalQuickFix[] quickFixes = localQuickFixArray;
                    PsiElement psiElement = node.getNameIdentifier();
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$holder.registerProblem(psiElement, "Data property should be a function", Arrays.copyOf(quickFixes, quickFixes.length));
                }
            }

            public void visitJSFunctionProperty(@Nullable JSFunctionProperty functionProperty) {
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isComponent(@NotNull JSProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (!(property.getParent() instanceof JSObjectLiteralExpression)) return false;
        PsiElement psiElement = property.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"property.parent");
        if (!(psiElement.getParent() instanceof JSExportAssignment)) return false;
        PsiFile psiFile = property.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"property.containingFile");
        if (!Intrinsics.areEqual((Object)psiFile.getFileType(), (Object)((Object)VueFileType.Companion.getINSTANCE()))) return false;
        return true;
    }
}

