/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLCommenter;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public class HAMLCommentProvider
implements MultipleLangCommentProvider {
    @Nullable
    public Commenter getLineCommenter(PsiFile file, Editor editor, Language lineStartLanguage, Language lineEndLanguage) {
        Commenter hamlCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)HAMLLanguage.INSTANCE);
        if (lineStartLanguage != lineEndLanguage) {
            return hamlCommenter;
        }
        if (file.getTextLength() == 0) {
            return hamlCommenter;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null) {
            return hamlCommenter;
        }
        IElementType elementType = element.getNode().getElementType();
        String id = null;
        if (elementType == HAMLTokenTypes.INJECTION_CODE) {
            id = "ruby";
        } else if (elementType == HAMLTokenTypes.JAVASCRIPT_CODE) {
            id = "JavaScript";
        }
        if (id == null) {
            return hamlCommenter;
        }
        Language language = Language.findLanguageByID((String)id);
        if (language == null) {
            return hamlCommenter;
        }
        final Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter == null) {
            return hamlCommenter;
        }
        return new HAMLCommenter(){

            @Override
            public String getLineCommentPrefix() {
                return commenter.getLineCommentPrefix();
            }

            @Override
            public String getBlockCommentPrefix() {
                return commenter.getBlockCommentPrefix();
            }

            @Override
            public String getBlockCommentSuffix() {
                return commenter.getBlockCommentSuffix();
            }
        };
    }

    public boolean canProcess(PsiFile file, FileViewProvider viewProvider) {
        return viewProvider.getLanguages().contains((Object)HAMLLanguage.INSTANCE);
    }
}

