/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ParameterDef;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSeance;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;

public class CassandraIntermediateSession
extends JdbcIntermediateSession {
    CassandraIntermediateSession(@Nullable JdbcIntermediateFacade facade, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull Connection connection, boolean ownConnection) {
        super(facade, exceptionRecognizer, connection, ownConnection);
    }

    @Override
    @NotNull
    PreparedStatement prepareSimpleStatement(@NotNull String statementText) throws SQLException {
        return this.getConnection().prepareStatement(statementText);
    }

    @Override
    @NotNull
    public synchronized JdbcIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameterDefs) {
        if (outParameterDefs != null) {
            System.err.println("Parameters are not supported and will be ignored: " + Arrays.toString(outParameterDefs));
        }
        return super.openSeance(statementText, null);
    }

    @Override
    @NotNull
    CallableStatement prepareCallableStatement(@NotNull String statementText) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void performPing(Statement statement) throws SQLException {
        String pingQuery = "SELECT uuid() FROM system.local;";
        statement.execute("SELECT uuid() FROM system.local;");
    }
}

