/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.LocalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableComparator;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.AbstractSaxon9Frame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9TraceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Saxon9StyleFrame<N extends StyleElement>
extends AbstractSaxon9Frame<Debugger.StyleFrame, N>
implements Debugger.StyleFrame {
    private final XPathContext myXPathContext;
    private final StackFrame myStackFrame;

    protected Saxon9StyleFrame(Debugger.StyleFrame prev, N element, XPathContext xPathContext) {
        super(prev, element);
        this.myXPathContext = xPathContext;
        this.myStackFrame = this.myXPathContext.getStackFrame();
    }

    public String getInstruction() {
        return ((StyleElement)this.myElement).getDisplayName();
    }

    public Value eval(String expr) throws Debugger.EvaluationException {
        assert (this.isValid());
        Saxon9TraceListener.MUTED = true;
        try {
            Expression expression = ExpressionTool.make((String)expr, (StaticContext)new EvalContext((StyleElement)this.myElement), (Container)((Container)this.myElement), (int)0, (int)0, (int)0, (boolean)false);
            ExpressionVisitor visitor = ExpressionVisitor.make((StaticContext)((StyleElement)this.myElement).getStaticContext(), (Executable)expression.getExecutable());
            expression = expression.typeCheck(visitor, Type.ITEM_TYPE);
            int variables = this.myXPathContext.getStackFrame().getStackFrameMap().getNumberOfVariables();
            ExpressionTool.allocateSlots((Expression)expression, (int)variables, (SlotManager)((StyleElement)this.myElement).getContainingSlotManager());
            Value value = this.createValue(new ExpressionFacade(expression));
            return value;
        }
        catch (AssertionError e) {
            Saxon9StyleFrame.debug((Throwable)((Object)e));
            throw new Debugger.EvaluationException(((Throwable)((Object)e)).getMessage() != null ? ((Throwable)((Object)e)).getMessage() : ((Throwable)((Object)e)).toString());
        }
        catch (Exception e) {
            Saxon9StyleFrame.debug(e);
            throw new Debugger.EvaluationException(e.getMessage() != null ? e.getMessage() : e.toString());
        }
        finally {
            Saxon9TraceListener.MUTED = false;
        }
    }

    private Value createValue(ValueFacade expression) throws XPathException {
        TypeHierarchy typeHierarchy = this.myXPathContext.getConfiguration().getTypeHierarchy();
        ItemType itemType = expression.getItemType(typeHierarchy);
        SequenceIterator it = expression.iterate(this.myXPathContext);
        Item value = null;
        if (it.next() != null) {
            value = it.current();
        }
        if (it.next() == null) {
            return new SingleValue(value, itemType);
        }
        return new SequenceValue(value, it, itemType);
    }

    public List<Debugger.Variable> getVariables() {
        ArrayList<Debugger.Variable> variables;
        assert (this.isValid());
        Saxon9TraceListener.MUTED = true;
        try {
            variables = this.collectVariables();
        }
        finally {
            Saxon9TraceListener.MUTED = false;
        }
        Collections.sort(variables, VariableComparator.INSTANCE);
        return variables;
    }

    private ArrayList<Debugger.Variable> collectVariables() {
        ArrayList<Debugger.Variable> variables = new ArrayList<Debugger.Variable>();
        HashMap globalVariables = this.myXPathContext.getController().getExecutable().getCompiledGlobalVariables();
        if (globalVariables != null) {
            for (StructuredQName name : globalVariables.keySet()) {
                GlobalVariable globalVariable = (GlobalVariable)globalVariables.get(name);
                Value value = this.createVariableValue(new GlobalVariableFacade(globalVariable));
                int lineNumber = globalVariable.getLineNumber();
                String systemId = globalVariable.getSourceLocator().getSystemId();
                variables.add(new VariableImpl(globalVariable.getVariableQName().getDisplayName(), value, true, Debugger.Variable.Kind.VARIABLE, systemId, lineNumber));
            }
        }
        for (XPathContext context = this.myXPathContext; context != null; context = context.getCaller()) {
            StackFrame frame = context.getStackFrame();
            SlotManager map = frame.getStackFrameMap();
            ValueRepresentation[] values = frame.getStackFrameValues();
            int valuesLength = values.length;
            block2: for (int i = 0; i < valuesLength; ++i) {
                ValueRepresentation value = values[i];
                if (value == null) continue;
                String name = ((StructuredQName)map.getVariableMap().get(i)).getDisplayName();
                for (Debugger.Variable variable : variables) {
                    if (!name.equals(variable.getName())) continue;
                    continue block2;
                }
                Value localValue = this.createVariableValue(new LocalVariableFacade(value));
                variables.add(new VariableImpl(name, localValue, false, Debugger.Variable.Kind.VARIABLE, "", -1));
            }
        }
        return variables;
    }

    private Value createVariableValue(ValueFacade facade) {
        try {
            return this.createValue(facade);
        }
        catch (XPathException e) {
            return new ErrorValue(e.getMessage(), facade);
        }
    }

    private class ErrorValue
    implements Value {
        private final String myError;
        private final ValueFacade myFacade;

        ErrorValue(String error, ValueFacade facade) {
            this.myError = error;
            this.myFacade = facade;
        }

        public Object getValue() {
            return " - error: " + this.myError + " - ";
        }

        public Value.Type getType() {
            return new Value.ObjectType(this.myFacade.getItemType(Saxon9StyleFrame.this.myXPathContext.getConfiguration().getTypeHierarchy()).toString());
        }
    }

    private static class LocalVariableFacade
    implements ValueFacade {
        private final ValueRepresentation myValue;

        LocalVariableFacade(ValueRepresentation value) {
            this.myValue = value;
        }

        public ItemType getItemType(TypeHierarchy hierarchy) {
            if (this.myValue instanceof net.sf.saxon.value.Value) {
                return ((net.sf.saxon.value.Value)this.myValue).getItemType(hierarchy);
            }
            if (this.myValue instanceof Item) {
                return Type.getItemType((Item)((Item)this.myValue), (TypeHierarchy)hierarchy);
            }
            return AnyItemType.getInstance();
        }

        public SequenceIterator iterate(XPathContext context) throws XPathException {
            if (this.myValue instanceof net.sf.saxon.value.Value) {
                return ((net.sf.saxon.value.Value)this.myValue).iterate(context);
            }
            if (this.myValue instanceof Item) {
                return ((Item)this.myValue).getTypedValue();
            }
            return EmptyIterator.getInstance();
        }
    }

    private static class GlobalVariableFacade
    implements ValueFacade {
        private final GlobalVariable myVariable;

        GlobalVariableFacade(GlobalVariable variable) {
            this.myVariable = variable;
        }

        public ItemType getItemType(TypeHierarchy hierarchy) {
            return this.myVariable.getRequiredType().getPrimaryType();
        }

        public SequenceIterator iterate(XPathContext context) throws XPathException {
            SequenceIterator iterator = this.myVariable.iterate(context);
            if (iterator instanceof EmptyIterator) {
                ValueRepresentation value = this.myVariable.evaluateVariable(context);
                if (value instanceof Item) {
                    return SingletonIterator.makeIterator((Item)((Item)value));
                }
                if (value instanceof net.sf.saxon.value.Value) {
                    return ((net.sf.saxon.value.Value)value).iterate();
                }
                return iterator;
            }
            return iterator;
        }
    }

    private static class ExpressionFacade
    implements ValueFacade {
        private final Expression myExpression;

        ExpressionFacade(Expression expression) {
            this.myExpression = expression;
        }

        public ItemType getItemType(TypeHierarchy hierarchy) {
            return this.myExpression.getItemType(hierarchy);
        }

        public SequenceIterator iterate(XPathContext context) throws XPathException {
            return this.myExpression.iterate(context);
        }
    }

    private static interface ValueFacade {
        public ItemType getItemType(TypeHierarchy var1);

        public SequenceIterator iterate(XPathContext var1) throws XPathException;
    }

    private static class EvalContext
    extends ExpressionContext {
        private static Field myRedundant;
        private final StyleElement myElement;

        EvalContext(StyleElement element) {
            super(element);
            this.myElement = element;
        }

        public FunctionLibrary getFunctionLibrary() {
            return new FunctionLibraryWrapper(this.myElement);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Expression bindVariable(StructuredQName qName) throws XPathException {
            Object var;
            VariableReference expression;
            block5: {
                expression = (VariableReference)super.bindVariable(qName);
                XSLVariableDeclaration declaration = this.myElement.bindVariable(qName);
                Declaration decl = new Declaration((StylesheetModule)declaration.getPrincipalStylesheetModule(), this.myElement);
                Boolean prev = EvalContext.setRedundant(declaration, Boolean.FALSE);
                try {
                    if (declaration instanceof XSLVariable) {
                        XSLVariable variable = (XSLVariable)declaration;
                        var = declaration.isGlobal() ? (GlobalVariable)variable.compile(declaration.getExecutable(), decl) : (LocalVariable)variable.compileLocalVariable(declaration.getExecutable(), decl);
                        break block5;
                    }
                    if (declaration instanceof XSLParam) {
                        var = (GeneralVariable)declaration.compile(declaration.getExecutable(), decl);
                        break block5;
                    }
                    VariableReference variableReference = expression;
                    return variableReference;
                }
                finally {
                    EvalContext.setRedundant(declaration, prev);
                }
            }
            expression.fixup((Binding)var);
            return expression;
        }

        private static Boolean setRedundant(XSLVariableDeclaration variable, Boolean value) {
            if (myRedundant == null) {
                return null;
            }
            Object o = Boolean.FALSE;
            try {
                o = myRedundant.get(variable);
                myRedundant.set(variable, value);
            }
            catch (IllegalAccessException e) {
                Saxon9StyleFrame.debug(e);
            }
            return (Boolean)o;
        }

        static {
            try {
                myRedundant = XSLGeneralVariable.class.getDeclaredField("redundant");
                myRedundant.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                myRedundant = null;
            }
        }

        private static class FunctionLibraryWrapper
        implements FunctionLibrary {
            private static Method myGetFunction;
            private final FunctionLibrary myLibrary;
            private final PrincipalStylesheetModule myModule;

            FunctionLibraryWrapper(StyleElement element) {
                this.myLibrary = element.getStaticContext().getFunctionLibrary();
                this.myModule = element.getPrincipalStylesheetModule();
            }

            public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
                return this.myLibrary.getFunctionSignature(functionName, arity);
            }

            public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
                XSLFunction fn;
                Expression call = this.myLibrary.bind(functionName, staticArgs, env, container);
                if (call instanceof UserFunctionCall && (fn = this.getFunction(functionName, staticArgs)) != null) {
                    ((UserFunctionCall)call).setFunction(fn.getCompiledFunction());
                }
                return call;
            }

            private XSLFunction getFunction(StructuredQName functionName, Expression[] staticArgs) {
                if (myGetFunction == null) {
                    return null;
                }
                try {
                    return (XSLFunction)myGetFunction.invoke((Object)this.myModule, functionName, staticArgs.length);
                }
                catch (Exception e) {
                    Saxon9StyleFrame.debug(e);
                    return null;
                }
            }

            public FunctionLibrary copy() {
                return this;
            }

            static {
                try {
                    myGetFunction = PrincipalStylesheetModule.class.getDeclaredMethod("getFunction", StructuredQName.class, Integer.TYPE);
                    myGetFunction.setAccessible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    myGetFunction = null;
                }
            }
        }
    }

    private static class SequenceValue
    implements Value {
        private final String myValue;
        private final ItemType myItemType;

        SequenceValue(Item value, SequenceIterator it, ItemType type) throws XPathException {
            String s = "(" + value.getStringValue() + ", " + it.current().getStringValue();
            while (it.next() != null) {
                s = s + ", " + it.current().getStringValue();
            }
            this.myValue = s = s + ")";
            this.myItemType = type;
        }

        public Object getValue() {
            return this.myValue;
        }

        public Value.Type getType() {
            return new Value.ObjectType(this.myItemType.toString() + "+");
        }
    }

    private static class SingleValue
    implements Value {
        private final Item myValue;
        private final ItemType myItemType;

        SingleValue(Item value, ItemType itemType) {
            this.myValue = value;
            this.myItemType = itemType;
        }

        public Object getValue() {
            return this.myValue != null ? this.myValue.getStringValue() : null;
        }

        public Value.Type getType() {
            return new Value.ObjectType(this.myItemType.toString());
        }
    }
}

