/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.SliderSelectorAction;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreeType;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.CpuProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8SwitchViewActionsFactory;
import com.jetbrains.nodejs.run.profile.cpu.view.FilteredByPercent;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.SearchInV8TreeAction;
import com.jetbrains.nodejs.run.profile.cpu.view.StatisticsTreeTableWithDetails;
import com.jetbrains.nodejs.run.profile.cpu.view.V8CpuNavigationAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8NavigateToFlameChartIntervalAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import com.jetbrains.nodejs.run.profile.cpu.view.V8TreeTableModel;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8ProfilingCallTreeComponent
implements CpuProfilingView {
    public static final Convertor<TreePath, String> TREE_PATH_V8_LINE_CONVERTOR = path -> {
        Object o = path.getLastPathComponent();
        if (o instanceof V8ProfileLine) {
            return ((V8ProfileLine)o).getPresentation(false);
        }
        return o.toString();
    };
    @NonNls
    public static final String TOP_DOWN = "Top-down";
    @NonNls
    public static final String BOTTOM_UP = "Bottom-up";
    private String myErrorText;
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8LogCachingReader myReader;
    private final Consumer<String> myNotificator;
    @Nullable
    private final V8ProfileLine myRoot;
    @NotNull
    private final CallTreeType myCallTreeType;
    private final Disposable myDisposable;
    private V8ProfilingCallTreeTable myTable;
    private StatisticsTreeTableWithDetails myMasterDetails;
    private final String myPercentFilterName;
    private Factory<SearchInV8TreeAction.Searcher> myFactory;
    private V8SwitchViewActionsFactory myActionsFactory;
    private static final int[] FILTER_VALUES = new int[]{1, 2, 5, 7, 10, 15, 20, 30};

    public V8ProfilingCallTreeComponent(@NotNull Project project, @NotNull V8LogCachingReader reader, @NotNull CallTreeType callTreeType, @NotNull LineColorProvider fileColors, Disposable disposable, Consumer<String> notificator) {
        if (project == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(1);
        }
        if (callTreeType == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(2);
        }
        if (fileColors == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myReader = reader;
        this.myNotificator = notificator;
        this.myRoot = CallTreeType.bottomUp.equals((Object)callTreeType) ? reader.getBottomUp() : reader.getTopDown();
        this.myCallTreeType = callTreeType;
        this.myDisposable = disposable;
        this.myPercentFilterName = CallTreeType.topDown.equals((Object)this.myCallTreeType) ? "Total % Filter" : "Parent % Filter";
        this.createMainComponent(fileColors);
    }

    @Override
    public JComponent getMainComponent() {
        return this.myMasterDetails.getComponent();
    }

    @Override
    public String getName() {
        return CallTreeType.topDown.equals((Object)this.myCallTreeType) ? TOP_DOWN : BOTTOM_UP;
    }

    @Override
    public void registerItself(V8SwitchViewActionsFactory factory) {
        this.myActionsFactory = factory;
        if (CallTreeType.bottomUp.equals((Object)this.myCallTreeType)) {
            this.myActionsFactory.setBottomUp(this);
        } else {
            this.myActionsFactory.setTopDown(this);
        }
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        if (this.myErrorText != null) {
            return;
        }
        group.add(V8ProfilingCallTreeComponent.createEditSourceAction((JComponent)((Object)this.myTable)));
        group.add((AnAction)V8ProfilingCallTreeComponent.createFilterAction(this.myTable, this.myPercentFilterName, () -> this.autoExpand(), null));
        group.add((AnAction)new SearchInV8TreeAction(this.myProject, this.myMasterDetails, this.myReader, this.getSearcherFactory()));
        V8CpuNavigationAction navigationAction = new V8CpuNavigationAction();
        group.add((AnAction)navigationAction);
        if (CallTreeType.bottomUp.equals((Object)this.myCallTreeType)) {
            navigationAction.getGroup().add((AnAction)this.myActionsFactory.getToTopDown());
        } else {
            navigationAction.getGroup().add((AnAction)this.myActionsFactory.getToBottomUp());
        }
        navigationAction.getGroup().add((AnAction)this.myActionsFactory.getToTopCalls());
        V8NavigateToFlameChartIntervalAction.addToGroup(navigationAction.getGroup(), this.myReader, this.myNotificator);
    }

    @Override
    public StatisticsTreeTableWithDetails getMasterDetails() {
        return this.myMasterDetails;
    }

    @Override
    public Factory<SearchInV8TreeAction.Searcher> getSearcherFactory() {
        if (this.myFactory != null) {
            return this.myFactory;
        }
        this.myFactory = () -> new SearchInV8TreeAction.Searcher(){
            private final MultiMap myMap = new MultiMap();
            private final List myCalls = new ArrayList();
            private final List myNumbers = new ArrayList();

            @Override
            public boolean search(@NotNull String text, boolean caseSensitive) {
                List<V8ProfileLine> lines;
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((lines = ((V8TreeTableModel)V8ProfilingCallTreeComponent.this.myTable.getTableModel()).search(text.trim(), false)).isEmpty()) {
                    return false;
                }
                for (V8ProfileLine line : lines) {
                    String key2 = line.getPresentation(false);
                    this.myMap.putValue((Object)key2, (Object)line);
                }
                this.myCalls.addAll(ContainerUtil.map((Collection)this.myMap.keySet(), key -> ((V8ProfileLine)this.myMap.get(key).iterator().next()).getCall()));
                Collections.sort(this.myCalls, (o1, o2) -> o1.getPresentation(false).compareTo(o2.getPresentation(false)));
                for (V8CpuLogCall call : this.myCalls) {
                    this.myNumbers.add(Long.valueOf(this.myMap.get((Object)call.getPresentation(false)).size()));
                }
                return true;
            }

            @Override
            public List<V8CpuLogCall> getUniqueCalls() {
                return this.myCalls;
            }

            @Override
            public List<Long> getNumbersOfCalls() {
                return this.myNumbers;
            }

            @Override
            public List<TreePath> getPathsToExpand(@NotNull V8CpuLogCall call) {
                if (call == null) {
                    1.$$$reportNull$$$0(1);
                }
                Collection lines = this.myMap.get((Object)call.getPresentation(false));
                ArrayList<TreePath> paths = new ArrayList<TreePath>();
                V8TreeTableModel model = (V8TreeTableModel)V8ProfilingCallTreeComponent.this.myTable.getTableModel();
                for (V8ProfileLine line : lines) {
                    List<Long> ids = this.getStackIds(line);
                    TreePath path = model.createSelectionPathForStackTrace(ids);
                    paths.add(path);
                }
                return paths;
            }

            private List<Long> getStackIds(@NotNull V8ProfileLine line) {
                if (line == null) {
                    1.$$$reportNull$$$0(2);
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (V8ProfileLine current = line; current != null && current.getCall().getStringId() != -1L; current = current.getParent()) {
                    ids.add(current.getCall().getStringId());
                }
                Collections.reverse(ids);
                return ids;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "line";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfilingCallTreeComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "search";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getPathsToExpand";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getStackIds";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return this.myFactory;
    }

    @Override
    public V8ProfilingCallTreeTable getTreeTable() {
        return this.myTable;
    }

    @Override
    public void defaultExpand() {
        this.autoExpand();
    }

    @Override
    public String getError() {
        return this.myErrorText;
    }

    private void createMainComponent(@NotNull LineColorProvider fileColors) {
        if (fileColors == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(4);
        }
        if (this.myRoot == null) {
            this.myErrorText = "Fragment not found.";
            return;
        }
        V8TreeTableModel model = new V8TreeTableModel(this.myRoot, this.myCallTreeType, fileColors);
        model.filterByLevel(10);
        this.myTable = new V8ProfilingCallTreeTable(this.myProject, model, this.myDisposable);
        V8ProfilingCallTreeComponent.adjustTable(this.myTable, () -> this.defaultExpand());
        TreeTableWidthController controller = new TreeTableWidthController(this.myTable, this.myDisposable);
        controller.setMeaningfulRenderer((TreeCellRenderer)((Object)model.getZeroCellRenderer()));
        this.myTable.setController(controller);
        this.myMasterDetails = new StatisticsTreeTableWithDetails(this.myProject, this.myTable, TREE_PATH_V8_LINE_CONVERTOR, this.myDisposable);
    }

    static AnAction createEditSourceAction(JComponent component) {
        return new V8Utils.LightweightEditSourceAction(component);
    }

    public static SliderSelectorAction createFilterAction(@NotNull V8ProfilingCallTreeTable table, @NotNull String actionName, @NotNull Runnable myAutoExpander, Runnable afterCorrection) {
        if (table == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(5);
        }
        if (actionName == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(6);
        }
        if (myAutoExpander == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(7);
        }
        Hashtable<Integer, String> dictionary = new Hashtable<Integer, String>();
        dictionary.put(1, "no");
        final BidirectionalMap numberToPercent = new BidirectionalMap();
        int cnt = 2;
        for (int value : FILTER_VALUES) {
            numberToPercent.put((Object)cnt++, (Object)value);
        }
        Object object = numberToPercent.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            dictionary.put((Integer)entry.getKey(), entry.getValue() + "%");
        }
        final FilteredByPercent model = (FilteredByPercent)table.getTableModel();
        Consumer consumer = integer -> {
            if (table == null) {
                V8ProfilingCallTreeComponent.$$$reportNull$$$0(14);
            }
            if (myAutoExpander == null) {
                V8ProfilingCallTreeComponent.$$$reportNull$$$0(15);
            }
            if (1 == integer) {
                if (!model.isFiltered()) {
                    return;
                }
                model.clearFilter();
            } else {
                int level = (Integer)numberToPercent.get(integer) * 10;
                if (model.getTensPercentLevelInclusive() == level) {
                    return;
                }
                model.filterByLevel(level);
            }
            V8ProfilingCallTreeComponent.resetDataToTable(table, myAutoExpander, afterCorrection);
        };
        SliderSelectorAction.Configuration configuration = new SliderSelectorAction.Configuration(1, dictionary, actionName + ": ", consumer){

            public int getSelected() {
                int current = model.getTensPercentLevelInclusive();
                if (current == 0) {
                    return 1;
                }
                List value = numberToPercent.getKeysByValue((Object)(current / 10));
                if (value != null && value.size() == 1) {
                    return (Integer)value.get(0);
                }
                return 1;
            }

            public String getTooltip() {
                int current = model.getTensPercentLevelInclusive();
                if (current == 0) {
                    return "no";
                }
                return current / 10 + "%";
            }
        };
        configuration.setShowOk(true);
        return new SliderSelectorAction(actionName, actionName, AllIcons.General.Filter, configuration){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(!"V8_CPU_PROFILING_POPUP".equals(e.getPlace()));
            }

            protected void show(AnActionEvent e, JPanel result, JBPopup popup, InputEvent inputEvent) {
                InputEvent event = e.getInputEvent();
                if (event instanceof MouseEvent) {
                    popup.show(new RelativePoint((MouseEvent)event));
                } else {
                    popup.showInBestPositionFor(e.getDataContext());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfilingCallTreeComponent$3", "update"));
            }
        };
    }

    protected static void resetDataToTable(@NotNull V8ProfilingCallTreeTable table, @NotNull Runnable myAutoExpander, Runnable afterCorrection) {
        if (table == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(8);
        }
        if (myAutoExpander == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(9);
        }
        table.setModel(table.getTableModel());
        table.revalidate();
        table.repaint();
        V8ProfilingCallTreeComponent.adjustTable(table, myAutoExpander);
        if (afterCorrection != null) {
            afterCorrection.run();
        }
    }

    public static void adjustTable(V8ProfilingCallTreeTable table, @NotNull Runnable defaultExpand) {
        if (defaultExpand == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(10);
        }
        table.setAutoResizeMode(0);
        table.getTableHeader().setResizingAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRootVisible(false);
        table.getTree().setShowsRootHandles(true);
        table.getTree().setLineStyleAngled();
        defaultExpand.run();
        V8Utils.adjustColumnWIdths(table, null);
        if (table.getWidthController() != null) {
            table.getWidthController().installListener();
        }
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)this.myTable.getTree());
        if (this.myTable.getSelectedRowCount() == 0 && !this.myTable.isEmpty()) {
            this.myTable.getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    private void autoExpand() {
        new ConditionalExpander(this.myTable){
            private final PairConsumer<TreePath, V8ProfileLine> mostInterestingSelector;
            {
                this.mostInterestingSelector = CallTreeType.topDown.equals((Object)V8ProfilingCallTreeComponent.this.myCallTreeType) ? new PairConsumer<TreePath, V8ProfileLine>(){
                    int biggestSelfPercent = 0;

                    public void consume(TreePath path, V8ProfileLine line) {
                        if (line.getSelfTensPercent() > this.biggestSelfPercent) {
                            myPathToSelect = path;
                            this.biggestSelfPercent = line.getSelfTensPercent();
                        }
                    }
                } : new PairConsumer<TreePath, V8ProfileLine>(){
                    int ticks = 0;

                    public void consume(TreePath path, V8ProfileLine line) {
                        if (myTable.getTableModel().getRoot().equals(line.getParent()) && line.getTotalTicks() > this.ticks) {
                            myPathToSelect = path;
                            this.ticks = line.getTotalTicks();
                        }
                    }
                };
            }

            @Override
            protected boolean toExpand(TreePath path) {
                V8ProfileLine line;
                Object o = path.getLastPathComponent();
                if (o instanceof V8ProfileLine && ((line = (V8ProfileLine)o).getTotalTensPercent() >= 100 || line.getSelfTensPercent() >= 100)) {
                    this.mostInterestingSelector.consume((Object)path, (Object)line);
                    return true;
                }
                return false;
            }
        }.execute();
    }

    public boolean navigateByStackTrace(@NotNull List<Long> stackIds) {
        TreePath path;
        if (stackIds == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(11);
        }
        if ((path = ((V8TreeTableModel)this.myTable.getTableModel()).createSelectionPathForStackTrace(stackIds)) == null) {
            return false;
        }
        V8ProfilingCallTreeComponent.navigateToTreePath(this.myTable, path);
        return true;
    }

    private static void navigateToTreePath(V8ProfilingCallTreeTable treeTable, TreePath path) {
        Enumeration descendants = treeTable.getTree().getExpandedDescendants(new TreePath(new Object[]{treeTable.getTableModel().getRoot()}));
        V8ProfilingCallTreeComponent.resetDataToTable(treeTable, () -> {
            treeTable.revalidate();
            treeTable.repaint();
            treeTable.getTree().expandPath(path.getParentPath());
            if (descendants != null) {
                while (descendants.hasMoreElements()) {
                    TreePath treePath = (TreePath)descendants.nextElement();
                    List ids = ContainerUtil.map(Arrays.asList(treePath.getPath()), o -> o instanceof V8ProfileLine ? Long.valueOf(((V8ProfileLine)o).getCall().getStringId()) : null);
                    TreePath path1 = ((V8TreeTableModel)treeTable.getTableModel()).createSelectionPathForStackTrace(ids.subList(1, ids.size()));
                    if (path1 == null) continue;
                    treeTable.getTree().expandPath(path1);
                }
            }
        }, () -> {
            int row = treeTable.getTree().getRowForPath(path);
            if (row >= 0) {
                treeTable.clearSelection();
                treeTable.addRowSelectionInterval(row, row);
                V8ProfilingCallTreeComponent.scrollToSelectedRow(treeTable);
            } else {
                treeTable.getTree().setSelectionPath(path);
                treeTable.getTree().scrollPathToVisible(path);
            }
        });
    }

    public static void scrollToSelectedRow(@NotNull TreeTable table) {
        if (table == null) {
            V8ProfilingCallTreeComponent.$$$reportNull$$$0(12);
        }
        SwingUtilities.invokeLater(() -> {
            int row;
            if (table == null) {
                V8ProfilingCallTreeComponent.$$$reportNull$$$0(13);
            }
            if ((row = table.getSelectedRow()) >= 0) {
                int rowCount = table.getRowCount();
                int scrollRowBelow = row + Math.min(rowCount - 1 - row, 2);
                int scrollRowAbove = row - Math.min(2, row);
                Rectangle below = table.getCellRect(scrollRowBelow, 0, true);
                Rectangle above = table.getCellRect(scrollRowAbove, 0, true);
                table.scrollRectToVisible(new Rectangle(above.x, above.y, below.width, above.x - below.x + below.height));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTreeType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileColors";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myAutoExpander";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExpand";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackIds";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfilingCallTreeComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilterAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "resetDataToTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustTable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateByStackTrace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollToSelectedRow";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$scrollToSelectedRow$8";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createFilterAction$4";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class ConditionalExpander {
        protected final TreeTable myTable;
        private final ArrayDeque<TreePath> myQueue;
        protected TreePath myPathToSelect;

        public ConditionalExpander(TreeTable table) {
            this.myTable = table;
            this.myQueue = new ArrayDeque();
        }

        public void execute() {
            if (!this.collectInitialLines()) {
                return;
            }
            TreeTableTree tree = this.myTable.getTree();
            TreeTableModel model = this.myTable.getTableModel();
            while (!this.myQueue.isEmpty()) {
                TreePath path = this.myQueue.removeFirst();
                if (!this.toExpand(path)) continue;
                tree.expandPath(path);
                Object component = path.getLastPathComponent();
                int count = model.getChildCount(component);
                for (int i = 0; i < count; ++i) {
                    this.myQueue.add(path.pathByAddingChild(model.getChild(component, i)));
                }
            }
            if (this.myPathToSelect != null) {
                this.myTable.clearSelection();
                int rowForPath = tree.getRowForPath(this.myPathToSelect);
                if (rowForPath >= 0) {
                    this.myTable.addRowSelectionInterval(rowForPath, rowForPath);
                }
                V8ProfilingCallTreeComponent.scrollToSelectedRow(this.myTable);
            }
        }

        protected abstract boolean toExpand(TreePath var1);

        private boolean collectInitialLines() {
            TreeTableTree tree = this.myTable.getTree();
            int count = tree.getRowCount();
            if (count == 0) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                TreePath path = tree.getPathForRow(i);
                this.myQueue.add(path);
            }
            return true;
        }
    }
}

