/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.data;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum V8HeapGraphEdgeType {
    kContextVariable(0, "context variable", "A variable from a function context"),
    kElement(1, "element", "An element of an array"),
    kProperty(2, "property", "A named object property"),
    kInternal(3, "internal", "A link that can't be accessed from JS, thus, its name isn't a real property name (e.g. parts of a ConsString)"),
    kHidden(4, "hidden", "A link that is needed for proper sizes calculation, but may be hidden from user"),
    kShortcut(5, "shortcut", "A link that must not be followed during sizes calculation"),
    kWeak(6, "weak", "A weak reference (ignored by the GC)"),
    kInvisible(7, "invisible", "Invisible");

    private final int myNumber;
    private final String myName;
    private final String myDescription;

    private V8HeapGraphEdgeType(int number, String name, String description) {
        this.myNumber = number;
        this.myName = name;
        this.myDescription = description;
        Inner.ourMap.put(number, this);
    }

    @Nullable
    public static V8HeapGraphEdgeType getByNumber(int number) {
        return (V8HeapGraphEdgeType)((Object)Inner.ourMap.get(number));
    }

    public int getNumber() {
        return this.myNumber;
    }

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public static boolean isInternalKind(V8HeapGraphEdgeType type) {
        return kHidden.equals((Object)type) || kInvisible.equals((Object)type) || kInternal.equals((Object)type) || kWeak.equals((Object)type);
    }

    private static class Inner {
        private static final Map<Integer, V8HeapGraphEdgeType> ourMap = new HashMap<Integer, V8HeapGraphEdgeType>();

        private Inner() {
        }
    }
}

