/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.StatefulMappingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingIterator<F extends Item, T extends Item>
implements SequenceIterator<T> {
    private SequenceIterator<F> base;
    private MappingFunction<F, T> action;
    private SequenceIterator<? extends T> results = null;
    private T current = null;
    private int position = 0;

    public MappingIterator(SequenceIterator<F> base, MappingFunction<F, T> action) {
        this.base = base;
        this.action = action;
    }

    @Override
    public T next() throws XPathException {
        T nextItem;
        block3: {
            while (true) {
                F nextSource;
                if (this.results != null) {
                    nextItem = this.results.next();
                    if (nextItem != null) break block3;
                    this.results = null;
                }
                if ((nextSource = this.base.next()) == null) break;
                SequenceIterator<T> obj = this.action.map(nextSource);
                if (obj == null) continue;
                this.results = obj;
                nextItem = this.results.next();
                if (nextItem == null) {
                    this.results = null;
                    continue;
                }
                break block3;
                break;
            }
            this.results = null;
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = nextItem;
        ++this.position;
        return nextItem;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        if (this.results != null) {
            this.results.close();
        }
        this.base.close();
    }

    @Override
    public SequenceIterator<T> getAnother() throws XPathException {
        SequenceIterator<F> newBase = this.base.getAnother();
        MappingFunction newAction = this.action instanceof StatefulMappingFunction ? (MappingFunction)((Object)((StatefulMappingFunction)((Object)this.action)).getAnother()) : this.action;
        return new MappingIterator<F, T>(newBase, newAction);
    }

    @Override
    public int getProperties() {
        return 0;
    }
}

