/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultDropDialog;

public class DropViewCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(DropViewCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropViewCommand.class);
    protected DefaultDropDialog customDialog;

    public DropViewCommand(ISession session, IDatabaseObjectInfo[] dbInfo) {
        super(session, dbInfo);
    }

    @Override
    protected void onExecute() {
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (IDatabaseObjectInfo dbo : this._info) {
                result.add(this._dialect.getDropViewSQL(dbo.getSimpleName(), this.customDialog.isCascadeSelected(), new DatabaseObjectQualifier(dbo.getCatalogName(), dbo.getSchemaName()), this._sqlPrefs) + "\n");
            }
        }
        catch (UnsupportedOperationException e2) {
            this._session.showMessage(s_stringMgr.getString("DropViewCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result.toArray(new String[0]);
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropViewCommand.this.customDialog.setVisible(false);
                        DropViewCommand.this.customDialog.dispose();
                        DropViewCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        return dialect.supportsDropView();
    }

    private void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropViewCommand.this.customDialog = new DefaultDropDialog(DropViewCommand.this._info, 1, SessionUtils.getOwningFrame((ISession)DropViewCommand.this._session));
                        DropViewCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        DropViewCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(DropViewCommand.this.customDialog));
                        DropViewCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, DropViewCommand.this.customDialog));
                        DropViewCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)DropViewCommand.this._session));
                        DropViewCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = DropViewCommand.access$000().getString("DropViewCommand.sqlDialogTitle");
    }
}

