/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableQualifier;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.TableToAddWrapper;
import net.sourceforge.squirrel_sql.plugins.graph.TableToGraph;

public class AddTableAtQursorToGraph
extends SquirrelAction
implements ISQLPanelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddTableAtQursorToGraph.class);
    private ISQLPanelAPI _panel;
    private GraphPlugin _plugin;

    public AddTableAtQursorToGraph(IApplication app, PluginResources resources, GraphPlugin plugin) {
        super(app, (IResources)resources);
        this._plugin = plugin;
    }

    public void setSQLPanel(ISQLPanelAPI panel) {
        this._panel = panel;
        this.setEnabled(null != this._panel && this._panel.isInMainSessionWindow());
    }

    public synchronized void actionPerformed(ActionEvent evt) {
        if (this._panel == null) {
            return;
        }
        String stringAtCursor = this._panel.getSQLEntryPanel().getWordAtCursor();
        TableQualifier tq = new TableQualifier(stringAtCursor);
        ITableInfo[] tableInfos = this._panel.getSession().getSchemaInfo().getITableInfos(tq.getCatalog(), tq.getSchema(), tq.getTableName());
        if (0 == tableInfos.length) {
            JOptionPane.showMessageDialog(this._panel.getSQLEntryPanel().getTextComponent(), s_stringMgr.getString("graph.AddTableAtQursorToGraph.noTable", new Object[]{stringAtCursor}));
        }
        TableToGraph.sendToGraph(this._plugin, this._panel.getSession(), new TableToAddWrapper(tableInfos[0]));
    }
}

