/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.type;

import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaType {
    protected final Class<?> _class;
    protected int _hashCode;

    protected JavaType(Class<?> clazz) {
        this._class = clazz;
        String string = clazz.getName();
        this._hashCode = string.hashCode();
    }

    public final JavaType narrowBy(Class<?> clazz) {
        if (clazz == this._class) {
            return this;
        }
        this._assertSubclass(clazz, this._class);
        return this._narrow(clazz);
    }

    public final JavaType widenBy(Class<?> clazz) {
        if (clazz == this._class) {
            return this;
        }
        this._assertSubclass(this._class, clazz);
        return this._widen(clazz);
    }

    protected abstract JavaType _narrow(Class<?> var1);

    protected JavaType _widen(Class<?> clazz) {
        return this._narrow(clazz);
    }

    public abstract JavaType narrowContentsBy(Class<?> var1);

    public final Class<?> getRawClass() {
        return this._class;
    }

    public final boolean hasRawClass(Class<?> clazz) {
        return this._class == clazz;
    }

    public abstract boolean isFullyTyped();

    public abstract boolean isContainerType();

    public final boolean isAbstract() {
        return Modifier.isAbstract(this._class.getModifiers());
    }

    public final boolean isArrayType() {
        return this._class.isArray();
    }

    public final boolean isEnumType() {
        return this._class.isEnum();
    }

    public final boolean isInterface() {
        return this._class.isInterface();
    }

    public final boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    public JavaType findVariableType(String string) {
        return null;
    }

    protected void _assertSubclass(Class<?> clazz, Class<?> clazz2) {
        if (!this._class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not assignable to " + this._class.getName());
        }
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        return this._hashCode;
    }
}

