/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmpipe.h,v 1.5 2004/02/23 03:04:29 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.5 $
 * $Log: rmpipe.h,v $
 * Revision 1.5  2004/02/23 03:04:29  wes
 * New primitives: RM_QUAD_STRIP, RM_INDEXED_TRIANGLES, RM_INDEXED_QUADS,
 * RM_INDEXED_TRIANGLE_STRIP.
 *
 * Revision 1.4  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.3  2003/12/01 02:13:37  wes
 * Additions to support constate-rate rendering on Unix and Win32.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.11  2003/01/27 05:04:27  wes
 * Changes to RMpipe API and initialization sequence to unify GLX, WGL and CR
 * platforms w/o too much disruption to existing apps.
 *
 * Revision 1.10  2003/01/11 18:43:28  wes
 * Added global control over display list use at the RMpipe level with
 * new routines rmPipeSetDisplayListEnable() and rmPipeGetDisplayListEnable().
 *
 * Revision 1.9  2002/12/31 00:56:21  wes
 * Cleaned up arch-specific portions of RMpipe to support Chromium.
 *
 * Revision 1.8  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.7  2001/06/03 20:55:24  wes
 * Added declaration for rmPipeProcessingModeIsMultithreaded().
 *
 * Revision 1.6  2001/03/31 17:13:59  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.5  2000/08/28 01:33:19  wes
 * Removed unused code.
 *
 * Revision 1.4  2000/05/14 23:36:12  wes
 * Added attrib to RMpipe to allow control over how the OpenGL
 * matrix stack is initialized during rendering.
 *
 * Revision 1.3  2000/04/20 17:41:46  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:23  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmpipe_h
#define _rmpipe_h

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Since the contents of the RMpipe are specific to the window
 * system, each of rmw.h and rmx.h contain the RMpipe definitions
 * for Win32 and X11, respectively.
 *
 * This file contains pipe-related tools that are not window-system specific.
 */

/* rmpipe.c + [rmw.c, rmx.c]: pipe routines [22] */
RM_EXPORT_API  RMpipe *rmPipeNew (RMenum targetPlatform);
RM_EXPORT_API  RMenum  rmPipeCreateContext (RMpipe *p);
RM_EXPORT_API  RMenum  rmPipeDelete (RMpipe *toDelete);
RM_EXPORT_API  RMenum  rmPipeMakeCurrent (RMpipe *pipe);
RM_EXPORT_API  RMenum  rmPipeClose (RMpipe *toClose);
RM_EXPORT_API  RMenum  rmPipeSwapBuffers (const RMpipe *p);
RM_EXPORT_API  RMenum  rmPipeSetChannelFormat (RMpipe *toModify, RMenum newChannelFormat);
RM_EXPORT_API  RMenum  rmPipeGetChannelFormat (const RMpipe *toQuery);
RM_EXPORT_API  RMenum  rmPipeSetInitMatrixStackMode(RMpipe *toModify, RMenum newMode);
RM_EXPORT_API  RMenum  rmPipeGetInitMatrixStackMode(const RMpipe *toQuery);
RM_EXPORT_API  RMenum  rmPipeSetRenderPassEnable (RMpipe *t, RMenum opaque3DEnable, RMenum transparent3DEnable, RMenum opaque2DEnable);
RM_EXPORT_API  RMenum  rmPipeGetRenderPassEnable (const RMpipe *t, RMenum *opaque3DEnableReturn, RMenum *transparent3DEnableReturn, RMenum *opaque2DEnableReturn);
RM_EXPORT_API  RMenum  rmPipeSetWindowSize (RMpipe *toModify, int newWidth, int newHeight);
RM_EXPORT_API  RMenum  rmPipeGetWindowSize (const RMpipe *toQuery, int *widthReturn, int *heightReturn);

RM_EXPORT_API  RMenum  rmPipeSetSwapBuffersFunc (RMpipe *toModify, RMenum (*newFunc)(const RMpipe *));
RM_EXPORT_API  RMenum  rmPipeSetPostRenderFunc (RMpipe *toModify, void (*postRenderFunc)(const RMimage *, RMenum));
RM_EXPORT_API  RMenum  rmPipeSetPostRenderDepthFunc (RMpipe *toModify, void (*postRenderDepthFunc)(const RMimage *, RMenum));
RM_EXPORT_API  RMenum  rmPipeSetPostRenderBarrierFunc (RMpipe *toModify, void (*barrierFunc)(RMpipe *));
RM_EXPORT_API  int     rmPipeGetFrameNumber(const RMpipe *toQuery);

/* control over pipeline-parallelism in the rendering engine */
RM_EXPORT_API  RMenum  rmPipeGetProcessingMode(const RMpipe *toQuery);
RM_EXPORT_API  RMenum  rmPipeSetProcessingMode(RMpipe *toModify, RMenum newMode);RM_EXPORT_API  RMenum  rmPipeProcessingModeIsMultithreaded(const RMpipe *toQuery);

/* for Chromium-enabled, MPI/parallel apps */
RM_EXPORT_API  RMenum  rmPipeSetCommSize (RMpipe *toModify, int globalNPE);
RM_EXPORT_API  int     rmPipeGetCommSize (const RMpipe *toQuery);
RM_EXPORT_API  RMenum  rmPipeSetRank     (RMpipe *toModify, int myRank);
RM_EXPORT_API  int     rmPipeGetRank     (const RMpipe *toQuery);

/* global control over display list usage for an RMpipe */
RM_EXPORT_API  RMenum  rmPipeGetDisplayListEnable(const RMpipe *toQuery);
RM_EXPORT_API  RMenum  rmPipeSetDisplayListEnable(RMpipe *toModify, RMenum newMode);

/* constant frame rate stuff */
RM_EXPORT_API  RMenum  rmPipeSetFrameRate(RMpipe *toModify, int newFramesPerSecond);
RM_EXPORT_API  int     rmPipeGetFrameRate(const RMpipe *toQuery);

#if 0
/* used only in X-based apps (CR+GLX, or GLX), set/get $DISPLAY */
RM_EXPORT_API  const char * rmPipeGetDisplayName (const RMpipe *toQuery);
RM_EXPORT_API  RMenum       rmPipeSetDisplayName (RMpipe *toModify, const char *displayName);
RM_EXPORT_API  const void * rmPipeGetDisplay (const RMpipe *toQuery);
RM_EXPORT_API  RMenum       rmPipeSetDisplay (RMpipe *toModify, void *XDisplayStruct);
#endif

/* to be deprecated */
RM_EXPORT_API  RMpipe *rmPipeGetCurrent (void);
RM_EXPORT_API  RMenum  rmPipeInit (const char *display, RMenum channel_format, RMpipe **pipe); /* defined in rmx.c or rmw.c */


#ifdef __cplusplus
}
#endif

#endif /* _rmpipe_h */
/* EOF */
