/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class LanguageOption
extends AbstractOption<Language> {
    private static final Logger logger = Logger.getLogger(LanguageOption.class.getName());
    private static final Map<String, String> languageNames = new HashMap<String, String>();
    private static final List<Language> languages;
    private static final Language DEFAULT_LANGUAGE;
    private Language value = DEFAULT_LANGUAGE;

    public LanguageOption(Specification specification) {
        super(specification);
        LanguageOption.initializeLanguages();
    }

    private static void initializeLanguages() {
        if (!languages.isEmpty()) {
            return;
        }
        File i18nDirectory = FreeColDirectories.getI18nDirectory();
        File[] files = i18nDirectory.listFiles();
        if (files == null) {
            throw new RuntimeException("No language files could be found in the <" + i18nDirectory + "> directory.");
        }
        for (File file : files) {
            String nam = file.getName();
            if (nam == null || !nam.startsWith("FreeColMessages") || !nam.endsWith(".properties")) continue;
            String languageId = nam.substring("FreeColMessages".length(), nam.length() - ".properties".length());
            if ("".equals(languageId)) {
                languageId = "en";
            } else {
                if ("_qqq".equals(languageId)) continue;
                if (languageId.startsWith("_")) {
                    languageId = languageId.substring(1);
                }
            }
            try {
                languages.add(new Language(languageId, Messages.getLocale(languageId)));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to add: " + languageId, e);
            }
        }
        Collections.sort(languages);
        languages.add(0, DEFAULT_LANGUAGE);
    }

    private Language getLanguage(String key) {
        return CollectionUtils.find(languages, l -> key.equals(l.getKey()));
    }

    public List<Language> getChoices() {
        return new ArrayList<Language>(languages);
    }

    @Override
    public LanguageOption clone() {
        LanguageOption result = new LanguageOption(this.getSpecification());
        result.setValues(this);
        return result;
    }

    @Override
    public final Language getValue() {
        return this.value;
    }

    @Override
    public final void setValue(Language newValue) {
        Language oldValue = this.value;
        this.value = newValue;
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        Language l = null;
        if (l == null && valueString != null) {
            l = this.getLanguage(valueString);
        }
        if (l == null && defaultValueString != null) {
            l = this.getLanguage(defaultValueString);
        }
        if (l == null) {
            l = this.getLanguage("automatic");
        }
        this.setValue(l);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.getValue().getKey());
    }

    @Override
    public String getXMLTagName() {
        return LanguageOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "languageOption";
    }

    static {
        languageNames.put("arz", "\u0645\u0635\u0631\u064a");
        languageNames.put("hsb", "Serb\u0161\u0107ina");
        languageNames.put("nds", "Plattd\u00fc\u00fctsch");
        languageNames.put("pms", "Piemont\u00e9s");
        languageNames.put("be-tarask", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f (\u0442\u0430\u0440\u0430\u0448\u043a\u0435\u0432\u0456\u0446\u0430)");
        languages = new ArrayList<Language>();
        DEFAULT_LANGUAGE = new Language("automatic", Locale.getDefault());
    }

    public static class Language
    implements Comparable<Language> {
        private String key;
        private Locale locale;

        public Language(String key, Locale locale) {
            this.key = key;
            this.locale = locale;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String newKey) {
            this.key = newKey;
        }

        public final Locale getLocale() {
            return this.locale;
        }

        public final void setLocale(Locale newLocale) {
            this.locale = newLocale;
        }

        @Override
        public int compareTo(Language l) {
            return this.toString().compareTo(l.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Language) {
                Language l = (Language)o;
                return Utils.equals(this.key, l.key) && super.equals(o);
            }
            return false;
        }

        public int hashCode() {
            int hash = super.hashCode();
            return 31 * hash + Utils.hashCode(this.key);
        }

        public String toString() {
            if ("automatic".equals(this.getKey())) {
                return Messages.message("clientOptions.gui.languageOption.autoDetectLanguage");
            }
            String name = this.locale.getDisplayName(this.locale);
            if (name.equals(this.key) && languageNames.containsKey(this.key)) {
                name = (String)languageNames.get(this.key);
            }
            return name.substring(0, 1).toUpperCase(this.locale) + name.substring(1);
        }
    }
}

