## mysql
# MultiLangItemMap
CREATE TABLE DB_TABLE_PREFIXMultiLangItemMap(
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXlanguage varchar(32) NOT NULL,
 DB_COLUMN_PREFIXtitle varchar(128),
 DB_COLUMN_PREFIXsummary varchar(255),
 DB_COLUMN_PREFIXdescription text,
 PRIMARY KEY(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXlanguage)
) DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MultiLangItemMap', 1, 0);

## postgres
# MultiLangItemMap
CREATE TABLE DB_TABLE_PREFIXMultiLangItemMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXlanguage VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXtitle VARCHAR(128),
 DB_COLUMN_PREFIXsummary VARCHAR(255),
 DB_COLUMN_PREFIXdescription text
);

ALTER TABLE DB_TABLE_PREFIXMultiLangItemMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXlanguage);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MultiLangItemMap', 1, 0);

## oracle
# MultiLangItemMap
CREATE TABLE DB_TABLE_PREFIXMultiLangItemMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXlanguage VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXtitle VARCHAR2(128),
 DB_COLUMN_PREFIXsummary VARCHAR2(255),
 DB_COLUMN_PREFIXdescription VARCHAR2(4000)
);

ALTER TABLE DB_TABLE_PREFIXMultiLangItemMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXlanguage)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MultiLangItemMap', 1, 0);

## db2
# MultiLangItemMap
CREATE TABLE DB_TABLE_PREFIXMultiLangItemMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXlanguage VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXtitle VARCHAR(128),
 DB_COLUMN_PREFIXsummary VARCHAR(255),
 DB_COLUMN_PREFIXdescription VARCHAR(10000)
);

ALTER TABLE DB_TABLE_PREFIXMultiLangItemMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXlanguage);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MultiLangItemMap', 1, 0);

## mssql
# MultiLangItemMap
CREATE TABLE DB_TABLE_PREFIXMultiLangItemMap(
 DB_COLUMN_PREFIXitemId INT NOT NULL,
 DB_COLUMN_PREFIXlanguage NVARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXtitle NVARCHAR(128) NULL,
 DB_COLUMN_PREFIXsummary NVARCHAR(255) NULL,
 DB_COLUMN_PREFIXdescription NVARCHAR(MAX) NULL
);

ALTER TABLE DB_TABLE_PREFIXMultiLangItemMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXlanguage);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MultiLangItemMap', 1, 0);

## sqlite
# MultiLangItemMap
CREATE TABLE DB_TABLE_PREFIXMultiLangItemMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXlanguage TEXT NOT NULL,
 DB_COLUMN_PREFIXtitle TEXT,
 DB_COLUMN_PREFIXsummary TEXT,
 DB_COLUMN_PREFIXdescription TEXT
);

CREATE UNIQUE INDEX DB_TABLE_PREFIXMultiLangItemMap_pkey ON DB_TABLE_PREFIXMultiLangItemMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXlanguage);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MultiLangItemMap', 1, 0);

